/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jooby.Deferred;
import org.jooby.Err;
import org.jooby.MediaType;
import org.jooby.Renderer;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.Session;
import org.jooby.Sse;
import org.jooby.Status;
import org.jooby.WebSocket;
import org.jooby.funzy.Try;
import org.jooby.internal.DeferredExecution;
import org.jooby.internal.RequestImpl;
import org.jooby.internal.RequestScope;
import org.jooby.internal.ResponseImpl;
import org.jooby.internal.RouteChain;
import org.jooby.internal.RouteImpl;
import org.jooby.internal.RouteWithFilter;
import org.jooby.internal.StatusCodeProvider;
import org.jooby.internal.WebSocketImpl;
import org.jooby.internal.parser.ParserExecutor;
import org.jooby.spi.HttpHandler;
import org.jooby.spi.NativeRequest;
import org.jooby.spi.NativeResponse;
import org.jooby.spi.NativeWebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HttpHandlerImpl
implements HttpHandler {
    private static final String NO_CACHE = "must-revalidate,no-cache,no-store";
    private static final String WEB_SOCKET = "WebSocket";
    private static final String UPGRADE = "Upgrade";
    private static final String REFERER = "Referer";
    private static final String PATH = "path";
    private static final String CONTEXT_PATH = "contextPath";
    private static final Key<Request> REQ = Key.get(Request.class);
    private static final Key<Route.Chain> CHAIN = Key.get(Route.Chain.class);
    private static final Key<Response> RSP = Key.get(Response.class);
    private static final Key<Sse> SSE = Key.get(Sse.class);
    private static final Key<Session> SESS = Key.get(Session.class);
    private static final Key<String> DEF_EXEC = Key.get(String.class, (Annotation)Names.named((String)"deferred"));
    private static final String BYTE_RANGE = "Range";
    private Injector injector;
    private Set<Err.Handler> err;
    private String applicationPath;
    private RequestScope requestScope;
    private Set<WebSocket.Definition> socketDefs;
    private Config config;
    private int port;
    private String _method;
    private Charset charset;
    private List<Renderer> renderers;
    private ParserExecutor parserExecutor;
    private List<Locale> locales;
    private final LoadingCache<RouteKey, Route[]> routeCache;
    private final String redirectHttps;
    private Function<String, String> rpath = null;
    private String contextPath;
    private boolean hasSockets;
    private final Map<String, Renderer> rendererMap;
    private StatusCodeProvider sc;
    private Key<Executor> gexec;

    @Inject
    public HttpHandlerImpl(Injector injector, RequestScope requestScope, Set<Route.Definition> routes, Set<WebSocket.Definition> sockets, @Named(value="application.path") String path, ParserExecutor parserExecutor, Set<Renderer> renderers, Set<Err.Handler> err, StatusCodeProvider sc, Charset charset, List<Locale> locale) {
        this.injector = Objects.requireNonNull(injector, "An injector is required.");
        this.requestScope = Objects.requireNonNull(requestScope, "A request scope is required.");
        this.socketDefs = Objects.requireNonNull(sockets, "Sockets are required.");
        this.hasSockets = this.socketDefs.size() > 0;
        this.applicationPath = HttpHandlerImpl.normalizeURI(Objects.requireNonNull(path, "An application.path is required."));
        this.err = Objects.requireNonNull(err, "An err handler is required.");
        this.sc = sc;
        this.config = (Config)injector.getInstance(Config.class);
        this._method = Strings.emptyToNull((String)this.config.getString("server.http.Method").trim());
        this.port = this.config.getInt("application.port");
        this.charset = charset;
        this.locales = locale;
        this.parserExecutor = parserExecutor;
        this.renderers = new ArrayList<Renderer>(renderers);
        this.rendererMap = new HashMap<String, Renderer>();
        this.renderers.forEach(r -> this.rendererMap.put(r.name(), (Renderer)r));
        this.routeCache = HttpHandlerImpl.routeCache(routes, this.config);
        String redirectHttps = this.config.getString("application.redirect_https").trim();
        String string = this.redirectHttps = redirectHttps.length() > 0 ? redirectHttps : null;
        if (this.applicationPath.equals("/")) {
            this.contextPath = "";
        } else {
            this.contextPath = this.applicationPath;
            this.rpath = HttpHandlerImpl.rootpath(this.applicationPath);
        }
        this.gexec = Key.get(Executor.class, (Annotation)Names.named((String)((String)injector.getInstance(DEF_EXEC))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void handle(NativeRequest request, NativeResponse response) throws Exception {
        Throwable x;
        boolean deferred;
        MediaType type;
        ResponseImpl rsp;
        RequestImpl req;
        String path;
        String method;
        HashMap<Object, Object> scope;
        block11: {
            Optional<WebSocket> sockets;
            block10: {
                Map<String, Object> nativeAttrs;
                long start = System.currentTimeMillis();
                HashMap<String, Object> locals = new HashMap<String, Object>(16);
                scope = new HashMap<Object, Object>(16);
                method = this._method == null ? request.method() : HttpHandlerImpl.method(this._method, request);
                path = HttpHandlerImpl.normalizeURI(request.path());
                if (this.rpath != null) {
                    path = this.rpath.apply(path);
                }
                if ((nativeAttrs = request.attributes()).size() > 0) {
                    locals.putAll(nativeAttrs);
                }
                locals.put(CONTEXT_PATH, this.contextPath);
                locals.put(PATH, path);
                RouteWithFilter notFound = RouteImpl.notFound(method, path);
                req = new RequestImpl(this.injector, request, this.contextPath, this.port, notFound, this.charset, this.locales, scope, locals, start);
                rsp = new ResponseImpl(req, this.parserExecutor, response, notFound, this.renderers, this.rendererMap, locals, req.charset(), request.header(REFERER), request.header(BYTE_RANGE));
                type = req.type();
                scope.put(REQ, req);
                scope.put(RSP, rsp);
                Provider sse = () -> (Sse)Try.apply(() -> request.upgrade(Sse.class)).get();
                scope.put(SSE, sse);
                Provider session = () -> req.session();
                scope.put(SESS, session);
                deferred = false;
                x = null;
                this.requestScope.enter(scope);
                if (this.redirectHttps == null || req.secure()) break block10;
                rsp.redirect(MessageFormat.format(this.redirectHttps, path.substring(1)));
                this.cleanup(req, rsp, true, x, !deferred);
                return;
            }
            if (!this.hasSockets || !this.upgrade(request) || !(sockets = HttpHandlerImpl.findSockets(this.socketDefs, path)).isPresent()) break block11;
            NativeWebSocket ws = request.upgrade(NativeWebSocket.class);
            ws.onConnect(() -> ((WebSocketImpl)sockets.get()).connect(this.injector, req, ws));
            this.cleanup(req, rsp, true, x, !deferred);
            return;
        }
        try {
            Route[] routes = (Route[])this.routeCache.getUnchecked((Object)new RouteKey(method, path, type, req.accept()));
            RouteChain chain = new RouteChain(req, rsp, routes);
            scope.put(CHAIN, chain);
            chain.next(req, rsp);
            this.cleanup(req, rsp, true, x, !deferred);
        }
        catch (DeferredExecution ex) {
            deferred = true;
            this.onDeferred(scope, request, req, rsp, ex.deferred);
            this.cleanup(req, rsp, true, x, !deferred);
        }
        catch (Throwable ex2) {
            x = ex2;
            this.cleanup(req, rsp, true, x, !deferred);
            {
                catch (Throwable throwable) {
                    this.cleanup(req, rsp, true, x, !deferred);
                    throw throwable;
                }
            }
        }
    }

    private boolean upgrade(NativeRequest request) {
        Optional<String> upgrade = request.header(UPGRADE);
        return upgrade.isPresent() && upgrade.get().equalsIgnoreCase(WEB_SOCKET);
    }

    private void done(RequestImpl req, ResponseImpl rsp, Throwable x, boolean close) {
        req.done();
        if (close) {
            rsp.done(Optional.ofNullable(x));
        }
    }

    private void onDeferred(Map<Object, Object> scope, NativeRequest request, RequestImpl req, ResponseImpl rsp, Deferred deferred) {
        Key<Executor> execKey = deferred.executor().map(it -> Key.get(Executor.class, (Annotation)Names.named((String)it))).orElse(this.gexec);
        Executor executor = (Executor)this.injector.getInstance(execKey);
        request.startAsync(executor, () -> {
            try {
                deferred.handler(req, (success, x) -> {
                    boolean close = false;
                    Optional<Throwable> failure = Optional.ofNullable(x);
                    try {
                        this.requestScope.enter(scope);
                        if (success != null) {
                            close = true;
                            rsp.send(success);
                        }
                    }
                    catch (Throwable exerr) {
                        failure = Optional.of(failure.orElse(exerr));
                    }
                    finally {
                        Throwable cause = failure.orElse(null);
                        if (cause != null) {
                            close = true;
                        }
                        this.cleanup(req, rsp, close, cause, true);
                    }
                });
            }
            catch (Exception ex) {
                this.handleErr(req, rsp, ex);
            }
        });
    }

    private void cleanup(RequestImpl req, ResponseImpl rsp, boolean close, Throwable x, boolean done) {
        if (x != null) {
            this.handleErr(req, rsp, x);
        }
        if (done) {
            this.done(req, rsp, x, close);
        }
        this.requestScope.exit();
    }

    private void handleErr(RequestImpl req, ResponseImpl rsp, Throwable ex) {
        Logger log = LoggerFactory.getLogger(HttpHandler.class);
        try {
            log.debug("execution of: {}{} resulted in exception", new Object[]{req.method(), req.path(), ex});
            Status status = this.sc.apply(ex);
            if (status == Status.REQUESTED_RANGE_NOT_SATISFIABLE) {
                String range = rsp.header("Content-Length").toOptional().map(it -> "bytes */" + it).orElse("*");
                rsp.reset();
                rsp.header("Content-Range", (Object)range);
            } else {
                rsp.reset();
            }
            rsp.header("Cache-Control", (Object)NO_CACHE);
            rsp.status(status);
            Err err = ex instanceof Err ? (Err)ex : new Err(status, ex);
            Iterator<Err.Handler> it2 = this.err.iterator();
            while (!rsp.committed() && it2.hasNext()) {
                Err.Handler next = it2.next();
                log.debug("handling err with: {}", (Object)next);
                next.handle(req, rsp, err);
            }
        }
        catch (Throwable errex) {
            log.error("error handler resulted in exception: {}{}\nRoute:\n{}\n\nStacktrace:\n{}\nSource:", new Object[]{req.method(), req.path(), req.route().print(6), Throwables.getStackTraceAsString((Throwable)errex), ex});
        }
    }

    private static String normalizeURI(String uri) {
        int len = uri.length();
        return len > 1 && uri.charAt(len - 1) == '/' ? uri.substring(0, len - 1) : uri;
    }

    private static Route[] routes(Set<Route.Definition> routeDefs, String method, String path, MediaType type, List<MediaType> accept) {
        List<Route> routes = HttpHandlerImpl.findRoutes(routeDefs, method, path, type, accept);
        routes.add(RouteImpl.fallback((req, rsp, chain) -> {
            if (!rsp.status().isPresent()) {
                Err ex = HttpHandlerImpl.handle406or415(routeDefs, method, path, type, accept);
                if (ex != null) {
                    throw ex;
                }
                ex = HttpHandlerImpl.handle405(routeDefs, method, path, type, accept);
                if (ex != null) {
                    throw ex;
                }
                if (path.equals("/favicon.ico")) {
                    rsp.status(Status.NOT_FOUND).end();
                } else {
                    throw new Err(Status.NOT_FOUND, req.path(true));
                }
            }
        }, method, path, "err", accept));
        return routes.toArray(new Route[routes.size()]);
    }

    private static List<Route> findRoutes(Set<Route.Definition> routeDefs, String method, String path, MediaType type, List<MediaType> accept) {
        ArrayList<Route> routes = new ArrayList<Route>();
        for (Route.Definition routeDef : routeDefs) {
            Optional<Route> route = routeDef.matches(method, path, type, accept);
            if (!route.isPresent()) continue;
            routes.add(route.get());
        }
        return routes;
    }

    private static Optional<WebSocket> findSockets(Set<WebSocket.Definition> sockets, String path) {
        for (WebSocket.Definition socketDef : sockets) {
            Optional<WebSocket> match = socketDef.matches(path);
            if (!match.isPresent()) continue;
            return match;
        }
        return Optional.empty();
    }

    private static Err handle405(Set<Route.Definition> routeDefs, String method, String path, MediaType type, List<MediaType> accept) {
        if (HttpHandlerImpl.alternative(routeDefs, method, path).size() > 0) {
            return new Err(Status.METHOD_NOT_ALLOWED, method);
        }
        return null;
    }

    private static List<Route> alternative(Set<Route.Definition> routeDefs, String verb, String uri) {
        LinkedList<Route> routes = new LinkedList<Route>();
        HashSet verbs = Sets.newHashSet(Route.METHODS);
        verbs.remove(verb);
        for (String alt : verbs) {
            HttpHandlerImpl.findRoutes(routeDefs, alt, uri, MediaType.all, MediaType.ALL).stream().filter(r -> !r.pattern().contains("*")).forEach(routes::add);
        }
        return routes;
    }

    private static Err handle406or415(Set<Route.Definition> routeDefs, String method, String path, MediaType contentType, List<MediaType> accept) {
        for (Route.Definition routeDef : routeDefs) {
            Optional<Route> route = routeDef.matches(method, path, MediaType.all, MediaType.ALL);
            if (!route.isPresent() || route.get().pattern().contains("*")) continue;
            if (!routeDef.canProduce(accept)) {
                return new Err(Status.NOT_ACCEPTABLE, accept.stream().map(MediaType::name).collect(Collectors.joining(", ")));
            }
            if (contentType.isAny()) continue;
            return new Err(Status.UNSUPPORTED_MEDIA_TYPE, contentType.name());
        }
        return null;
    }

    private static String method(String methodParam, NativeRequest request) throws Exception {
        Optional<String> header = request.header(methodParam);
        if (header.isPresent()) {
            return header.get();
        }
        List<String> param = request.params(methodParam);
        return param.size() == 0 ? request.method() : param.get(0);
    }

    private static LoadingCache<RouteKey, Route[]> routeCache(final Set<Route.Definition> routes, Config conf) {
        return CacheBuilder.from((String)conf.getString("server.routes.Cache")).build((CacheLoader)new CacheLoader<RouteKey, Route[]>(){

            public Route[] load(RouteKey key) throws Exception {
                return HttpHandlerImpl.routes(routes, key.method, key.path, key.consumes, key.produces);
            }
        });
    }

    private static Function<String, String> rootpath(String applicationPath) {
        return p -> {
            if (applicationPath.equals(p)) {
                return "/";
            }
            if (p.startsWith(applicationPath)) {
                return p.substring(applicationPath.length());
            }
            return Route.errpath(p);
        };
    }

    private static class RouteKey {
        private final String method;
        private final String path;
        private final MediaType consumes;
        private final List<MediaType> produces;
        private final String key;

        public RouteKey(String method, String path, MediaType consumes, List<MediaType> produces) {
            String c = consumes.name();
            String p = produces.toString();
            this.key = new StringBuilder(method.length() + path.length() + c.length() + p.length()).append(method).append(path).append(c).append(p).toString();
            this.method = method;
            this.path = path;
            this.consumes = consumes;
            this.produces = produces;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            RouteKey that = (RouteKey)obj;
            return this.key.equals(that.key);
        }
    }
}

