/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import org.jooby.Cookie;

public class CookieImpl
implements Cookie {
    static final DateTimeFormatter fmt = DateTimeFormatter.ofPattern("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.ENGLISH).withZone(ZoneId.of("GMT"));
    private static final String __COOKIE_DELIM = "\",;\\ \t";
    private String name;
    private Optional<String> value;
    private Optional<String> comment;
    private Optional<String> domain;
    private int maxAge;
    private Optional<String> path;
    private boolean secure;
    private boolean httpOnly;

    public CookieImpl(Cookie.Definition cookie) {
        this.name = cookie.name().orElseThrow(() -> new IllegalArgumentException("Cookie name missing"));
        this.value = cookie.value();
        this.comment = cookie.comment();
        this.domain = cookie.domain();
        this.maxAge = cookie.maxAge().orElse(-1);
        this.path = cookie.path();
        this.secure = cookie.secure().orElse(Boolean.FALSE);
        this.httpOnly = cookie.httpOnly().orElse(Boolean.FALSE);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Optional<String> value() {
        return this.value;
    }

    @Override
    public Optional<String> comment() {
        return this.comment;
    }

    @Override
    public Optional<String> domain() {
        return this.domain;
    }

    @Override
    public int maxAge() {
        return this.maxAge;
    }

    @Override
    public Optional<String> path() {
        return this.path;
    }

    @Override
    public boolean secure() {
        return this.secure;
    }

    @Override
    public boolean httpOnly() {
        return this.httpOnly;
    }

    @Override
    public String encode() {
        int maxAge;
        StringBuilder sb = new StringBuilder();
        Consumer<String> appender = str -> {
            if (CookieImpl.needQuote(str)) {
                sb.append('\"');
                for (int i = 0; i < str.length(); ++i) {
                    char c = str.charAt(i);
                    if (c == '\"' || c == '\\') {
                        sb.append('\\');
                    }
                    sb.append(c);
                }
                sb.append('\"');
            } else {
                sb.append((String)str);
            }
        };
        appender.accept(this.name());
        sb.append("=");
        this.value().ifPresent(appender);
        sb.append(";Version=1");
        this.path().ifPresent(path -> {
            sb.append(";Path=");
            appender.accept((String)path);
        });
        this.domain().ifPresent(domain -> {
            sb.append(";Domain=");
            appender.accept((String)domain);
        });
        if (this.secure()) {
            sb.append(";Secure");
        }
        if (this.httpOnly()) {
            sb.append(";HttpOnly");
        }
        if ((maxAge = this.maxAge()) >= 0) {
            sb.append(";Max-Age=").append(maxAge);
            Instant instant = Instant.ofEpochMilli(maxAge > 0 ? System.currentTimeMillis() + (long)maxAge * 1000L : 0L);
            sb.append(";Expires=").append(fmt.format(instant));
        }
        this.comment().ifPresent(comment -> {
            sb.append(";Comment=");
            appender.accept((String)comment);
        });
        return sb.toString();
    }

    public String toString() {
        return this.encode();
    }

    private static boolean needQuote(String s) {
        if (s.length() > 1 && s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (__COOKIE_DELIM.indexOf(c) >= 0) {
                return true;
            }
            if (c >= ' ' && c < '\u007f') continue;
            throw new IllegalArgumentException("Illegal character fount at: [" + i + "]");
        }
        return false;
    }
}

