/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.google.common.base.Splitter;
import java.util.Iterator;
import java.util.function.BiFunction;
import org.jooby.Err;
import org.jooby.Status;

public class ByteRange {
    private static final String BYTES_EQ = "bytes=";

    public static long[] parse(String value) {
        if (!value.startsWith(BYTES_EQ)) {
            throw new Err(Status.REQUESTED_RANGE_NOT_SATISFIABLE, value);
        }
        BiFunction<String, Integer, Long> number = (it, offset) -> {
            try {
                return Long.parseLong(it.substring((int)offset));
            }
            catch (IndexOutOfBoundsException | NumberFormatException x) {
                throw new Err(Status.REQUESTED_RANGE_NOT_SATISFIABLE, value);
            }
        };
        Iterator ranges = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)value.substring(BYTES_EQ.length())).iterator();
        if (ranges.hasNext()) {
            String range = (String)ranges.next();
            int dash = range.indexOf(45);
            if (dash == 0) {
                return new long[]{-1L, number.apply(range, 1)};
            }
            if (dash > 0) {
                Long start = number.apply(range.substring(0, dash), 0);
                int endidx = dash + 1;
                Long end = endidx < range.length() ? number.apply(range, endidx) : Long.valueOf(-1L);
                return new long[]{start, end};
            }
        }
        throw new Err(Status.REQUESTED_RANGE_NOT_SATISFIABLE, value);
    }
}

