/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import org.jooby.Parser;
import org.jooby.funzy.Try;

public class BodyReferenceImpl
implements Parser.BodyReference {
    private Charset charset;
    private long length;
    private File file;
    private byte[] bytes;

    public BodyReferenceImpl(long length, Charset charset, File file, InputStream in, long bufferSize) throws IOException {
        this.length = length;
        this.charset = charset;
        if (length < bufferSize) {
            this.bytes = BodyReferenceImpl.toByteArray(in);
        } else {
            this.file = BodyReferenceImpl.copy(file, in);
        }
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public byte[] bytes() throws IOException {
        if (this.bytes == null) {
            return Files.readAllBytes(this.file.toPath());
        }
        return this.bytes;
    }

    @Override
    public String text() throws IOException {
        return new String(this.bytes(), this.charset);
    }

    @Override
    public void writeTo(OutputStream output) throws IOException {
        if (this.bytes == null) {
            Files.copy(this.file.toPath(), output);
        } else {
            output.write(this.bytes);
        }
    }

    private static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BodyReferenceImpl.copy(in, out);
        return out.toByteArray();
    }

    private static File copy(File file, InputStream in) throws IOException {
        file.getParentFile().mkdirs();
        BodyReferenceImpl.copy(in, new FileOutputStream(file));
        return file;
    }

    private static void copy(InputStream in, OutputStream out) {
        Try.of((AutoCloseable)in, (AutoCloseable)out).run(ByteStreams::copy).throwException();
    }
}

