/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.google.common.base.Joiner;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooby.Err;
import org.jooby.MediaType;
import org.jooby.Renderer;
import org.jooby.Status;
import org.jooby.View;
import org.jooby.internal.ReaderInputStream;

public abstract class AbstractRendererContext
implements Renderer.Context {
    private Locale locale;
    private List<Renderer> renderers;
    private MediaType.Matcher matcher;
    protected final Charset charset;
    private Map<String, Object> locals;
    private List<MediaType> produces;
    private boolean committed;
    private int rsize;

    public AbstractRendererContext(List<Renderer> renderers, List<MediaType> produces, Charset charset, Locale locale, Map<String, Object> locals) {
        this.renderers = renderers;
        this.produces = produces;
        this.charset = charset;
        this.locale = locale;
        this.locals = locals;
        this.rsize = this.renderers.size();
    }

    public void render(Object value) throws Exception {
        FileNotFoundException notFound = null;
        for (int i = 0; !this.committed && i < this.rsize; ++i) {
            Renderer next = this.renderers.get(i);
            try {
                next.render(value, this);
                continue;
            }
            catch (FileNotFoundException x) {
                if (next instanceof View.Engine) {
                    if (notFound != null) continue;
                    notFound = x;
                    continue;
                }
                throw x;
            }
        }
        if (!this.committed) {
            if (notFound != null) {
                throw notFound;
            }
            throw new Err(Status.NOT_ACCEPTABLE, Joiner.on((String)", ").join(this.produces));
        }
    }

    @Override
    public Locale locale() {
        return this.locale;
    }

    @Override
    public Map<String, Object> locals() {
        return this.locals;
    }

    @Override
    public boolean accepts(MediaType type) {
        if (this.matcher == null) {
            this.matcher = MediaType.matcher(this.produces);
        }
        return this.matcher.matches(type);
    }

    @Override
    public Renderer.Context type(MediaType type) {
        return this;
    }

    @Override
    public Renderer.Context length(long length) {
        return this;
    }

    @Override
    public Charset charset() {
        return this.charset;
    }

    @Override
    public void send(CharBuffer buffer) throws Exception {
        this.type(MediaType.html);
        this.send(this.charset.encode(buffer));
    }

    @Override
    public void send(Reader reader) throws Exception {
        this.type(MediaType.html);
        this.send(new ReaderInputStream(reader, this.charset));
    }

    @Override
    public void send(String text) throws Exception {
        this.type(MediaType.html);
        byte[] bytes = text.getBytes(this.charset);
        this.length(bytes.length);
        this._send(bytes);
        this.committed = true;
    }

    @Override
    public void send(byte[] bytes) throws Exception {
        this.type(MediaType.octetstream);
        this.length(bytes.length);
        this._send(bytes);
        this.committed = true;
    }

    @Override
    public void send(ByteBuffer buffer) throws Exception {
        this.type(MediaType.octetstream);
        this.length(buffer.remaining());
        this._send(buffer);
        this.committed = true;
    }

    @Override
    public void send(FileChannel file) throws Exception {
        this.type(MediaType.octetstream);
        this.length(file.size());
        this._send(file);
        this.committed = true;
    }

    @Override
    public void send(InputStream stream) throws Exception {
        this.type(MediaType.octetstream);
        if (stream instanceof FileInputStream) {
            this.send(((FileInputStream)stream).getChannel());
        } else {
            this._send(stream);
        }
        this.committed = true;
    }

    protected void setCommitted() {
        this.committed = true;
    }

    public String toString() {
        return this.renderers.stream().map(Renderer::name).collect(Collectors.joining(", "));
    }

    protected abstract void _send(byte[] var1) throws Exception;

    protected abstract void _send(ByteBuffer var1) throws Exception;

    protected abstract void _send(FileChannel var1) throws Exception;

    protected abstract void _send(InputStream var1) throws Exception;
}

