/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.handlers;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jooby.Err;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.Session;
import org.jooby.Status;

public class CsrfHandler
implements Route.Filter {
    private final Set<String> REQUIRE_ON = ImmutableSet.of((Object)"POST", (Object)"PUT", (Object)"DELETE", (Object)"PATCH");
    private String name;
    private Function<Request, String> generator;
    private Predicate<Request> requireToken;

    public CsrfHandler(String name) {
        this.name = Objects.requireNonNull(name, "Name is required.");
        this.tokenGen(req -> UUID.randomUUID().toString());
        this.requireTokenOn(req -> this.REQUIRE_ON.contains(req.method()));
    }

    public CsrfHandler() {
        this("csrf");
    }

    public CsrfHandler tokenGen(Function<Request, String> generator) {
        this.generator = Objects.requireNonNull(generator, "Generator is required.");
        return this;
    }

    public CsrfHandler requireTokenOn(Predicate<Request> requireToken) {
        this.requireToken = Objects.requireNonNull(requireToken, "RequireToken predicate is required.");
        return this;
    }

    @Override
    public void handle(Request req, Response rsp, Route.Chain chain) throws Throwable {
        String candidate;
        Session session = req.session();
        String token = session.get(this.name).toOptional().orElseGet(() -> {
            String newToken = this.generator.apply(req);
            session.set(this.name, newToken);
            return newToken;
        });
        req.set(this.name, (Object)token);
        if (this.requireToken.test(req) && !token.equals(candidate = req.header(this.name).toOptional().orElseGet(() -> req.param(this.name).toOptional().orElse(null)))) {
            throw new Err(Status.FORBIDDEN, "Invalid Csrf token: " + candidate);
        }
        chain.next(req, rsp);
    }
}

