/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.handlers;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.Status;
import org.jooby.handlers.Cors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorsHandler
implements Route.Filter {
    private static final String ORIGIN = "Origin";
    private static final String ANY_ORIGIN = "*";
    private static final String AC_REQUEST_METHOD = "Access-Control-Request-Method";
    private static final String AC_REQUEST_HEADERS = "Access-Control-Request-Headers";
    private static final String AC_MAX_AGE = "Access-Control-Max-Age";
    private static final String AC_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    private static final String AC_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String AC_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    private static final String AC_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    private static final String AC_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private final Logger log = LoggerFactory.getLogger(Cors.class);
    private Optional<Cors> cors = Optional.empty();

    public CorsHandler(Cors cors) {
        this.cors = Optional.of(Objects.requireNonNull(cors, "Cors is required."));
    }

    public CorsHandler() {
    }

    @Override
    public void handle(Request req, Response rsp, Route.Chain chain) throws Throwable {
        Optional<String> origin = req.header(ORIGIN).toOptional();
        Cors cors = this.cors.orElseGet(() -> req.require(Cors.class));
        if (cors.enabled() && origin.isPresent()) {
            this.cors(cors, req, rsp, origin.get());
        }
        chain.next(req, rsp);
    }

    private void cors(Cors cors, Request req, Response rsp, String origin) throws Exception {
        if (cors.allowOrigin(origin)) {
            this.log.debug("allowed origin: {}", (Object)origin);
            if (this.preflight(req)) {
                this.log.debug("handling preflight for: {}", (Object)origin);
                this.preflight(cors, req, rsp, origin);
            } else {
                this.log.debug("handling simple cors for: {}", (Object)origin);
                if ("null".equals(origin)) {
                    rsp.header(AC_ALLOW_ORIGIN, (Object)ANY_ORIGIN);
                } else {
                    rsp.header(AC_ALLOW_ORIGIN, (Object)origin);
                    if (!cors.anyOrigin()) {
                        rsp.header("Vary", (Object)ORIGIN);
                    }
                    if (cors.credentials()) {
                        rsp.header(AC_ALLOW_CREDENTIALS, (Object)true);
                    }
                    if (!cors.exposedHeaders().isEmpty()) {
                        rsp.header(AC_EXPOSE_HEADERS, (Object)this.join(cors.exposedHeaders()));
                    }
                }
            }
        }
    }

    private boolean preflight(Request req) {
        return req.method().equals("OPTIONS") && req.header(AC_REQUEST_METHOD).isSet();
    }

    private void preflight(Cors cors, Request req, Response rsp, String origin) {
        boolean allowMethod = req.header(AC_REQUEST_METHOD).toOptional().map(cors::allowMethod).orElse(false);
        if (!allowMethod) {
            return;
        }
        List<String> headers = req.header(AC_REQUEST_HEADERS).toOptional().map(header -> Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)header)).orElse(Collections.emptyList());
        if (!cors.allowHeaders(headers)) {
            return;
        }
        rsp.header(AC_ALLOW_METHODS, (Object)this.join(cors.allowedMethods()));
        List<String> allowedHeaders = cors.anyHeader() ? headers : cors.allowedHeaders();
        rsp.header(AC_ALLOW_HEADERS, (Object)this.join(allowedHeaders));
        if (cors.credentials()) {
            rsp.header(AC_ALLOW_CREDENTIALS, (Object)true);
        }
        if (cors.maxAge() > 0) {
            rsp.header(AC_MAX_AGE, (Object)cors.maxAge());
        }
        rsp.header(AC_ALLOW_ORIGIN, (Object)origin);
        if (!cors.anyOrigin()) {
            rsp.header("Vary", (Object)ORIGIN);
        }
        rsp.status(Status.OK).end();
    }

    private String join(List<String> values) {
        return Joiner.on((char)',').join(values);
    }
}

