/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.handlers;

import com.google.common.collect.ImmutableList;
import com.typesafe.config.Config;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;

public class Cors {
    private boolean enabled;
    private Matcher<String> origin;
    private boolean credentials;
    private Matcher<String> requestMehods;
    private Matcher<List<String>> requestHeaders;
    private int maxAge;
    private List<String> exposedHeaders;

    @Inject
    public Cors(@Named(value="cors") Config config) {
        Objects.requireNonNull(config, "Config is required.");
        this.enabled = config.hasPath("enabled") ? config.getBoolean("enabled") : true;
        this.withOrigin(this.list(config.getAnyRef("origin")));
        this.credentials = config.getBoolean("credentials");
        this.withMethods(this.list(config.getAnyRef("allowedMethods")));
        this.withHeaders(this.list(config.getAnyRef("allowedHeaders")));
        this.withMaxAge((int)config.getDuration("maxAge", TimeUnit.SECONDS));
        this.withExposedHeaders(config.hasPath("exposedHeaders") ? this.list(config.getAnyRef("exposedHeaders")) : Collections.emptyList());
    }

    public Cors() {
        this.enabled = true;
        this.withOrigin("*");
        this.credentials = true;
        this.withMethods("GET", "POST");
        this.withHeaders("X-Requested-With", "Content-Type", "Accept", "Origin");
        this.withMaxAge(1800);
        this.withExposedHeaders(new String[0]);
    }

    public Cors withoutCreds() {
        this.credentials = false;
        return this;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Cors disabled() {
        this.enabled = false;
        return this;
    }

    public boolean credentials() {
        return this.credentials;
    }

    public boolean anyOrigin() {
        return ((Matcher)this.origin).wild;
    }

    public List<String> origin() {
        return ((Matcher)this.origin).values;
    }

    public boolean allowOrigin(String origin) {
        return this.origin.test(origin);
    }

    public Cors withOrigin(String ... origin) {
        return this.withOrigin(Arrays.asList(origin));
    }

    public Cors withOrigin(List<String> origin) {
        this.origin = Cors.firstMatch(Objects.requireNonNull(origin, "Origins are required."));
        return this;
    }

    public boolean allowMethod(String method) {
        return this.requestMehods.test(method);
    }

    public List<String> allowedMethods() {
        return ((Matcher)this.requestMehods).values;
    }

    public Cors withMethods(String ... methods) {
        return this.withMethods(Arrays.asList(methods));
    }

    public Cors withMethods(List<String> methods) {
        this.requestMehods = Cors.firstMatch(methods);
        return this;
    }

    public boolean anyHeader() {
        return ((Matcher)this.requestHeaders).wild;
    }

    public boolean allowHeader(String header) {
        return this.allowHeaders((List<String>)ImmutableList.of((Object)header));
    }

    public boolean allowHeaders(String ... headers) {
        return this.allowHeaders(Arrays.asList(headers));
    }

    public boolean allowHeaders(List<String> headers) {
        return this.requestHeaders.test(headers);
    }

    public List<String> allowedHeaders() {
        return ((Matcher)this.requestHeaders).values;
    }

    public Cors withHeaders(String ... headers) {
        return this.withHeaders(Arrays.asList(headers));
    }

    public Cors withHeaders(List<String> headers) {
        this.requestHeaders = Cors.allMatch(headers);
        return this;
    }

    public List<String> exposedHeaders() {
        return this.exposedHeaders;
    }

    public Cors withExposedHeaders(String ... exposedHeaders) {
        return this.withExposedHeaders(Arrays.asList(exposedHeaders));
    }

    public Cors withExposedHeaders(List<String> exposedHeaders) {
        this.exposedHeaders = Objects.requireNonNull(exposedHeaders, "Exposed headers are required.");
        return this;
    }

    public int maxAge() {
        return this.maxAge;
    }

    public Cors withMaxAge(int preflightMaxAge) {
        this.maxAge = preflightMaxAge;
        return this;
    }

    private List<String> list(Object value) {
        return value instanceof List ? (List)value : ImmutableList.of((Object)value.toString());
    }

    private static Matcher<List<String>> allMatch(List<String> values) {
        Matcher<String> predicate = Cors.firstMatch(values);
        Predicate<List> allmatch = it -> it.stream().allMatch(predicate);
        return new Matcher<List<String>>(values, allmatch);
    }

    private static Matcher<String> firstMatch(List<String> values) {
        List patterns = values.stream().map(Cors::rewrite).collect(Collectors.toList());
        Predicate<String> predicate = it -> patterns.stream().filter(pattern -> pattern.matcher((CharSequence)it).matches()).findFirst().isPresent();
        return new Matcher<String>(values, predicate);
    }

    private static Pattern rewrite(String origin) {
        return Pattern.compile(origin.replace(".", "\\.").replace("*", ".*"), 2);
    }

    private static class Matcher<T>
    implements Predicate<T> {
        private List<String> values;
        private Predicate<T> predicate;
        private boolean wild;

        public Matcher(List<String> values, Predicate<T> predicate) {
            this.values = ImmutableList.copyOf(values);
            this.predicate = predicate;
            this.wild = values.contains("*");
        }

        @Override
        public boolean test(T value) {
            return this.predicate.test(value);
        }
    }
}

