/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.handlers;

import com.google.common.base.Strings;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValueFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.jooby.Asset;
import org.jooby.Err;
import org.jooby.MediaType;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.Status;
import org.jooby.funzy.Throwing;
import org.jooby.funzy.Try;
import org.jooby.internal.URLAsset;

public class AssetHandler
implements Route.Handler {
    private static final Throwing.Function<String, String> prefix = AssetHandler.prefix().memoized();
    private Throwing.Function2<Request, String, String> fn;
    private Loader loader;
    private String cdn;
    private boolean etag = true;
    private long maxAge = -1L;
    private boolean lastModified = true;
    private int statusCode = 404;

    public AssetHandler(String pattern, ClassLoader loader) {
        this.init(Route.normalize(pattern), Paths.get("public", new String[0]), loader);
    }

    public AssetHandler(Path basedir) {
        this.init("/{0}", basedir, this.getClass().getClassLoader());
    }

    public AssetHandler(String pattern) {
        this.init(Route.normalize(pattern), Paths.get("public", new String[0]), this.getClass().getClassLoader());
    }

    public AssetHandler etag(boolean etag) {
        this.etag = etag;
        return this;
    }

    public AssetHandler lastModified(boolean enabled) {
        this.lastModified = enabled;
        return this;
    }

    public AssetHandler cdn(String cdn) {
        this.cdn = Strings.emptyToNull((String)cdn);
        return this;
    }

    public AssetHandler maxAge(Duration maxAge) {
        return this.maxAge(maxAge.getSeconds());
    }

    public AssetHandler maxAge(long maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public AssetHandler maxAge(String maxAge) {
        Try.apply(() -> Long.parseLong(maxAge)).recover(x -> ConfigFactory.empty().withValue("v", ConfigValueFactory.fromAnyRef((Object)maxAge)).getDuration("v").getSeconds()).onSuccess(this::maxAge);
        return this;
    }

    public AssetHandler onMissing(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @Override
    public void handle(Request req, Response rsp) throws Throwable {
        String path = req.path();
        URL resource = this.resolve(req, path);
        if (resource != null) {
            URLAsset asset;
            String localpath = resource.getPath();
            int jarEntry = localpath.indexOf("!/");
            if (jarEntry > 0) {
                localpath = localpath.substring(jarEntry + 2);
            }
            if ((asset = new URLAsset(resource, path, MediaType.byPath(localpath).orElse(MediaType.octetstream))).exists()) {
                if (this.cdn != null) {
                    String absUrl = this.cdn + path;
                    rsp.redirect(absUrl);
                    rsp.end();
                } else {
                    this.doHandle(req, rsp, asset);
                }
            }
        } else if (this.statusCode > 0) {
            throw new Err(this.statusCode);
        }
    }

    private void doHandle(Request req, Response rsp, Asset asset) throws Throwable {
        long lastModified;
        if (this.etag) {
            String etag = asset.etag();
            boolean ifnm = req.header("If-None-Match").toOptional().map(etag::equals).orElse(false);
            if (ifnm) {
                rsp.header("ETag", (Object)etag).status(Status.NOT_MODIFIED).end();
                return;
            }
            rsp.header("ETag", (Object)etag);
        }
        if (this.lastModified && (lastModified = asset.lastModified()) > 0L) {
            boolean ifm = req.header("If-Modified-Since").toOptional(Long.class).map(ifModified -> lastModified / 1000L <= ifModified / 1000L).orElse(false);
            if (ifm) {
                rsp.status(Status.NOT_MODIFIED).end();
                return;
            }
            rsp.header("Last-Modified", (Object)new Date(lastModified));
        }
        if (this.maxAge > 0L) {
            rsp.header("Cache-Control", (Object)("max-age=" + this.maxAge));
        }
        this.send(req, rsp, asset);
    }

    protected void send(Request req, Response rsp, Asset asset) throws Throwable {
        rsp.send(asset);
    }

    private URL resolve(Request req, String path) throws Throwable {
        String target = (String)this.fn.apply((Object)req, (Object)path);
        return this.resolve(target);
    }

    protected URL resolve(String path) throws Exception {
        return this.loader.getResource(path);
    }

    private void init(String pattern, Path basedir, ClassLoader loader) {
        Objects.requireNonNull(loader, "Resource loader is required.");
        this.fn = pattern.equals("/") ? (req, p) -> (String)prefix.apply(p) : (req, p) -> MessageFormat.format((String)prefix.apply((Object)pattern), AssetHandler.vars(req));
        this.loader = AssetHandler.loader(basedir, loader);
    }

    private static Object[] vars(Request req) {
        Map<Object, String> vars = req.route().vars();
        return vars.values().toArray(new Object[vars.size()]);
    }

    private static Loader loader(Path basedir, ClassLoader classloader) {
        if (Files.exists(basedir, new LinkOption[0])) {
            return name -> {
                Path path = basedir.resolve(name).normalize();
                if (Files.exists(path, new LinkOption[0]) && path.startsWith(basedir)) {
                    try {
                        return path.toUri().toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                return classloader.getResource(name);
            };
        }
        return classloader::getResource;
    }

    private static Throwing.Function<String, String> prefix() {
        return p -> p.substring(1);
    }

    private static interface Loader {
        public URL getResource(String var1);
    }
}

