/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.io.Closeable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jooby.MediaType;
import org.jooby.Mutant;
import org.jooby.Registry;
import org.jooby.Request;
import org.jooby.internal.RouteMatcher;
import org.jooby.internal.RoutePattern;
import org.jooby.internal.WebSocketImpl;
import org.slf4j.LoggerFactory;

public interface WebSocket
extends Closeable,
Registry {
    public static final Key<Set<Definition>> KEY = Key.get((TypeLiteral)new TypeLiteral<Set<Definition>>(){});
    public static final SuccessCallback SUCCESS = () -> {};
    public static final OnError ERR = ex -> LoggerFactory.getLogger(WebSocket.class).error("error while sending data", ex);
    public static final CloseStatus NORMAL = new CloseStatus(1000, "Normal");
    public static final CloseStatus GOING_AWAY = new CloseStatus(1001, "Going away");
    public static final CloseStatus PROTOCOL_ERROR = new CloseStatus(1002, "Protocol error");
    public static final CloseStatus NOT_ACCEPTABLE = new CloseStatus(1003, "Not acceptable");
    public static final CloseStatus BAD_DATA = new CloseStatus(1007, "Bad data");
    public static final CloseStatus POLICY_VIOLATION = new CloseStatus(1008, "Policy violation");
    public static final CloseStatus TOO_BIG_TO_PROCESS = new CloseStatus(1009, "Too big to process");
    public static final CloseStatus REQUIRED_EXTENSION = new CloseStatus(1010, "Required extension");
    public static final CloseStatus SERVER_ERROR = new CloseStatus(1011, "Server error");
    public static final CloseStatus SERVICE_RESTARTED = new CloseStatus(1012, "Service restarted");
    public static final CloseStatus SERVICE_OVERLOAD = new CloseStatus(1013, "Service overload");

    @Nonnull
    public String path();

    @Nonnull
    public String pattern();

    @Nonnull
    public Map<Object, String> vars();

    @Nonnull
    public MediaType consumes();

    @Nonnull
    public MediaType produces();

    public void onMessage(OnMessage<Mutant> var1) throws Exception;

    public void onError(OnError var1);

    public void onClose(OnClose var1) throws Exception;

    default public void close(int code, String reason) {
        this.close(CloseStatus.of(code, reason));
    }

    default public void close(int code) {
        this.close(CloseStatus.of(code));
    }

    @Override
    default public void close() {
        this.close(NORMAL);
    }

    public boolean isOpen();

    public void close(CloseStatus var1);

    public void resume();

    public void pause();

    public void terminate() throws Exception;

    default public void send(Object data) throws Exception {
        this.send(data, SUCCESS, ERR);
    }

    default public void send(Object data, SuccessCallback success) throws Exception {
        this.send(data, success, ERR);
    }

    default public void send(Object data, OnError err) throws Exception {
        this.send(data, SUCCESS, err);
    }

    public void send(Object var1, SuccessCallback var2, OnError var3) throws Exception;

    default public void broadcast(Object data) throws Exception {
        this.broadcast(data, SUCCESS, ERR);
    }

    default public void broadcast(Object data, SuccessCallback success) throws Exception {
        this.broadcast(data, success, ERR);
    }

    default public void broadcast(Object data, OnError err) throws Exception {
        this.broadcast(data, SUCCESS, err);
    }

    public void broadcast(Object var1, SuccessCallback var2, OnError var3) throws Exception;

    @Nullable
    public WebSocket set(String var1, Object var2);

    public <T> T get(String var1);

    public <T> Optional<T> ifGet(String var1);

    public <T> Optional<T> unset(String var1);

    public WebSocket unset();

    public Map<String, Object> attributes();

    public static interface Handler<T>
    extends OnClose,
    OnMessage<T>,
    OnError,
    OnOpen {
    }

    public static class Definition {
        private RoutePattern routePattern;
        private MediaType consumes = MediaType.plain;
        private MediaType produces = MediaType.plain;
        private String pattern;
        private OnOpen handler;

        public Definition(String pattern, OnOpen handler) {
            Objects.requireNonNull(pattern, "A route path is required.");
            Objects.requireNonNull(handler, "A handler is required.");
            this.routePattern = new RoutePattern("WS", pattern);
            this.pattern = this.routePattern.pattern();
            this.handler = handler;
        }

        public String pattern() {
            return this.pattern;
        }

        public Optional<WebSocket> matches(String path) {
            RouteMatcher matcher = this.routePattern.matcher("WS" + path);
            if (matcher.matches()) {
                return Optional.of(this.asWebSocket(matcher));
            }
            return Optional.empty();
        }

        public Definition consumes(String type) {
            return this.consumes(MediaType.valueOf(type));
        }

        public Definition consumes(MediaType type) {
            this.consumes = Objects.requireNonNull(type, "A type is required.");
            return this;
        }

        public Definition produces(String type) {
            return this.produces(MediaType.valueOf(type));
        }

        public Definition produces(MediaType type) {
            this.produces = Objects.requireNonNull(type, "A type is required.");
            return this;
        }

        public MediaType consumes() {
            return this.consumes;
        }

        public MediaType produces() {
            return this.produces;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Definition) {
                Definition def = (Definition)obj;
                return this.pattern.equals(def.pattern);
            }
            return false;
        }

        public int hashCode() {
            return this.pattern.hashCode();
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("WS ").append(this.pattern()).append("\n");
            buffer.append("  consume: ").append(this.consumes()).append("\n");
            buffer.append("  produces: ").append(this.produces()).append("\n");
            return buffer.toString();
        }

        private WebSocket asWebSocket(RouteMatcher matcher) {
            return new WebSocketImpl(this.handler, matcher.path(), this.pattern, matcher.vars(), this.consumes, this.produces);
        }
    }

    public static interface OnError {
        public void onError(Throwable var1);
    }

    public static interface SuccessCallback {
        public void invoke() throws Exception;
    }

    public static interface OnClose {
        public void onClose(CloseStatus var1) throws Exception;
    }

    public static interface OnMessage<T> {
        public void onMessage(T var1) throws Exception;
    }

    public static class CloseStatus {
        private final int code;
        private final String reason;

        private CloseStatus(int code) {
            this(code, null);
        }

        private CloseStatus(int code, String reason) {
            Preconditions.checkArgument((code >= 1000 && code < 5000 ? 1 : 0) != 0, (String)"Invalid code: %s", (int)code);
            this.code = code;
            this.reason = reason == null || reason.isEmpty() ? null : reason;
        }

        public static CloseStatus of(int code) {
            return new CloseStatus(code);
        }

        public static CloseStatus of(int code, String reason) {
            Objects.requireNonNull(reason, "A reason is required.");
            return new CloseStatus(code, reason);
        }

        public int code() {
            return this.code;
        }

        public String reason() {
            return this.reason;
        }

        public String toString() {
            if (this.reason == null) {
                return this.code + "";
            }
            return this.code + " (" + this.reason + ")";
        }
    }

    public static interface OnOpen1
    extends OnOpen {
        @Override
        default public void onOpen(Request req, WebSocket ws) throws Exception {
            this.onOpen(ws);
        }

        public void onOpen(WebSocket var1) throws Exception;
    }

    public static interface OnOpen {
        public void onOpen(Request var1, WebSocket var2) throws Exception;
    }
}

