/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.UrlEscapers;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jooby.Cookie;
import org.jooby.Err;
import org.jooby.MediaType;
import org.jooby.Mutant;
import org.jooby.Registry;
import org.jooby.Route;
import org.jooby.Session;
import org.jooby.Status;
import org.jooby.Upload;

public interface Request
extends Registry {
    @Nonnull
    default public String path() {
        return this.path(false);
    }

    @Nonnull
    public String rawPath();

    @Nonnull
    public Optional<String> queryString();

    @Nonnull
    default public String path(boolean escape) {
        String path = this.route().path();
        return escape ? UrlEscapers.urlFragmentEscaper().escape(path) : path;
    }

    @Nonnull
    public String contextPath();

    @Nonnull
    default public String method() {
        return this.route().method();
    }

    @Nonnull
    public MediaType type();

    @Nonnull
    public List<MediaType> accept();

    @Nonnull
    default public Optional<MediaType> accepts(String ... types) {
        return this.accepts(MediaType.valueOf(types));
    }

    public boolean matches(String var1);

    default public boolean is(String ... types) {
        return this.accepts(types).isPresent();
    }

    default public boolean is(MediaType ... types) {
        return this.accepts(types).isPresent();
    }

    default public boolean is(List<MediaType> types) {
        return this.accepts(types).isPresent();
    }

    @Nonnull
    default public Optional<MediaType> accepts(MediaType ... types) {
        return this.accepts((List<MediaType>)ImmutableList.copyOf((Object[])types));
    }

    @Nonnull
    public Optional<MediaType> accepts(List<MediaType> var1);

    @Nonnull
    public Mutant params();

    @Nonnull
    public Mutant params(String ... var1);

    @Nonnull
    default public <T> T params(Class<T> type) {
        return this.params().to(type);
    }

    @Nonnull
    default public <T> T form(Class<T> type) {
        return this.params().to(type);
    }

    @Nonnull
    default public <T> T params(Class<T> type, String ... xss) {
        return this.params(xss).to(type);
    }

    @Nonnull
    default public <T> T form(Class<T> type, String ... xss) {
        return this.params(xss).to(type);
    }

    @Nonnull
    public Mutant param(String var1);

    @Nonnull
    public Mutant param(String var1, String ... var2);

    @Nonnull
    default public Upload file(String name) throws IOException {
        List<Upload> files = this.files(name);
        if (files.size() == 0) {
            throw new Err.Missing(name);
        }
        return files.get(0);
    }

    @Nonnull
    default public Optional<Upload> ifFile(String name) throws IOException {
        List<Upload> files = this.files(name);
        return files.size() == 0 ? Optional.empty() : Optional.of(files.get(0));
    }

    @Nonnull
    public List<Upload> files(String var1) throws IOException;

    @Nonnull
    public List<Upload> files() throws IOException;

    @Nonnull
    public Mutant header(String var1);

    @Nonnull
    public Mutant header(String var1, String ... var2);

    @Nonnull
    public Map<String, Mutant> headers();

    @Nonnull
    public Mutant cookie(String var1);

    @Nonnull
    public List<Cookie> cookies();

    @Nonnull
    public Mutant body() throws Exception;

    @Nonnull
    default public <T> T body(Class<T> type) throws Exception {
        return this.body().to(type);
    }

    @Nonnull
    public Charset charset();

    @Nonnull
    default public List<Locale> locales() {
        return this.locales(Locale::filter);
    }

    @Nonnull
    public List<Locale> locales(BiFunction<List<Locale.LanguageRange>, List<Locale>, List<Locale>> var1);

    @Nonnull
    public Locale locale(BiFunction<List<Locale.LanguageRange>, List<Locale>, Locale> var1);

    @Nonnull
    default public Locale locale() {
        return this.locale((priorityList, locales) -> Optional.ofNullable(Locale.lookup(priorityList, locales)).orElse((Locale)locales.get(0)));
    }

    public long length();

    @Nonnull
    public String ip();

    public int port();

    @Nonnull
    public Route route();

    @Nonnull
    public String hostname();

    @Nonnull
    public Session session();

    @Nonnull
    public Optional<Session> ifSession();

    default public boolean xhr() {
        return this.header("X-Requested-With").toOptional(String.class).map("XMLHttpRequest"::equalsIgnoreCase).orElse(Boolean.FALSE);
    }

    @Nonnull
    public String protocol();

    public boolean secure();

    @Nonnull
    public Request set(String var1, Object var2);

    @Nonnull
    default public Flash flash() throws Err {
        Optional flash = this.ifGet("flash");
        return (Flash)flash.orElseThrow(() -> new Err(Status.BAD_REQUEST, "Flash scope isn't available. Install via: use(new FlashScope());"));
    }

    @Nonnull
    default public Request flash(String name, @Nullable Object value) {
        Objects.requireNonNull(name, "Attribute's name is required.");
        Flash flash = this.flash();
        if (value == null) {
            flash.remove(name);
        } else {
            flash.put(name, value.toString());
        }
        return this;
    }

    @Nonnull
    default public Optional<String> ifFlash(String name) {
        return Optional.ofNullable(this.flash().get(name));
    }

    @Nonnull
    default public String flash(String name) throws Err {
        return this.ifFlash(name).orElseThrow(() -> new Err(Status.BAD_REQUEST, "Required flash attribute: '" + name + "' is not present"));
    }

    default public boolean isSet(String name) {
        return this.ifGet(name).isPresent();
    }

    @Nonnull
    public <T> Optional<T> ifGet(String var1);

    @Nonnull
    default public <T> T get(String name, T def) {
        Optional<T> opt = this.ifGet(name);
        return opt.orElse(def);
    }

    @Nonnull
    default public <T> T get(String name) {
        Optional<T> opt = this.ifGet(name);
        return opt.orElseThrow(() -> new Err(Status.BAD_REQUEST, "Required local attribute: " + name + " is not present"));
    }

    @Nonnull
    public <T> Optional<T> unset(String var1);

    @Nonnull
    public Map<String, Object> attributes();

    @Nonnull
    default public Request set(Class<?> type, Object value) {
        return this.set(TypeLiteral.get(type), value);
    }

    @Nonnull
    default public Request set(TypeLiteral<?> type, Object value) {
        return this.set(Key.get(type), value);
    }

    @Nonnull
    public Request set(Key<?> var1, Object var2);

    @Nonnull
    default public Request push(String path) {
        return this.push(path, (Map<String, Object>)ImmutableMap.of());
    }

    @Nonnull
    public Request push(String var1, Map<String, Object> var2);

    public long timestamp();

    public static class Forwarding
    implements Request {
        private Request req;

        public Forwarding(Request request) {
            this.req = Objects.requireNonNull(request, "A HTTP request is required.");
        }

        @Override
        public String path() {
            return this.req.path();
        }

        @Override
        public String rawPath() {
            return this.req.rawPath();
        }

        @Override
        public Optional<String> queryString() {
            return this.req.queryString();
        }

        @Override
        public String path(boolean escape) {
            return this.req.path(escape);
        }

        @Override
        public boolean matches(String pattern) {
            return this.req.matches(pattern);
        }

        @Override
        public String contextPath() {
            return this.req.contextPath();
        }

        @Override
        public String method() {
            return this.req.method();
        }

        @Override
        public MediaType type() {
            return this.req.type();
        }

        @Override
        public List<MediaType> accept() {
            return this.req.accept();
        }

        @Override
        public Optional<MediaType> accepts(List<MediaType> types) {
            return this.req.accepts(types);
        }

        @Override
        public Optional<MediaType> accepts(MediaType ... types) {
            return this.req.accepts(types);
        }

        @Override
        public Optional<MediaType> accepts(String ... types) {
            return this.req.accepts(types);
        }

        @Override
        public boolean is(List<MediaType> types) {
            return this.req.is(types);
        }

        @Override
        public boolean is(MediaType ... types) {
            return this.req.is(types);
        }

        @Override
        public boolean is(String ... types) {
            return this.req.is(types);
        }

        @Override
        public boolean isSet(String name) {
            return this.req.isSet(name);
        }

        @Override
        public Mutant params() {
            return this.req.params();
        }

        @Override
        public Mutant params(String ... xss) {
            return this.req.params(xss);
        }

        @Override
        public <T> T params(Class<T> type) {
            return this.req.params(type);
        }

        @Override
        public <T> T params(Class<T> type, String ... xss) {
            return this.req.params(type, xss);
        }

        @Override
        public Mutant param(String name) {
            return this.req.param(name);
        }

        @Override
        public Mutant param(String name, String ... xss) {
            return this.req.param(name, xss);
        }

        @Override
        public Upload file(String name) throws IOException {
            return this.req.file(name);
        }

        @Override
        public List<Upload> files(String name) throws IOException {
            return this.req.files(name);
        }

        @Override
        @Nonnull
        public List<Upload> files() throws IOException {
            return this.req.files();
        }

        @Override
        public Mutant header(String name) {
            return this.req.header(name);
        }

        @Override
        public Mutant header(String name, String ... xss) {
            return this.req.header(name, xss);
        }

        @Override
        public Map<String, Mutant> headers() {
            return this.req.headers();
        }

        @Override
        public Mutant cookie(String name) {
            return this.req.cookie(name);
        }

        @Override
        public List<Cookie> cookies() {
            return this.req.cookies();
        }

        @Override
        public Mutant body() throws Exception {
            return this.req.body();
        }

        @Override
        public <T> T body(Class<T> type) throws Exception {
            return this.req.body(type);
        }

        @Override
        public <T> T require(Class<T> type) {
            return this.req.require(type);
        }

        @Override
        public <T> T require(TypeLiteral<T> type) {
            return this.req.require(type);
        }

        @Override
        public <T> T require(Key<T> key) {
            return this.req.require(key);
        }

        @Override
        public Charset charset() {
            return this.req.charset();
        }

        @Override
        public long length() {
            return this.req.length();
        }

        @Override
        public Locale locale() {
            return this.req.locale();
        }

        @Override
        public Locale locale(BiFunction<List<Locale.LanguageRange>, List<Locale>, Locale> filter) {
            return this.req.locale(filter);
        }

        @Override
        public List<Locale> locales(BiFunction<List<Locale.LanguageRange>, List<Locale>, List<Locale>> filter) {
            return this.req.locales(filter);
        }

        @Override
        public List<Locale> locales() {
            return this.req.locales();
        }

        @Override
        public String ip() {
            return this.req.ip();
        }

        @Override
        public int port() {
            return this.req.port();
        }

        @Override
        public Route route() {
            return this.req.route();
        }

        @Override
        public Session session() {
            return this.req.session();
        }

        @Override
        public Optional<Session> ifSession() {
            return this.req.ifSession();
        }

        @Override
        public String hostname() {
            return this.req.hostname();
        }

        @Override
        public String protocol() {
            return this.req.protocol();
        }

        @Override
        public boolean secure() {
            return this.req.secure();
        }

        @Override
        public boolean xhr() {
            return this.req.xhr();
        }

        @Override
        public Map<String, Object> attributes() {
            return this.req.attributes();
        }

        @Override
        public <T> Optional<T> ifGet(String name) {
            return this.req.ifGet(name);
        }

        @Override
        public <T> T get(String name) {
            return this.req.get(name);
        }

        @Override
        public <T> T get(String name, T def) {
            return this.req.get(name, def);
        }

        @Override
        public Request set(String name, Object value) {
            this.req.set(name, value);
            return this;
        }

        @Override
        public Request set(Key<?> key, Object value) {
            this.req.set(key, value);
            return this;
        }

        @Override
        public Request set(Class<?> type, Object value) {
            this.req.set(type, value);
            return this;
        }

        @Override
        public Request set(TypeLiteral<?> type, Object value) {
            this.req.set(type, value);
            return this;
        }

        @Override
        public <T> Optional<T> unset(String name) {
            return this.req.unset(name);
        }

        @Override
        public Flash flash() throws NoSuchElementException {
            return this.req.flash();
        }

        @Override
        public String flash(String name) throws NoSuchElementException {
            return this.req.flash(name);
        }

        @Override
        public Request flash(String name, Object value) {
            this.req.flash(name, value);
            return this;
        }

        @Override
        public Optional<String> ifFlash(String name) {
            return this.req.ifFlash(name);
        }

        @Override
        public Request push(String path) {
            this.req.push(path);
            return this;
        }

        @Override
        public Request push(String path, Map<String, Object> headers) {
            this.req.push(path, headers);
            return this;
        }

        @Override
        public long timestamp() {
            return this.req.timestamp();
        }

        public String toString() {
            return this.req.toString();
        }

        public static Request unwrap(Request req) {
            Objects.requireNonNull(req, "A request is required.");
            Request root = req;
            while (root instanceof Forwarding) {
                root = ((Forwarding)root).req;
            }
            return root;
        }
    }

    public static interface Flash
    extends Map<String, String> {
        public void keep();
    }
}

