/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import com.google.common.base.CaseFormat;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jooby.MediaType;

public interface Renderer {
    public static final Key<Set<Renderer>> KEY = Key.get((TypeLiteral)new TypeLiteral<Set<Renderer>>(){});

    default public String name() {
        String name = this.getClass().getSimpleName().replace("renderer", "").replace("render", "");
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, name);
    }

    public void render(Object var1, Context var2) throws Exception;

    public static Renderer of(final String name, final Renderer renderer) {
        return new Renderer(){

            @Override
            public void render(Object value, Context ctx) throws Exception {
                renderer.render(value, ctx);
            }

            @Override
            public String name() {
                return name;
            }
        };
    }

    public static interface Context {
        public Locale locale();

        public Map<String, Object> locals();

        default public boolean accepts(String type) {
            return this.accepts(MediaType.valueOf(type));
        }

        public boolean accepts(MediaType var1);

        default public Context type(String type) {
            return this.type(MediaType.valueOf(type));
        }

        public Context type(MediaType var1);

        public Context length(long var1);

        public Charset charset();

        public void send(byte[] var1) throws Exception;

        public void send(ByteBuffer var1) throws Exception;

        public void send(String var1) throws Exception;

        public void send(InputStream var1) throws Exception;

        public void send(CharBuffer var1) throws Exception;

        public void send(Reader var1) throws Exception;

        public void send(FileChannel var1) throws Exception;
    }
}

