/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import com.google.common.primitives.Primitives;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import org.jooby.MediaType;

public interface Mutant {
    default public boolean booleanValue() {
        return this.to(Boolean.TYPE);
    }

    default public boolean booleanValue(boolean value) {
        return this.toOptional(Boolean.class).orElse(value);
    }

    default public byte byteValue() {
        return this.to(Byte.TYPE);
    }

    default public byte byteValue(byte value) {
        return this.toOptional(Byte.class).orElse(value);
    }

    default public char charValue() {
        return this.to(Character.TYPE).charValue();
    }

    default public char charValue(char value) {
        return this.toOptional(Character.class).orElse(Character.valueOf(value)).charValue();
    }

    default public short shortValue() {
        return this.to(Short.TYPE);
    }

    default public short shortValue(short value) {
        return this.toOptional(Short.class).orElse(value);
    }

    default public int intValue() {
        return this.to(Integer.TYPE);
    }

    default public int intValue(int value) {
        return this.toOptional(Integer.class).orElse(value);
    }

    default public long longValue() {
        return this.to(Long.TYPE);
    }

    default public long longValue(long value) {
        return this.toOptional(Long.class).orElse(value);
    }

    @Nonnull
    default public String value() {
        return this.to(String.class);
    }

    @Nonnull
    default public String value(String value) {
        return this.toOptional().orElse(value);
    }

    default public float floatValue() {
        return this.to(Float.TYPE).floatValue();
    }

    default public float floatValue(float value) {
        return this.toOptional(Float.class).orElse(Float.valueOf(value)).floatValue();
    }

    default public double doubleValue() {
        return this.to(Double.TYPE);
    }

    default public double doubleValue(double value) {
        return this.toOptional(Double.class).orElse(value);
    }

    @Nonnull
    default public <T extends Enum<T>> T toEnum(Class<T> type) {
        return (T)((Enum)this.to(type));
    }

    @Nonnull
    default public <T extends Enum<T>> T toEnum(T value) {
        Optional<?> optional = this.toOptional(value.getClass());
        return (T)((Enum)optional.orElse(value));
    }

    @Nonnull
    default public <T> List<T> toList(Class<T> type) {
        return (List)this.to(TypeLiteral.get((Type)Types.listOf((Type)Primitives.wrap(type))));
    }

    @Nonnull
    default public List<String> toList() {
        return this.toList(String.class);
    }

    @Nonnull
    default public Set<String> toSet() {
        return this.toSet(String.class);
    }

    @Nonnull
    default public <T> Set<T> toSet(Class<T> type) {
        return (Set)this.to(TypeLiteral.get((Type)Types.setOf((Type)Primitives.wrap(type))));
    }

    @Nonnull
    default public SortedSet<String> toSortedSet() {
        return this.toSortedSet(String.class);
    }

    @Nonnull
    default public <T extends Comparable<T>> SortedSet<T> toSortedSet(Class<T> type) {
        return (SortedSet)this.to(TypeLiteral.get((Type)Types.newParameterizedType(SortedSet.class, (Type[])new Type[]{Primitives.wrap(type)})));
    }

    @Nonnull
    default public Optional<String> toOptional() {
        return this.toOptional(String.class);
    }

    @Nonnull
    default public <T> Optional<T> toOptional(Class<T> type) {
        return (Optional)this.to(TypeLiteral.get((Type)Types.newParameterizedType(Optional.class, (Type[])new Type[]{Primitives.wrap(type)})));
    }

    @Nonnull
    default public <T> T to(Class<T> type) {
        return this.to(TypeLiteral.get(type));
    }

    @Nonnull
    public <T> T to(TypeLiteral<T> var1);

    @Nonnull
    default public <T> T to(Class<T> type, String mtype) {
        return this.to(type, MediaType.valueOf(mtype));
    }

    @Nonnull
    default public <T> T to(Class<T> type, MediaType mtype) {
        return this.to(TypeLiteral.get(type), mtype);
    }

    @Nonnull
    default public <T> T to(TypeLiteral<T> type, String mtype) {
        return this.to(type, MediaType.valueOf(mtype));
    }

    @Nonnull
    public <T> T to(TypeLiteral<T> var1, MediaType var2);

    @Nonnull
    public Map<String, Mutant> toMap();

    public boolean isSet();
}

