/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import com.google.common.net.UrlEscapers;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Scope;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.ProviderMethodsModule;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.util.Types;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import javax.net.ssl.SSLContext;
import org.jooby.Cookie;
import org.jooby.Deferred;
import org.jooby.Env;
import org.jooby.Err;
import org.jooby.LifeCycle;
import org.jooby.MediaType;
import org.jooby.Parser;
import org.jooby.Registry;
import org.jooby.Renderer;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.Router;
import org.jooby.Session;
import org.jooby.Sse;
import org.jooby.Status;
import org.jooby.WebSocket;
import org.jooby.funzy.Throwing;
import org.jooby.funzy.Try;
import org.jooby.handlers.AssetHandler;
import org.jooby.internal.AppPrinter;
import org.jooby.internal.BuiltinParser;
import org.jooby.internal.BuiltinRenderer;
import org.jooby.internal.CookieSessionManager;
import org.jooby.internal.DefaulErrRenderer;
import org.jooby.internal.HttpHandlerImpl;
import org.jooby.internal.JvmInfo;
import org.jooby.internal.LocaleUtils;
import org.jooby.internal.ParameterNameProvider;
import org.jooby.internal.RequestScope;
import org.jooby.internal.RouteMetadata;
import org.jooby.internal.ServerExecutorProvider;
import org.jooby.internal.ServerLookup;
import org.jooby.internal.ServerSessionManager;
import org.jooby.internal.SessionManager;
import org.jooby.internal.SourceProvider;
import org.jooby.internal.TypeConverters;
import org.jooby.internal.handlers.HeadHandler;
import org.jooby.internal.handlers.OptionsHandler;
import org.jooby.internal.handlers.TraceHandler;
import org.jooby.internal.mvc.MvcRoutes;
import org.jooby.internal.mvc.MvcWebSocket;
import org.jooby.internal.parser.BeanParser;
import org.jooby.internal.parser.DateParser;
import org.jooby.internal.parser.LocalDateParser;
import org.jooby.internal.parser.LocaleParser;
import org.jooby.internal.parser.ParserExecutor;
import org.jooby.internal.parser.StaticMethodParser;
import org.jooby.internal.parser.StringConstructorParser;
import org.jooby.internal.parser.ZonedDateTimeParser;
import org.jooby.internal.ssl.SslContextProvider;
import org.jooby.mvc.Consumes;
import org.jooby.mvc.Path;
import org.jooby.mvc.Produces;
import org.jooby.scope.Providers;
import org.jooby.scope.RequestScoped;
import org.jooby.spi.HttpHandler;
import org.jooby.spi.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jooby
implements Router,
LifeCycle,
Registry {
    private transient Set<Object> bag = new LinkedHashSet<Object>();
    private transient Config srcconf;
    private final transient AtomicBoolean started = new AtomicBoolean(false);
    private transient Injector injector;
    private transient Session.Definition session = new Session.Definition(Session.Mem.class);
    private transient Env.Builder env = Env.DEFAULT;
    private transient String prefix;
    private transient List<Throwing.Consumer<Registry>> onStart = new ArrayList<Throwing.Consumer<Registry>>();
    private transient List<Throwing.Consumer<Registry>> onStarted = new ArrayList<Throwing.Consumer<Registry>>();
    private transient List<Throwing.Consumer<Registry>> onStop = new ArrayList<Throwing.Consumer<Registry>>();
    private transient Route.Mapper mapper;
    private transient Set<String> mappers = new HashSet<String>();
    private transient Optional<Parser> beanParser = Optional.empty();
    private transient ServerLookup server = new ServerLookup();
    private transient String dateFormat;
    private transient Charset charset;
    private transient String[] languages;
    private transient ZoneId zoneId;
    private transient Integer port;
    private transient Integer securePort;
    private transient String numberFormat;
    private transient boolean http2;
    private transient List<Consumer<Binder>> executors = new ArrayList<Consumer<Binder>>();
    private transient boolean defaultExecSet;
    private boolean throwBootstrapException;
    private transient BiFunction<Stage, com.google.inject.Module, Injector> injectorFactory = (x$0, xva$1) -> Guice.createInjector((Stage)x$0, (com.google.inject.Module[])new com.google.inject.Module[]{xva$1});
    private transient List<Jooby> apprefs;
    private transient LinkedList<String> path = new LinkedList();
    private transient String confname;
    private transient boolean caseSensitiveRouting = true;
    private transient String classname;

    public Jooby() {
        this(null);
    }

    public Jooby(String prefix) {
        this.prefix = prefix;
        this.use(this.server);
        this.classname = this.classname(this.getClass().getName());
    }

    @Override
    public Route.Collection path(String path, Runnable action) {
        this.path.addLast(Route.normalize(path));
        Route.Collection collection = this.with(action);
        this.path.removeLast();
        return collection;
    }

    @Override
    public Jooby use(Jooby app) {
        return this.use(this.prefixPath(null), app);
    }

    private Optional<String> prefixPath(@Nullable String tail) {
        return this.path.size() == 0 ? (tail == null ? Optional.empty() : Optional.of(Route.normalize(tail))) : Optional.of(this.path.stream().collect(Collectors.joining("", "", tail == null ? "" : Route.normalize(tail))));
    }

    @Override
    public Jooby use(String path, Jooby app) {
        return this.use(this.prefixPath(path), app);
    }

    public Jooby server(Class<? extends Server> server) {
        Objects.requireNonNull(server, "Server required.");
        List tmp = this.bag.stream().skip(1L).collect(Collectors.toList());
        tmp.add(0, (env, conf, binder) -> binder.bind(Server.class).to(server).asEagerSingleton());
        this.bag.clear();
        this.bag.addAll(tmp);
        return this;
    }

    private Jooby use(Optional<String> path, Jooby app) {
        Objects.requireNonNull(app, "App is required.");
        Function<Route.Definition, Route.Definition> rewrite = r -> path.map((? super T p) -> {
            Route.Definition result = new Route.Definition(r.method(), p + r.pattern(), r.filter());
            result.consumes((List)r.consumes());
            result.produces((List)r.produces());
            result.excludes((List)r.excludes());
            return result;
        }).orElse((Route.Definition)r);
        app.bag.forEach(it -> {
            if (it instanceof Route.Definition) {
                this.bag.add(rewrite.apply((Route.Definition)it));
            } else if (it instanceof MvcClass) {
                Object routes = path.map((? super T p) -> new MvcClass(((MvcClass)it).routeClass, (String)p, this.prefix)).orElse(it);
                this.bag.add(routes);
            } else {
                this.bag.add(it);
            }
        });
        app.onStart.forEach(this.onStart::add);
        app.onStarted.forEach(this.onStarted::add);
        app.onStop.forEach(this.onStop::add);
        if (app.mapper != null) {
            this.map(app.mapper);
        }
        if (this.apprefs == null) {
            this.apprefs = new ArrayList<Jooby>();
        }
        this.apprefs.add(app);
        return this;
    }

    public Jooby env(Env.Builder env) {
        this.env = Objects.requireNonNull(env, "Env builder is required.");
        return this;
    }

    @Override
    public Jooby onStart(Throwing.Runnable callback) {
        LifeCycle.super.onStart(callback);
        return this;
    }

    @Override
    public Jooby onStart(Throwing.Consumer<Registry> callback) {
        Objects.requireNonNull(callback, "Callback is required.");
        this.onStart.add(callback);
        return this;
    }

    @Override
    public Jooby onStarted(Throwing.Runnable callback) {
        LifeCycle.super.onStarted(callback);
        return this;
    }

    @Override
    public Jooby onStarted(Throwing.Consumer<Registry> callback) {
        Objects.requireNonNull(callback, "Callback is required.");
        this.onStarted.add(callback);
        return this;
    }

    @Override
    public Jooby onStop(Throwing.Runnable callback) {
        LifeCycle.super.onStop(callback);
        return this;
    }

    @Override
    public Jooby onStop(Throwing.Consumer<Registry> callback) {
        Objects.requireNonNull(callback, "Callback is required.");
        this.onStop.add(callback);
        return this;
    }

    public EnvPredicate on(String env, Runnable callback) {
        Objects.requireNonNull(env, "Env is required.");
        return this.on(Jooby.envpredicate(env), callback);
    }

    public EnvPredicate on(String env, Consumer<Config> callback) {
        Objects.requireNonNull(env, "Env is required.");
        return this.on(Jooby.envpredicate(env), callback);
    }

    public EnvPredicate on(Predicate<String> predicate, Runnable callback) {
        Objects.requireNonNull(predicate, "Predicate is required.");
        Objects.requireNonNull(callback, "Callback is required.");
        return this.on(predicate, (Config conf) -> callback.run());
    }

    public EnvPredicate on(Predicate<String> predicate, Consumer<Config> callback) {
        Objects.requireNonNull(predicate, "Predicate is required.");
        Objects.requireNonNull(callback, "Callback is required.");
        this.bag.add(new EnvDep(predicate, callback));
        return otherwise -> this.bag.add(new EnvDep(predicate.negate(), otherwise));
    }

    public Jooby on(String env1, String env2, String env3, Runnable callback) {
        this.on(Jooby.envpredicate(env1).or(Jooby.envpredicate(env2)).or(Jooby.envpredicate(env3)), callback);
        return this;
    }

    @Override
    public <T> T require(Key<T> type) {
        Preconditions.checkState((this.injector != null ? 1 : 0) != 0, (Object)"Registry is not ready. Require calls are available at application startup time, see http://jooby.org/doc/#application-life-cycle");
        try {
            return (T)this.injector.getInstance(type);
        }
        catch (ProvisionException x) {
            Throwable cause = x.getCause();
            if (cause instanceof Err) {
                throw (Err)cause;
            }
            throw x;
        }
    }

    @Override
    public Route.OneArgHandler promise(Deferred.Initializer initializer) {
        return req -> new Deferred(initializer);
    }

    @Override
    public Route.OneArgHandler promise(String executor, Deferred.Initializer initializer) {
        return req -> new Deferred(executor, initializer);
    }

    @Override
    public Route.OneArgHandler promise(Deferred.Initializer0 initializer) {
        return req -> new Deferred(initializer);
    }

    @Override
    public Route.OneArgHandler promise(String executor, Deferred.Initializer0 initializer) {
        return req -> new Deferred(executor, initializer);
    }

    public Session.Definition session(Class<? extends Session.Store> store) {
        this.session = new Session.Definition(Objects.requireNonNull(store, "A session store is required."));
        return this.session;
    }

    public Session.Definition cookieSession() {
        this.session = new Session.Definition();
        return this.session;
    }

    public Session.Definition session(Session.Store store) {
        this.session = new Session.Definition(Objects.requireNonNull(store, "A session store is required."));
        return this.session;
    }

    public Jooby parser(Parser parser) {
        if (parser instanceof BeanParser) {
            this.beanParser = Optional.of(parser);
        } else {
            this.bag.add(Objects.requireNonNull(parser, "A parser is required."));
        }
        return this;
    }

    public Jooby renderer(Renderer renderer) {
        this.bag.add(Objects.requireNonNull(renderer, "A renderer is required."));
        return this;
    }

    @Override
    public Route.Definition before(String method, String pattern, Route.Before handler) {
        return this.appendDefinition(method, pattern, handler);
    }

    @Override
    public Route.Definition after(String method, String pattern, Route.After handler) {
        return this.appendDefinition(method, pattern, handler);
    }

    @Override
    public Route.Definition complete(String method, String pattern, Route.Complete handler) {
        return this.appendDefinition(method, pattern, handler);
    }

    @Override
    public Route.Definition use(String path, Route.Filter filter) {
        return this.appendDefinition("*", path, filter);
    }

    @Override
    public Route.Definition use(String verb, String path, Route.Filter filter) {
        return this.appendDefinition(verb, path, filter);
    }

    @Override
    public Route.Definition use(String verb, String path, Route.Handler handler) {
        return this.appendDefinition(verb, path, handler);
    }

    @Override
    public Route.Definition use(String path, Route.Handler handler) {
        return this.appendDefinition("*", path, handler);
    }

    @Override
    public Route.Definition use(String path, Route.OneArgHandler handler) {
        return this.appendDefinition("*", path, handler);
    }

    @Override
    public Route.Definition get(String path, Route.Handler handler) {
        return this.appendDefinition("GET", path, handler);
    }

    @Override
    public Route.Collection get(String path1, String path2, Route.Handler handler) {
        return new Route.Collection(this.get(path1, handler), this.get(path2, handler));
    }

    @Override
    public Route.Collection get(String path1, String path2, String path3, Route.Handler handler) {
        return new Route.Collection(this.get(path1, handler), this.get(path2, handler), this.get(path3, handler));
    }

    @Override
    public Route.Definition get(String path, Route.OneArgHandler handler) {
        return this.appendDefinition("GET", path, handler);
    }

    @Override
    public Route.Collection get(String path1, String path2, Route.OneArgHandler handler) {
        return new Route.Collection(this.get(path1, handler), this.get(path2, handler));
    }

    @Override
    public Route.Collection get(String path1, String path2, String path3, Route.OneArgHandler handler) {
        return new Route.Collection(this.get(path1, handler), this.get(path2, handler), this.get(path3, handler));
    }

    @Override
    public Route.Definition get(String path, Route.ZeroArgHandler handler) {
        return this.appendDefinition("GET", path, handler);
    }

    @Override
    public Route.Collection get(String path1, String path2, Route.ZeroArgHandler handler) {
        return new Route.Collection(this.get(path1, handler), this.get(path2, handler));
    }

    @Override
    public Route.Collection get(String path1, String path2, String path3, Route.ZeroArgHandler handler) {
        return new Route.Collection(this.get(path1, handler), this.get(path2, handler), this.get(path3, handler));
    }

    @Override
    public Route.Definition get(String path, Route.Filter filter) {
        return this.appendDefinition("GET", path, filter);
    }

    @Override
    public Route.Collection get(String path1, String path2, Route.Filter filter) {
        return new Route.Collection(this.get(path1, filter), this.get(path2, filter));
    }

    @Override
    public Route.Collection get(String path1, String path2, String path3, Route.Filter filter) {
        return new Route.Collection(this.get(path1, filter), this.get(path2, filter), this.get(path3, filter));
    }

    @Override
    public Route.Definition post(String path, Route.Handler handler) {
        return this.appendDefinition("POST", path, handler);
    }

    @Override
    public Route.Collection post(String path1, String path2, Route.Handler handler) {
        return new Route.Collection(this.post(path1, handler), this.post(path2, handler));
    }

    @Override
    public Route.Collection post(String path1, String path2, String path3, Route.Handler handler) {
        return new Route.Collection(this.post(path1, handler), this.post(path2, handler), this.post(path3, handler));
    }

    @Override
    public Route.Definition post(String path, Route.OneArgHandler handler) {
        return this.appendDefinition("POST", path, handler);
    }

    @Override
    public Route.Collection post(String path1, String path2, Route.OneArgHandler handler) {
        return new Route.Collection(this.post(path1, handler), this.post(path2, handler));
    }

    @Override
    public Route.Collection post(String path1, String path2, String path3, Route.OneArgHandler handler) {
        return new Route.Collection(this.post(path1, handler), this.post(path2, handler), this.post(path3, handler));
    }

    @Override
    public Route.Definition post(String path, Route.ZeroArgHandler handler) {
        return this.appendDefinition("POST", path, handler);
    }

    @Override
    public Route.Collection post(String path1, String path2, Route.ZeroArgHandler handler) {
        return new Route.Collection(this.post(path1, handler), this.post(path2, handler));
    }

    @Override
    public Route.Collection post(String path1, String path2, String path3, Route.ZeroArgHandler handler) {
        return new Route.Collection(this.post(path1, handler), this.post(path2, handler), this.post(path3, handler));
    }

    @Override
    public Route.Definition post(String path, Route.Filter filter) {
        return this.appendDefinition("POST", path, filter);
    }

    @Override
    public Route.Collection post(String path1, String path2, Route.Filter filter) {
        return new Route.Collection(this.post(path1, filter), this.post(path2, filter));
    }

    @Override
    public Route.Collection post(String path1, String path2, String path3, Route.Filter filter) {
        return new Route.Collection(this.post(path1, filter), this.post(path2, filter), this.post(path3, filter));
    }

    @Override
    public Route.Definition head(String path, Route.Handler handler) {
        return this.appendDefinition("HEAD", path, handler);
    }

    @Override
    public Route.Definition head(String path, Route.OneArgHandler handler) {
        return this.appendDefinition("HEAD", path, handler);
    }

    @Override
    public Route.Definition head(String path, Route.ZeroArgHandler handler) {
        return this.appendDefinition("HEAD", path, handler);
    }

    @Override
    public Route.Definition head(String path, Route.Filter filter) {
        return this.appendDefinition("HEAD", path, filter);
    }

    @Override
    public Route.Definition head() {
        return this.appendDefinition("HEAD", "*", this.filter(HeadHandler.class)).name("*.head");
    }

    @Override
    public Route.Definition options(String path, Route.Handler handler) {
        return this.appendDefinition("OPTIONS", path, handler);
    }

    @Override
    public Route.Definition options(String path, Route.OneArgHandler handler) {
        return this.appendDefinition("OPTIONS", path, handler);
    }

    @Override
    public Route.Definition options(String path, Route.ZeroArgHandler handler) {
        return this.appendDefinition("OPTIONS", path, handler);
    }

    @Override
    public Route.Definition options(String path, Route.Filter filter) {
        return this.appendDefinition("OPTIONS", path, filter);
    }

    @Override
    public Route.Definition options() {
        return this.appendDefinition("OPTIONS", "*", this.handler(OptionsHandler.class)).name("*.options");
    }

    @Override
    public Route.Definition put(String path, Route.Handler handler) {
        return this.appendDefinition("PUT", path, handler);
    }

    @Override
    public Route.Collection put(String path1, String path2, Route.Handler handler) {
        return new Route.Collection(this.put(path1, handler), this.put(path2, handler));
    }

    @Override
    public Route.Collection put(String path1, String path2, String path3, Route.Handler handler) {
        return new Route.Collection(this.put(path1, handler), this.put(path2, handler), this.put(path3, handler));
    }

    @Override
    public Route.Definition put(String path, Route.OneArgHandler handler) {
        return this.appendDefinition("PUT", path, handler);
    }

    @Override
    public Route.Collection put(String path1, String path2, Route.OneArgHandler handler) {
        return new Route.Collection(this.put(path1, handler), this.put(path2, handler));
    }

    @Override
    public Route.Collection put(String path1, String path2, String path3, Route.OneArgHandler handler) {
        return new Route.Collection(this.put(path1, handler), this.put(path2, handler), this.put(path3, handler));
    }

    @Override
    public Route.Definition put(String path, Route.ZeroArgHandler handler) {
        return this.appendDefinition("PUT", path, handler);
    }

    @Override
    public Route.Collection put(String path1, String path2, Route.ZeroArgHandler handler) {
        return new Route.Collection(this.put(path1, handler), this.put(path2, handler));
    }

    @Override
    public Route.Collection put(String path1, String path2, String path3, Route.ZeroArgHandler handler) {
        return new Route.Collection(this.put(path1, handler), this.put(path2, handler), this.put(path3, handler));
    }

    @Override
    public Route.Definition put(String path, Route.Filter filter) {
        return this.appendDefinition("PUT", path, filter);
    }

    @Override
    public Route.Collection put(String path1, String path2, Route.Filter filter) {
        return new Route.Collection(this.put(path1, filter), this.put(path2, filter));
    }

    @Override
    public Route.Collection put(String path1, String path2, String path3, Route.Filter filter) {
        return new Route.Collection(this.put(path1, filter), this.put(path2, filter), this.put(path3, filter));
    }

    @Override
    public Route.Definition patch(String path, Route.Handler handler) {
        return this.appendDefinition("PATCH", path, handler);
    }

    @Override
    public Route.Collection patch(String path1, String path2, Route.Handler handler) {
        return new Route.Collection(this.patch(path1, handler), this.patch(path2, handler));
    }

    @Override
    public Route.Collection patch(String path1, String path2, String path3, Route.Handler handler) {
        return new Route.Collection(this.patch(path1, handler), this.patch(path2, handler), this.patch(path3, handler));
    }

    @Override
    public Route.Definition patch(String path, Route.OneArgHandler handler) {
        return this.appendDefinition("PATCH", path, handler);
    }

    @Override
    public Route.Collection patch(String path1, String path2, Route.OneArgHandler handler) {
        return new Route.Collection(this.patch(path1, handler), this.patch(path2, handler));
    }

    @Override
    public Route.Collection patch(String path1, String path2, String path3, Route.OneArgHandler handler) {
        return new Route.Collection(this.patch(path1, handler), this.patch(path2, handler), this.patch(path3, handler));
    }

    @Override
    public Route.Definition patch(String path, Route.ZeroArgHandler handler) {
        return this.appendDefinition("PATCH", path, handler);
    }

    @Override
    public Route.Collection patch(String path1, String path2, Route.ZeroArgHandler handler) {
        return new Route.Collection(this.patch(path1, handler), this.patch(path2, handler));
    }

    @Override
    public Route.Collection patch(String path1, String path2, String path3, Route.ZeroArgHandler handler) {
        return new Route.Collection(this.patch(path1, handler), this.patch(path2, handler), this.patch(path3, handler));
    }

    @Override
    public Route.Definition patch(String path, Route.Filter filter) {
        return this.appendDefinition("PATCH", path, filter);
    }

    @Override
    public Route.Collection patch(String path1, String path2, Route.Filter filter) {
        return new Route.Collection(this.patch(path1, filter), this.patch(path2, filter));
    }

    @Override
    public Route.Collection patch(String path1, String path2, String path3, Route.Filter filter) {
        return new Route.Collection(this.patch(path1, filter), this.patch(path2, filter), this.patch(path3, filter));
    }

    @Override
    public Route.Definition delete(String path, Route.Handler handler) {
        return this.appendDefinition("DELETE", path, handler);
    }

    @Override
    public Route.Collection delete(String path1, String path2, Route.Handler handler) {
        return new Route.Collection(this.delete(path1, handler), this.delete(path2, handler));
    }

    @Override
    public Route.Collection delete(String path1, String path2, String path3, Route.Handler handler) {
        return new Route.Collection(this.delete(path1, handler), this.delete(path2, handler), this.delete(path3, handler));
    }

    @Override
    public Route.Definition delete(String path, Route.OneArgHandler handler) {
        return this.appendDefinition("DELETE", path, handler);
    }

    @Override
    public Route.Collection delete(String path1, String path2, Route.OneArgHandler handler) {
        return new Route.Collection(this.delete(path1, handler), this.delete(path2, handler));
    }

    @Override
    public Route.Collection delete(String path1, String path2, String path3, Route.OneArgHandler handler) {
        return new Route.Collection(this.delete(path1, handler), this.delete(path2, handler), this.delete(path3, handler));
    }

    @Override
    public Route.Definition delete(String path, Route.ZeroArgHandler handler) {
        return this.appendDefinition("DELETE", path, handler);
    }

    @Override
    public Route.Collection delete(String path1, String path2, Route.ZeroArgHandler handler) {
        return new Route.Collection(this.delete(path1, handler), this.delete(path2, handler));
    }

    @Override
    public Route.Collection delete(String path1, String path2, String path3, Route.ZeroArgHandler handler) {
        return new Route.Collection(this.delete(path1, handler), this.delete(path2, handler), this.delete(path3, handler));
    }

    @Override
    public Route.Definition delete(String path, Route.Filter filter) {
        return this.appendDefinition("DELETE", path, filter);
    }

    @Override
    public Route.Collection delete(String path1, String path2, Route.Filter filter) {
        return new Route.Collection(this.delete(path1, filter), this.delete(path2, filter));
    }

    @Override
    public Route.Collection delete(String path1, String path2, String path3, Route.Filter filter) {
        return new Route.Collection(this.delete(path1, filter), this.delete(path2, filter), this.delete(path3, filter));
    }

    @Override
    public Route.Definition trace(String path, Route.Handler handler) {
        return this.appendDefinition("TRACE", path, handler);
    }

    @Override
    public Route.Definition trace(String path, Route.OneArgHandler handler) {
        return this.appendDefinition("TRACE", path, handler);
    }

    @Override
    public Route.Definition trace(String path, Route.ZeroArgHandler handler) {
        return this.appendDefinition("TRACE", path, handler);
    }

    @Override
    public Route.Definition trace(String path, Route.Filter filter) {
        return this.appendDefinition("TRACE", path, filter);
    }

    @Override
    public Route.Definition trace() {
        return this.appendDefinition("TRACE", "*", this.handler(TraceHandler.class)).name("*.trace");
    }

    @Override
    public Route.Definition connect(String path, Route.Handler handler) {
        return this.appendDefinition("CONNECT", path, handler);
    }

    @Override
    public Route.Definition connect(String path, Route.OneArgHandler handler) {
        return this.appendDefinition("CONNECT", path, handler);
    }

    @Override
    public Route.Definition connect(String path, Route.ZeroArgHandler handler) {
        return this.appendDefinition("CONNECT", path, handler);
    }

    @Override
    public Route.Definition connect(String path, Route.Filter filter) {
        return this.appendDefinition("CONNECT", path, filter);
    }

    private Route.Handler handler(Class<? extends Route.Handler> handler) {
        Objects.requireNonNull(handler, "Route handler is required.");
        return (req, rsp) -> ((Route.Handler)req.require(handler)).handle(req, rsp);
    }

    private Route.Filter filter(Class<? extends Route.Filter> filter) {
        Objects.requireNonNull(filter, "Filter is required.");
        return (req, rsp, chain) -> ((Route.Filter)req.require(filter)).handle(req, rsp, chain);
    }

    @Override
    public Route.AssetDefinition assets(String path, java.nio.file.Path basedir) {
        return this.assets(path, new AssetHandler(basedir));
    }

    @Override
    public Route.AssetDefinition assets(String path, String location) {
        return this.assets(path, new AssetHandler(location));
    }

    @Override
    public Route.AssetDefinition assets(String path, AssetHandler handler) {
        Route.AssetDefinition route = (Route.AssetDefinition)this.appendDefinition("GET", path, handler, Route.AssetDefinition::new);
        return this.configureAssetHandler(route);
    }

    @Override
    public Route.Collection use(Class<?> routeClass) {
        return this.use("", routeClass);
    }

    @Override
    public Route.Collection use(String path, Class<?> routeClass) {
        Objects.requireNonNull(routeClass, "Route class is required.");
        Objects.requireNonNull(path, "Path is required");
        MvcClass mvc = new MvcClass(routeClass, path, this.prefix);
        this.bag.add(mvc);
        return new Route.Collection(mvc);
    }

    private Route.Definition appendDefinition(String method, String pattern, Route.Filter filter) {
        return this.appendDefinition(method, pattern, filter, Route.Definition::new);
    }

    private <T extends Route.Definition> T appendDefinition(String method, String pattern, Route.Filter filter, Throwing.Function4<String, String, Route.Filter, Boolean, T> creator) {
        String pathPattern = this.prefixPath(pattern).orElse(pattern);
        Route.Definition route = (Route.Definition)creator.apply((Object)method, (Object)pathPattern, (Object)filter, (Object)this.caseSensitiveRouting);
        if (this.prefix != null) {
            route.prefix = this.prefix;
            route.name(route.name());
        }
        this.bag.add(route);
        return (T)route;
    }

    public Jooby use(Module module) {
        Objects.requireNonNull(module, "A module is required.");
        this.bag.add(module);
        return this;
    }

    public Jooby conf(String path) {
        this.confname = path;
        this.use(ConfigFactory.parseResources((String)path));
        return this;
    }

    public Jooby conf(File path) {
        this.confname = path.getName();
        this.use(ConfigFactory.parseFile((File)path));
        return this;
    }

    public Jooby use(Config config) {
        this.srcconf = Objects.requireNonNull(config, "Config required.");
        return this;
    }

    @Override
    public Jooby err(Err.Handler err) {
        this.bag.add(Objects.requireNonNull(err, "An err handler is required."));
        return this;
    }

    @Override
    public WebSocket.Definition ws(String path, WebSocket.OnOpen handler) {
        WebSocket.Definition ws = new WebSocket.Definition(path, handler);
        Preconditions.checkArgument((boolean)this.bag.add(ws), (String)"Duplicated path: '%s'", (Object)path);
        return ws;
    }

    @Override
    public <T> WebSocket.Definition ws(String path, Class<? extends WebSocket.OnMessage<T>> handler) {
        String fpath = Optional.ofNullable(handler.getAnnotation(Path.class)).map((? super T it) -> path + "/" + it.value()[0]).orElse(path);
        WebSocket.Definition ws = this.ws(fpath, MvcWebSocket.newWebSocket(handler));
        Optional.ofNullable(handler.getAnnotation(Consumes.class)).ifPresent(consumes -> Arrays.asList(consumes.value()).forEach(ws::consumes));
        Optional.ofNullable(handler.getAnnotation(Produces.class)).ifPresent(produces -> Arrays.asList(produces.value()).forEach(ws::produces));
        return ws;
    }

    @Override
    public Route.Definition sse(String path, Sse.Handler handler) {
        return (Route.Definition)this.appendDefinition("GET", path, handler).consumes(MediaType.sse);
    }

    @Override
    public Route.Definition sse(String path, Sse.Handler1 handler) {
        return (Route.Definition)this.appendDefinition("GET", path, handler).consumes(MediaType.sse);
    }

    @Override
    public Route.Collection with(Runnable callback) {
        int size = this.bag.size();
        callback.run();
        List<Route.Props> local = this.bag.stream().skip(size).filter(Route.Props.class::isInstance).map(Route.Props.class::cast).collect(Collectors.toList());
        return new Route.Collection(local.toArray(new Route.Props[local.size()]));
    }

    public static void run(Supplier<? extends Jooby> app, String ... args) {
        Config conf = ConfigFactory.systemProperties().withFallback((ConfigMergeable)Jooby.args(args));
        System.setProperty("logback.configurationFile", Jooby.logback(conf));
        app.get().start(args);
    }

    public static void run(Class<? extends Jooby> app, String ... args) {
        Jooby.run(() -> (Jooby)Try.apply(() -> (Jooby)app.newInstance()).get(), args);
    }

    public static Config exportConf(Jooby app) {
        AtomicReference<Config> conf = new AtomicReference<Config>(ConfigFactory.empty());
        app.on("*", (Config c) -> conf.set((Config)c));
        Jooby.exportRoutes(app);
        return conf.get();
    }

    public static List<Route.Definition> exportRoutes(Jooby app) {
        class Success
        extends RuntimeException {
            List<Route.Definition> routes;

            Success(List<Route.Definition> routes) {
                this.routes = routes;
            }
        }
        List<Route.Definition> routes = Collections.emptyList();
        try {
            app.start(new String[0], (List<Route.Definition> r) -> {
                throw new Success((List<Route.Definition>)r);
            });
        }
        catch (Success success) {
            routes = success.routes;
        }
        catch (Throwable x) {
            Jooby.logger(app).debug("Failed bootstrap: {}", (Object)app, (Object)x);
        }
        return routes;
    }

    public void start() {
        this.start(new String[0]);
    }

    public void start(String ... args) {
        try {
            this.start(args, (Consumer<List<Route.Definition>>)null);
        }
        catch (Throwable x) {
            this.stop();
            String msg = "An error occurred while starting the application:";
            if (this.throwBootstrapException) {
                throw new Err(Status.SERVICE_UNAVAILABLE, msg, x);
            }
            Jooby.logger(this).error(msg, x);
        }
    }

    private void start(String[] args, Consumer<List<Route.Definition>> routes) throws Throwable {
        boolean join;
        long start = System.currentTimeMillis();
        this.started.set(true);
        this.injector = this.bootstrap(Jooby.args(args), routes);
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
        Config conf = (Config)this.injector.getInstance(Config.class);
        Logger log = Jooby.logger(this);
        this.injector.injectMembers((Object)this);
        if (conf.hasPath("jooby.internal.onStart")) {
            ClassLoader loader = this.getClass().getClassLoader();
            Object obj = loader.loadClass(conf.getString("jooby.internal.onStart")).newInstance();
            this.onStart.add((Throwing.Consumer<Registry>)((Throwing.Consumer)obj));
        }
        for (Throwing.Consumer consumer : this.onStart) {
            consumer.accept((Object)this);
        }
        Set routeDefs = (Set)this.injector.getInstance(Route.KEY);
        Set set = (Set)this.injector.getInstance(WebSocket.KEY);
        if (this.mapper != null) {
            routeDefs.forEach(it -> it.map(this.mapper));
        }
        AppPrinter printer = new AppPrinter(routeDefs, set, conf);
        printer.printConf(log, conf);
        Server server = (Server)this.injector.getInstance(Server.class);
        String serverName = server.getClass().getSimpleName().replace("Server", "").toLowerCase();
        server.start();
        long end = System.currentTimeMillis();
        log.info("[{}@{}]: Server started in {}ms\n\n{}\n", new Object[]{conf.getString("application.env"), serverName, end - start, printer});
        for (Throwing.Consumer<Registry> onStarted : this.onStarted) {
            onStarted.accept((Object)this);
        }
        boolean bl = join = conf.hasPath("server.join") ? conf.getBoolean("server.join") : true;
        if (join) {
            server.join();
        }
    }

    @Override
    public Jooby map(Route.Mapper<?> mapper) {
        Objects.requireNonNull(mapper, "Mapper is required.");
        if (this.mappers.add(mapper.name())) {
            this.mapper = Optional.ofNullable(this.mapper).map((? super T next) -> Route.Mapper.chain(mapper, next)).orElse(mapper);
        }
        return this;
    }

    public Jooby injector(BiFunction<Stage, com.google.inject.Module, Injector> injectorFactory) {
        this.injectorFactory = injectorFactory;
        return this;
    }

    public <T> Jooby bind(Class<T> type, Class<? extends T> implementation) {
        this.use((Env env, Config conf, Binder binder) -> binder.bind(type).to(implementation));
        return this;
    }

    public <T> Jooby bind(Class<T> type, Supplier<T> implementation) {
        this.use((Env env, Config conf, Binder binder) -> binder.bind(type).toInstance(implementation.get()));
        return this;
    }

    public <T> Jooby bind(Class<T> type) {
        this.use((Env env, Config conf, Binder binder) -> binder.bind(type));
        return this;
    }

    public Jooby bind(Object service) {
        this.use((Env env, Config conf, Binder binder) -> {
            Class<?> type = service.getClass();
            binder.bind(type).toInstance(service);
        });
        return this;
    }

    public <T> Jooby bind(Class<T> type, Function<Config, ? extends T> provider) {
        this.use((Env env, Config conf, Binder binder) -> {
            Object service = provider.apply(conf);
            binder.bind(type).toInstance(service);
        });
        return this;
    }

    public <T> Jooby bind(Function<Config, T> provider) {
        this.use((Env env, Config conf, Binder binder) -> {
            Object service = provider.apply(conf);
            Class<?> type = service.getClass();
            binder.bind(type).toInstance(service);
        });
        return this;
    }

    public Jooby dateFormat(String dateFormat) {
        this.dateFormat = Objects.requireNonNull(dateFormat, "DateFormat required.");
        return this;
    }

    public Jooby numberFormat(String numberFormat) {
        this.numberFormat = Objects.requireNonNull(numberFormat, "NumberFormat required.");
        return this;
    }

    public Jooby charset(Charset charset) {
        this.charset = Objects.requireNonNull(charset, "Charset required.");
        return this;
    }

    public Jooby lang(String ... languages) {
        this.languages = languages;
        return this;
    }

    public Jooby timezone(ZoneId zoneId) {
        this.zoneId = Objects.requireNonNull(zoneId, "ZoneId required.");
        return this;
    }

    public Jooby port(int port) {
        this.port = port;
        return this;
    }

    public Jooby securePort(int port) {
        this.securePort = port;
        return this;
    }

    public Jooby http2() {
        this.http2 = true;
        return this;
    }

    public Jooby executor(ExecutorService executor) {
        this.executor((Executor)executor);
        this.onStop(r -> executor.shutdown());
        return this;
    }

    public Jooby executor(Executor executor) {
        this.defaultExecSet = true;
        this.executors.add(binder -> {
            binder.bind(Key.get(String.class, (Annotation)Names.named((String)"deferred"))).toInstance((Object)"deferred");
            binder.bind(Key.get(Executor.class, (Annotation)Names.named((String)"deferred"))).toInstance((Object)executor);
        });
        return this;
    }

    public Jooby executor(String name, ExecutorService executor) {
        this.executor(name, (Executor)executor);
        this.onStop(r -> executor.shutdown());
        return this;
    }

    public Jooby executor(String name, Executor executor) {
        this.executors.add(binder -> binder.bind(Key.get(Executor.class, (Annotation)Names.named((String)name))).toInstance((Object)executor));
        return this;
    }

    public Jooby executor(String name) {
        this.defaultExecSet = true;
        this.executors.add(binder -> binder.bind(Key.get(String.class, (Annotation)Names.named((String)"deferred"))).toInstance((Object)name));
        return this;
    }

    private Jooby executor(String name, Class<? extends Provider<Executor>> provider) {
        this.executors.add(binder -> binder.bind(Key.get(Executor.class, (Annotation)Names.named((String)name))).toProvider(provider).in(Singleton.class));
        return this;
    }

    public Jooby throwBootstrapException() {
        this.throwBootstrapException = true;
        return this;
    }

    public Jooby caseSensitiveRouting(boolean enabled) {
        this.caseSensitiveRouting = enabled;
        return this;
    }

    private static List<Object> normalize(List<Object> services, Env env, RouteMetadata classInfo, boolean caseSensitiveRouting) {
        ArrayList<Object> result = new ArrayList<Object>();
        List<Object> snapshot = services;
        snapshot.forEach(candidate -> {
            if (candidate instanceof Route.Definition) {
                result.add(candidate);
            } else if (candidate instanceof MvcClass) {
                MvcClass mvcRoute = (MvcClass)candidate;
                Class<?> mvcClass = mvcRoute.routeClass;
                String path = ((MvcClass)candidate).path;
                MvcRoutes.routes(env, classInfo, path, caseSensitiveRouting, mvcClass).forEach(route -> result.add(mvcRoute.apply((Route.Definition)route)));
            } else {
                result.add(candidate);
            }
        });
        return result;
    }

    private static List<Object> processEnvDep(Set<Object> src, Env env) {
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<Object> bag = new ArrayList<Object>(src);
        bag.forEach(it -> {
            if (it instanceof EnvDep) {
                EnvDep envdep = (EnvDep)it;
                if (envdep.predicate.test(env.name())) {
                    int from = src.size();
                    envdep.callback.accept(env.config());
                    int to = src.size();
                    result.addAll(new ArrayList(src).subList(from, to));
                }
            } else {
                result.add(it);
            }
        });
        return result;
    }

    private Injector bootstrap(Config args, Consumer<List<Route.Definition>> rcallback) throws Throwable {
        boolean cookieSession;
        Env finalEnv;
        Config finalConfig;
        Config initconf = Optional.ofNullable(this.srcconf).orElseGet(() -> ConfigFactory.parseResources((String)"application.conf"));
        List<Config> modconf = Jooby.modconf(this.bag);
        Config conf = this.buildConfig(initconf, args, modconf);
        List<Locale> locales = LocaleUtils.parse(conf.getString("application.lang"));
        Env env = this.env.build(conf, this, locales.get(0));
        String envname = env.name();
        Charset charset = Charset.forName(conf.getString("application.charset"));
        String dateFormat = conf.getString("application.dateFormat");
        ZoneId zoneId = ZoneId.of(conf.getString("application.tz"));
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(dateFormat, locales.get(0)).withZone(zoneId);
        DateTimeFormatter zonedDateTimeFormat = DateTimeFormatter.ofPattern(conf.getString("application.zonedDateTimeFormat"));
        DecimalFormat numberFormat = new DecimalFormat(conf.getString("application.numberFormat"));
        Stage stage = "dev".equals(envname) ? Stage.DEVELOPMENT : Stage.PRODUCTION;
        RouteMetadata rm = new RouteMetadata(env);
        List<Object> realbag = Jooby.processEnvDep(this.bag, env);
        List<Config> realmodconf = Jooby.modconf(realbag);
        List<Object> bag = Jooby.normalize(realbag, env, rm, this.caseSensitiveRouting);
        if (rcallback != null) {
            List routes = bag.stream().filter((? super T it) -> it instanceof Route.Definition).map((? super T it) -> (Route.Definition)it).collect(Collectors.toList());
            rcallback.accept(routes);
        }
        if (modconf.size() != realmodconf.size()) {
            finalConfig = this.buildConfig(initconf, args, realmodconf);
            finalEnv = this.env.build(finalConfig, this, locales.get(0));
        } else {
            finalConfig = conf;
            finalEnv = env;
        }
        boolean bl = cookieSession = this.session.store() == null;
        if (cookieSession && !finalConfig.hasPath("application.secret")) {
            throw new IllegalStateException("Required property 'application.secret' is missing");
        }
        if (!this.defaultExecSet) {
            this.executor(MoreExecutors.directExecutor());
        }
        this.executor("direct", MoreExecutors.directExecutor());
        this.executor("server", ServerExecutorProvider.class);
        this.xss(finalEnv);
        com.google.inject.Module joobyModule = binder -> {
            new TypeConverters().configure(binder);
            this.bindConfig(binder, finalConfig);
            binder.bind(Env.class).toInstance((Object)finalEnv);
            binder.bind(Charset.class).toInstance((Object)charset);
            binder.bind(Locale.class).toInstance(locales.get(0));
            TypeLiteral localeType = TypeLiteral.get((Type)Types.listOf(Locale.class));
            binder.bind(localeType).toInstance((Object)locales);
            binder.bind(ZoneId.class).toInstance((Object)zoneId);
            binder.bind(TimeZone.class).toInstance((Object)TimeZone.getTimeZone(zoneId));
            binder.bind(DateTimeFormatter.class).toInstance((Object)dateTimeFormatter);
            binder.bind(NumberFormat.class).toInstance((Object)numberFormat);
            binder.bind(DecimalFormat.class).toInstance((Object)numberFormat);
            binder.bind(SSLContext.class).toProvider(SslContextProvider.class);
            Multibinder definitions = Multibinder.newSetBinder((Binder)binder, Route.Definition.class);
            Multibinder sockets = Multibinder.newSetBinder((Binder)binder, WebSocket.Definition.class);
            File tmpdir = new File(finalConfig.getString("application.tmpdir"));
            tmpdir.mkdirs();
            binder.bind(File.class).annotatedWith((Annotation)Names.named((String)"application.tmpdir")).toInstance((Object)tmpdir);
            binder.bind(ParameterNameProvider.class).toInstance((Object)rm);
            Multibinder ehandlers = Multibinder.newSetBinder((Binder)binder, Err.Handler.class);
            Multibinder parsers = Multibinder.newSetBinder((Binder)binder, Parser.class);
            Multibinder renderers = Multibinder.newSetBinder((Binder)binder, Renderer.class);
            parsers.addBinding().toInstance((Object)BuiltinParser.Basic);
            parsers.addBinding().toInstance((Object)BuiltinParser.Collection);
            parsers.addBinding().toInstance((Object)BuiltinParser.Optional);
            parsers.addBinding().toInstance((Object)BuiltinParser.Enum);
            parsers.addBinding().toInstance((Object)BuiltinParser.Bytes);
            renderers.addBinding().toInstance((Object)BuiltinRenderer.asset);
            renderers.addBinding().toInstance((Object)BuiltinRenderer.bytes);
            renderers.addBinding().toInstance((Object)BuiltinRenderer.byteBuffer);
            renderers.addBinding().toInstance((Object)BuiltinRenderer.file);
            renderers.addBinding().toInstance((Object)BuiltinRenderer.charBuffer);
            renderers.addBinding().toInstance((Object)BuiltinRenderer.stream);
            renderers.addBinding().toInstance((Object)BuiltinRenderer.reader);
            renderers.addBinding().toInstance((Object)BuiltinRenderer.fileChannel);
            HashSet routeClasses = new HashSet();
            for (Object it2 : bag) {
                Try.run(() -> Jooby.bindService(Jooby.logger(this), this.bag, finalConfig, finalEnv, rm, binder, (Multibinder<Route.Definition>)definitions, (Multibinder<WebSocket.Definition>)sockets, (Multibinder<Err.Handler>)ehandlers, (Multibinder<Parser>)parsers, (Multibinder<Renderer>)renderers, routeClasses, this.caseSensitiveRouting).accept(it2)).throwException();
            }
            parsers.addBinding().toInstance((Object)new DateParser(dateFormat));
            parsers.addBinding().toInstance((Object)new LocalDateParser(dateTimeFormatter));
            parsers.addBinding().toInstance((Object)new ZonedDateTimeParser(zonedDateTimeFormat));
            parsers.addBinding().toInstance((Object)new LocaleParser());
            parsers.addBinding().toInstance((Object)new StaticMethodParser("valueOf"));
            parsers.addBinding().toInstance((Object)new StaticMethodParser("fromString"));
            parsers.addBinding().toInstance((Object)new StaticMethodParser("forName"));
            parsers.addBinding().toInstance((Object)new StringConstructorParser());
            parsers.addBinding().toInstance((Object)this.beanParser.orElseGet(() -> new BeanParser(false)));
            binder.bind(ParserExecutor.class).in(Singleton.class);
            renderers.addBinding().toInstance((Object)new DefaulErrRenderer());
            renderers.addBinding().toInstance((Object)BuiltinRenderer.text);
            binder.bind(HttpHandler.class).to(HttpHandlerImpl.class).in(Singleton.class);
            RequestScope requestScope = new RequestScope();
            binder.bind(RequestScope.class).toInstance((Object)requestScope);
            binder.bindScope(RequestScoped.class, (Scope)requestScope);
            binder.bind(Session.Definition.class).toProvider(Jooby.session(finalConfig.getConfig("session"), this.session)).asEagerSingleton();
            Object sstore = this.session.store();
            if (cookieSession) {
                binder.bind(SessionManager.class).to(CookieSessionManager.class).asEagerSingleton();
            } else {
                binder.bind(SessionManager.class).to(ServerSessionManager.class).asEagerSingleton();
                if (sstore instanceof Class) {
                    binder.bind(Session.Store.class).to((Class)sstore).asEagerSingleton();
                } else {
                    binder.bind(Session.Store.class).toInstance((Object)((Session.Store)sstore));
                }
            }
            binder.bind(Request.class).toProvider(Providers.outOfScope(Request.class)).in(RequestScoped.class);
            binder.bind(Route.Chain.class).toProvider(Providers.outOfScope(Route.Chain.class)).in(RequestScoped.class);
            binder.bind(Response.class).toProvider(Providers.outOfScope(Response.class)).in(RequestScoped.class);
            binder.bind(Sse.class).toProvider(Providers.outOfScope(Sse.class)).in(RequestScoped.class);
            binder.bind(Session.class).toProvider(Providers.outOfScope(Session.class)).in(RequestScoped.class);
            ehandlers.addBinding().toInstance((Object)new Err.DefHandler());
            this.executors.forEach(it -> it.accept(binder));
        };
        Injector injector = this.injectorFactory.apply(stage, joobyModule);
        if (this.apprefs != null) {
            this.apprefs.forEach(app -> {
                app.injector = injector;
            });
            this.apprefs.clear();
            this.apprefs = null;
        }
        this.onStart.addAll(0, finalEnv.startTasks());
        this.onStarted.addAll(0, finalEnv.startedTasks());
        this.onStop.addAll(finalEnv.stopTasks());
        this.bag.clear();
        this.bag = ImmutableSet.of();
        this.executors.clear();
        this.executors = ImmutableList.of();
        return injector;
    }

    private void xss(Env env) {
        Escaper ufe = UrlEscapers.urlFragmentEscaper();
        Escaper fpe = UrlEscapers.urlFormParameterEscaper();
        Escaper pse = UrlEscapers.urlPathSegmentEscaper();
        Escaper html = HtmlEscapers.htmlEscaper();
        env.xss("urlFragment", arg_0 -> ((Escaper)ufe).escape(arg_0)).xss("formParam", arg_0 -> ((Escaper)fpe).escape(arg_0)).xss("pathSegment", arg_0 -> ((Escaper)pse).escape(arg_0)).xss("html", arg_0 -> ((Escaper)html).escape(arg_0));
    }

    private static Provider<Session.Definition> session(Config $session, Session.Definition session) {
        return () -> {
            session.saveInterval(session.saveInterval().orElse($session.getDuration("saveInterval", TimeUnit.MILLISECONDS)));
            Cookie.Definition source = session.cookie();
            source.name(source.name().orElse($session.getString("cookie.name")));
            if (!source.comment().isPresent() && $session.hasPath("cookie.comment")) {
                source.comment($session.getString("cookie.comment"));
            }
            if (!source.domain().isPresent() && $session.hasPath("cookie.domain")) {
                source.domain($session.getString("cookie.domain"));
            }
            source.httpOnly(source.httpOnly().orElse($session.getBoolean("cookie.httpOnly")));
            Object maxAge = $session.getAnyRef("cookie.maxAge");
            if (maxAge instanceof String) {
                maxAge = $session.getDuration("cookie.maxAge", TimeUnit.SECONDS);
            }
            source.maxAge(source.maxAge().orElse(((Number)maxAge).intValue()));
            source.path(source.path().orElse($session.getString("cookie.path")));
            source.secure(source.secure().orElse($session.getBoolean("cookie.secure")));
            return session;
        };
    }

    private static Throwing.Consumer<? super Object> bindService(Logger log, Set<Object> src, Config conf, Env env, RouteMetadata rm, Binder binder, Multibinder<Route.Definition> definitions, Multibinder<WebSocket.Definition> sockets, Multibinder<Err.Handler> ehandlers, Multibinder<Parser> parsers, Multibinder<Renderer> renderers, Set<Object> routeClasses, boolean caseSensitiveRouting) {
        return it -> {
            if (it instanceof Module) {
                int from = src.size();
                Jooby.install(log, (Module)it, env, conf, binder);
                int to = src.size();
                if (to > from) {
                    List<Object> elements = Jooby.normalize(new ArrayList(src).subList(from, to), env, rm, caseSensitiveRouting);
                    for (Object e : elements) {
                        Jooby.bindService(log, src, conf, env, rm, binder, definitions, sockets, ehandlers, parsers, renderers, routeClasses, caseSensitiveRouting).accept(e);
                    }
                }
            } else if (it instanceof Route.Definition) {
                Route.Definition rdef = (Route.Definition)it;
                Route.Filter h = rdef.filter();
                if (h instanceof Route.MethodHandler) {
                    Class<?> routeClass = ((Route.MethodHandler)h).implementingClass();
                    if (routeClasses.add(routeClass)) {
                        binder.bind(routeClass);
                    }
                    definitions.addBinding().toInstance((Object)rdef);
                } else {
                    definitions.addBinding().toInstance((Object)rdef);
                }
            } else if (it instanceof WebSocket.Definition) {
                sockets.addBinding().toInstance((Object)((WebSocket.Definition)it));
            } else if (it instanceof Parser) {
                parsers.addBinding().toInstance((Object)((Parser)it));
            } else if (it instanceof Renderer) {
                renderers.addBinding().toInstance((Object)((Renderer)it));
            } else {
                ehandlers.addBinding().toInstance((Object)((Err.Handler)it));
            }
        };
    }

    private static List<Config> modconf(Collection<Object> bag) {
        return bag.stream().filter((? super T it) -> it instanceof Module).map((? super T it) -> ((Module)it).config()).filter((? super T c) -> !c.isEmpty()).collect(Collectors.toList());
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public void stop() {
        if (this.started.compareAndSet(true, false)) {
            Logger log = Jooby.logger(this);
            Jooby.fireStop(this, log, this.onStop);
            if (this.injector != null) {
                try {
                    ((Server)this.injector.getInstance(Server.class)).stop();
                }
                catch (Throwable ex) {
                    log.debug("server.stop() resulted in exception", ex);
                }
            }
            this.injector = null;
            log.info("Stopped");
        }
    }

    private static void fireStop(Jooby app, Logger log, List<Throwing.Consumer<Registry>> onStop) {
        onStop.forEach(c -> Try.run(() -> c.accept((Object)app)).onFailure(x -> log.error("shutdown of {} resulted in error", c, x)));
    }

    private Config buildConfig(Config source, Config args, List<Config> modules) {
        Config system = ConfigFactory.systemProperties();
        Config tmpdir = source.hasPath("java.io.tmpdir") ? source : system;
        system = system.withValue("file.encoding", ConfigValueFactory.fromAnyRef((Object)System.getProperty("file.encoding"))).withValue("java.io.tmpdir", ConfigValueFactory.fromAnyRef((Object)Paths.get(tmpdir.getString("java.io.tmpdir"), new String[0]).normalize().toString()));
        Config moduleStack = ConfigFactory.empty();
        for (Config module : ImmutableList.copyOf(modules).reverse()) {
            moduleStack = moduleStack.withFallback((ConfigMergeable)module);
        }
        String env = Arrays.asList(system, args, source).stream().filter((? super T it) -> it.hasPath("application.env")).findFirst().map((? super T c) -> c.getString("application.env")).orElse("dev");
        String cpath = Arrays.asList(system, args, source).stream().filter((? super T it) -> it.hasPath("application.path")).findFirst().map((? super T c) -> c.getString("application.path")).orElse("/");
        Config envconf = this.envConf(source, env);
        Config conf = envconf.withFallback((ConfigMergeable)source);
        return system.withFallback((ConfigMergeable)args).withFallback((ConfigMergeable)conf).withFallback((ConfigMergeable)moduleStack).withFallback((ConfigMergeable)MediaType.types).withFallback((ConfigMergeable)this.defaultConfig(conf, Route.normalize(cpath))).resolve();
    }

    static Config args(String[] args) {
        if (args == null || args.length == 0) {
            return ConfigFactory.empty();
        }
        HashMap<String, String> conf = new HashMap<String, String>();
        for (String arg : args) {
            String value;
            String name;
            String[] values = arg.split("=");
            if (values.length == 2) {
                name = values[0];
                value = values[1];
            } else {
                name = "application.env";
                value = values[0];
            }
            if (name.indexOf(".") == -1) {
                conf.put("application." + name, value);
            }
            conf.put(name, value);
        }
        return ConfigFactory.parseMap(conf, (String)"args");
    }

    private Config envConf(Config source, String env) {
        String name = Optional.ofNullable(this.confname).orElse(source.origin().resource());
        Config result = ConfigFactory.empty();
        if (name != null) {
            int dot = name.lastIndexOf(46);
            name = name.substring(0, dot);
        } else {
            name = "application";
        }
        String envconfname = name + "." + env + ".conf";
        Config envconf = Jooby.fileConfig(envconfname);
        Config appconf = Jooby.fileConfig(name + ".conf");
        return result.withFallback((ConfigMergeable)envconf).withFallback((ConfigMergeable)appconf).withFallback((ConfigMergeable)ConfigFactory.parseResources((String)envconfname));
    }

    static Config fileConfig(String fname) {
        File dir = new File(System.getProperty("user.dir"));
        File froot = new File(dir, fname);
        if (froot.exists()) {
            return ConfigFactory.parseFile((File)froot);
        }
        File fconfig = new File(new File(dir, "conf"), fname);
        if (fconfig.exists()) {
            return ConfigFactory.parseFile((File)fconfig);
        }
        return ConfigFactory.empty();
    }

    private Config defaultConfig(Config conf, String cpath) {
        String ns = Optional.ofNullable(this.getClass().getPackage()).map(Package::getName).orElse("default." + this.getClass().getName());
        String[] parts = ns.split("\\.");
        String appname = parts[parts.length - 1];
        List locales = !conf.hasPath("application.lang") ? Optional.ofNullable(this.languages).map((? super T langs) -> LocaleUtils.parse(Joiner.on((String)",").join((Object[])langs))).orElse((List)ImmutableList.of((Object)Locale.getDefault())) : LocaleUtils.parse(conf.getString("application.lang"));
        Locale locale = locales.iterator().next();
        String lang = locale.toLanguageTag();
        String tz = !conf.hasPath("application.tz") ? Optional.ofNullable(this.zoneId).orElse(ZoneId.systemDefault()).getId() : conf.getString("application.tz");
        String nf = !conf.hasPath("application.numberFormat") ? Optional.ofNullable(this.numberFormat).orElseGet(() -> ((DecimalFormat)DecimalFormat.getInstance(locale)).toPattern()) : conf.getString("application.numberFormat");
        int processors = Runtime.getRuntime().availableProcessors();
        String version = Optional.ofNullable(this.getClass().getPackage()).map(Package::getImplementationVersion).filter(Objects::nonNull).orElse("0.0.0");
        Config defs = ConfigFactory.parseResources(Jooby.class, (String)"jooby.conf").withValue("contextPath", ConfigValueFactory.fromAnyRef((Object)(cpath.equals("/") ? "" : cpath))).withValue("application.name", ConfigValueFactory.fromAnyRef((Object)appname)).withValue("application.version", ConfigValueFactory.fromAnyRef((Object)version)).withValue("application.class", ConfigValueFactory.fromAnyRef((Object)this.classname)).withValue("application.ns", ConfigValueFactory.fromAnyRef((Object)ns)).withValue("application.lang", ConfigValueFactory.fromAnyRef((Object)lang)).withValue("application.tz", ConfigValueFactory.fromAnyRef((Object)tz)).withValue("application.numberFormat", ConfigValueFactory.fromAnyRef((Object)nf)).withValue("server.http2.enabled", ConfigValueFactory.fromAnyRef((Object)this.http2)).withValue("runtime.processors", ConfigValueFactory.fromAnyRef((Object)processors)).withValue("runtime.processors-plus1", ConfigValueFactory.fromAnyRef((Object)(processors + 1))).withValue("runtime.processors-plus2", ConfigValueFactory.fromAnyRef((Object)(processors + 2))).withValue("runtime.processors-x2", ConfigValueFactory.fromAnyRef((Object)(processors * 2))).withValue("runtime.processors-x4", ConfigValueFactory.fromAnyRef((Object)(processors * 4))).withValue("runtime.processors-x8", ConfigValueFactory.fromAnyRef((Object)(processors * 8))).withValue("runtime.concurrencyLevel", ConfigValueFactory.fromAnyRef((Object)Math.max(4, processors))).withValue("server.threads.Min", ConfigValueFactory.fromAnyRef((Object)Math.max(4, processors))).withValue("server.threads.Max", ConfigValueFactory.fromAnyRef((Object)Math.max(32, processors * 8)));
        if (this.charset != null) {
            defs = defs.withValue("application.charset", ConfigValueFactory.fromAnyRef((Object)this.charset.name()));
        }
        if (this.port != null) {
            defs = defs.withValue("application.port", ConfigValueFactory.fromAnyRef((Object)this.port));
        }
        if (this.securePort != null) {
            defs = defs.withValue("application.securePort", ConfigValueFactory.fromAnyRef((Object)this.securePort));
        }
        if (this.dateFormat != null) {
            defs = defs.withValue("application.dateFormat", ConfigValueFactory.fromAnyRef((Object)this.dateFormat));
        }
        return defs;
    }

    private static void install(Logger log, Module module, Env env, Config config, Binder binder) throws Throwable {
        module.configure(env, config, binder);
        try {
            binder.install(ProviderMethodsModule.forObject((Object)module));
        }
        catch (NoClassDefFoundError x) {
            log.debug("ignoring class not found from guice provider method", (Throwable)x);
        }
    }

    private void bindConfig(Binder binder, Config config) {
        Jooby.traverse(binder, "", config.root());
        for (Map.Entry entry : config.entrySet()) {
            String name = (String)entry.getKey();
            Named named = Names.named((String)name);
            Object value = ((ConfigValue)entry.getValue()).unwrapped();
            if (value instanceof List) {
                List values = (List)value;
                Class<String> listType = values.size() == 0 ? String.class : Types.listOf(values.iterator().next().getClass());
                Key key = Key.get(listType, (Annotation)Names.named((String)name));
                binder.bind(key).toInstance((Object)values);
                continue;
            }
            binder.bindConstant().annotatedWith((Annotation)named).to(value.toString());
        }
        binder.bind(Config.class).toInstance((Object)config);
    }

    private static void traverse(Binder binder, String p, ConfigObject root) {
        root.forEach((n, v) -> {
            if (v instanceof ConfigObject) {
                ConfigObject child = (ConfigObject)v;
                String path = p + n;
                Named named = Names.named((String)path);
                binder.bind(Config.class).annotatedWith((Annotation)named).toInstance((Object)child.toConfig());
                Jooby.traverse(binder, path + ".", child);
            }
        });
    }

    private static Predicate<String> envpredicate(String candidate) {
        return env -> env.equalsIgnoreCase(candidate) || candidate.equals("*");
    }

    static String logback(Config conf) {
        String logback;
        if (conf.hasPath("logback.configurationFile")) {
            logback = conf.getString("logback.configurationFile");
        } else {
            String env = conf.hasPath("application.env") ? conf.getString("application.env") : null;
            ImmutableList.Builder files = ImmutableList.builder();
            File userdir = new File(System.getProperty("user.dir"));
            File confdir = new File(userdir, "conf");
            if (env != null) {
                files.add((Object)new File(userdir, "logback." + env + ".xml"));
                files.add((Object)new File(confdir, "logback." + env + ".xml"));
            }
            files.add((Object)new File(userdir, "logback.xml"));
            files.add((Object)new File(confdir, "logback.xml"));
            logback = files.build().stream().filter(File::exists).map(File::getAbsolutePath).findFirst().orElseGet(() -> Optional.ofNullable(Jooby.class.getResource("/logback." + env + ".xml")).map(Objects::toString).orElse("logback.xml"));
        }
        return logback;
    }

    private static Logger logger(Jooby app) {
        return LoggerFactory.getLogger(app.getClass());
    }

    private Route.AssetDefinition configureAssetHandler(Route.AssetDefinition handler) {
        this.onStart(r -> {
            Config conf = r.require(Config.class);
            handler.cdn(conf.getString("assets.cdn")).lastModified(conf.getBoolean("assets.lastModified")).etag(conf.getBoolean("assets.etag")).maxAge(conf.getString("assets.cache.maxAge"));
        });
        return handler;
    }

    private String classname(String name) {
        if (name.equals(Jooby.class.getName()) || name.equals("org.jooby.Kooby")) {
            return SourceProvider.INSTANCE.get().map(StackTraceElement::getClassName).orElse(name);
        }
        return name;
    }

    static {
        String pid = System.getProperty("pid", JvmInfo.pid() + "");
        System.setProperty("pid", pid);
    }

    private static class EnvDep {
        Predicate<String> predicate;
        Consumer<Config> callback;

        public EnvDep(Predicate<String> predicate, Consumer<Config> callback) {
            this.predicate = predicate;
            this.callback = callback;
        }
    }

    static class MvcClass
    implements Route.Props<MvcClass> {
        Class<?> routeClass;
        String path;
        ImmutableMap.Builder<String, Object> attrs = ImmutableMap.builder();
        private List<MediaType> consumes;
        private String name;
        private List<MediaType> produces;
        private List<String> excludes;
        private Route.Mapper<?> mapper;
        private String prefix;
        private String renderer;

        public MvcClass(Class<?> routeClass, String path, String prefix) {
            this.routeClass = routeClass;
            this.path = path;
            this.prefix = prefix;
        }

        @Override
        public MvcClass attr(String name, Object value) {
            this.attrs.put((Object)name, value);
            return this;
        }

        @Override
        public MvcClass name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public MvcClass consumes(List<MediaType> consumes) {
            this.consumes = consumes;
            return this;
        }

        @Override
        public MvcClass produces(List<MediaType> produces) {
            this.produces = produces;
            return this;
        }

        @Override
        public MvcClass excludes(List<String> excludes) {
            this.excludes = excludes;
            return this;
        }

        @Override
        public MvcClass map(Route.Mapper<?> mapper) {
            this.mapper = mapper;
            return this;
        }

        @Override
        public String renderer() {
            return this.renderer;
        }

        @Override
        public MvcClass renderer(String name) {
            this.renderer = name;
            return this;
        }

        public Route.Definition apply(Route.Definition route) {
            this.attrs.build().forEach(route::attr);
            if (this.name != null) {
                route.name(this.name);
            }
            if (this.prefix != null) {
                route.name(this.prefix + "/" + route.name());
            }
            if (this.consumes != null) {
                route.consumes((List)this.consumes);
            }
            if (this.produces != null) {
                route.produces((List)this.produces);
            }
            if (this.excludes != null) {
                route.excludes((List)this.excludes);
            }
            if (this.mapper != null) {
                route.map((Route.Mapper)this.mapper);
            }
            if (this.renderer != null) {
                route.renderer(this.renderer);
            }
            return route;
        }
    }

    public static interface Module {
        @Nonnull
        default public Config config() {
            return ConfigFactory.empty();
        }

        public void configure(Env var1, Config var2, Binder var3) throws Throwable;
    }

    public static interface EnvPredicate {
        default public void orElse(Runnable callback) {
            this.orElse((Config conf) -> callback.run());
        }

        public void orElse(Consumer<Config> var1);
    }
}

