/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jooby.funzy.Throwing;
import org.jooby.internal.CookieImpl;

public interface Cookie {
    public static final Function<String, Map<String, String>> URL_DECODER = value -> {
        if (value == null) {
            return Collections.emptyMap();
        }
        Throwing.Function decode = v -> URLDecoder.decode(v, StandardCharsets.UTF_8.name());
        return Splitter.on((char)'&').trimResults().omitEmptyStrings().splitToList((CharSequence)value).stream().map(v -> {
            Iterator it = Splitter.on((char)'=').trimResults().omitEmptyStrings().split((CharSequence)v).iterator();
            return new String[]{(String)decode.apply(it.next()), it.hasNext() ? (String)decode.apply(it.next()) : null};
        }).filter(it -> Objects.nonNull(it[1])).collect(Collectors.toMap(it -> it[0], it -> it[1]));
    };
    public static final Function<Map<String, String>, String> URL_ENCODER = value -> {
        Throwing.Function encode = v -> URLEncoder.encode(v, StandardCharsets.UTF_8.name());
        return value.entrySet().stream().map(e -> new StringBuilder().append((String)encode.apply(e.getKey())).append('=').append((String)encode.apply(e.getValue()))).collect(Collectors.joining("&")).toString();
    };

    @Nonnull
    public String name();

    @Nonnull
    public Optional<String> value();

    @Nonnull
    public Optional<String> comment();

    @Nonnull
    public Optional<String> domain();

    public int maxAge();

    @Nonnull
    public Optional<String> path();

    public boolean secure();

    public boolean httpOnly();

    @Nonnull
    public String encode();

    public static class Signature {
        private static final Pattern EQ = Pattern.compile("=+$");
        public static final String HMAC_SHA256 = "HmacSHA256";
        private static final String SEP = "|";

        @Nonnull
        public static String sign(String value, String secret) {
            Objects.requireNonNull(value, "A value is required.");
            Objects.requireNonNull(secret, "A secret is required.");
            try {
                Mac mac = Mac.getInstance(HMAC_SHA256);
                mac.init(new SecretKeySpec(secret.getBytes(), HMAC_SHA256));
                byte[] bytes = mac.doFinal(value.getBytes());
                return EQ.matcher(BaseEncoding.base64().encode(bytes)).replaceAll("") + SEP + value;
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Can't sing value", ex);
            }
        }

        @Nullable
        public static String unsign(String value, String secret) {
            Objects.requireNonNull(value, "A value is required.");
            Objects.requireNonNull(secret, "A secret is required.");
            int sep = value.indexOf(SEP);
            if (sep <= 0) {
                return null;
            }
            String str = value.substring(sep + 1);
            String mac = Signature.sign(str, secret);
            return mac.equals(value) ? str : null;
        }

        public static boolean valid(String value, String secret) {
            return Signature.unsign(value, secret) != null;
        }
    }

    public static class Definition {
        private String name;
        private String value;
        private String domain;
        private String path;
        private String comment;
        private Boolean httpOnly;
        private Boolean secure;
        private Integer maxAge;

        protected Definition() {
        }

        public Definition(Definition def) {
            this.comment = def.comment;
            this.domain = def.domain;
            this.httpOnly = def.httpOnly;
            this.maxAge = def.maxAge;
            this.name = def.name;
            this.path = def.path;
            this.secure = def.secure;
            this.value = def.value;
        }

        public Definition(String name, String value) {
            this.name(name);
            this.value(value);
        }

        public Definition(String name) {
            this.name(name);
        }

        @Nonnull
        public Cookie toCookie() {
            return new CookieImpl(this);
        }

        public String toString() {
            return this.toCookie().encode();
        }

        @Nonnull
        public Definition name(String name) {
            this.name = Objects.requireNonNull(name, "A cookie name is required.");
            return this;
        }

        @Nonnull
        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        @Nonnull
        public Definition value(String value) {
            this.value = Objects.requireNonNull(value, "A cookie value is required.");
            return this;
        }

        @Nonnull
        public Optional<String> value() {
            if (Strings.isNullOrEmpty((String)this.value)) {
                return Optional.empty();
            }
            return Optional.of(this.value);
        }

        @Nonnull
        public Definition domain(String domain) {
            this.domain = Objects.requireNonNull(domain, "A cookie domain is required.");
            return this;
        }

        @Nonnull
        public Optional<String> domain() {
            return Optional.ofNullable(this.domain);
        }

        @Nonnull
        public Definition path(String path) {
            this.path = Objects.requireNonNull(path, "A cookie path is required.");
            return this;
        }

        @Nonnull
        public Optional<String> path() {
            return Optional.ofNullable(this.path);
        }

        @Nonnull
        public Definition comment(String comment) {
            this.comment = Objects.requireNonNull(comment, "A cookie comment is required.");
            return this;
        }

        @Nonnull
        public Optional<String> comment() {
            return Optional.ofNullable(this.comment);
        }

        @Nonnull
        public Definition httpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        @Nonnull
        public Optional<Boolean> httpOnly() {
            return Optional.ofNullable(this.httpOnly);
        }

        @Nonnull
        public Definition secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        @Nonnull
        public Optional<Boolean> secure() {
            return Optional.ofNullable(this.secure);
        }

        @Nonnull
        public Definition maxAge(int maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        @Nonnull
        public Optional<Integer> maxAge() {
            return Optional.ofNullable(this.maxAge);
        }
    }
}

