/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Longs;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.jooby.MediaType;
import org.jooby.funzy.Throwing;

public interface Asset {
    @Nonnull
    default public String name() {
        String path = this.path();
        int slash = path.lastIndexOf(47);
        return path.substring(slash + 1);
    }

    @Nonnull
    public String path();

    @Nonnull
    public URL resource();

    @Nonnull
    default public String etag() {
        try {
            StringBuilder b = new StringBuilder(32);
            b.append("W/\"");
            BaseEncoding b64 = BaseEncoding.base64();
            int lhash = this.resource().toURI().hashCode();
            b.append(b64.encode(Longs.toByteArray((long)(this.lastModified() ^ (long)lhash))));
            b.append(b64.encode(Longs.toByteArray((long)(this.length() ^ (long)lhash))));
            b.append('\"');
            return b.toString();
        }
        catch (URISyntaxException x) {
            throw Throwing.sneakyThrow((Throwable)x);
        }
    }

    public long length();

    public long lastModified();

    @Nonnull
    public InputStream stream() throws Exception;

    @Nonnull
    public MediaType type();

    public static class Forwarding
    implements Asset {
        private Asset asset;

        public Forwarding(Asset asset) {
            this.asset = Objects.requireNonNull(asset, "Asset is required.");
        }

        @Override
        public String etag() {
            return this.asset.etag();
        }

        @Override
        public String name() {
            return this.asset.name();
        }

        @Override
        public String path() {
            return this.asset.path();
        }

        @Override
        public URL resource() {
            return this.asset.resource();
        }

        @Override
        public long length() {
            return this.asset.length();
        }

        @Override
        public long lastModified() {
            return this.asset.lastModified();
        }

        @Override
        public InputStream stream() throws Exception {
            return this.asset.stream();
        }

        @Override
        public MediaType type() {
            return this.asset.type();
        }
    }
}

