/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.response;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import org.jolokia.client.request.JolokiaListRequest;
import org.jolokia.client.response.JolokiaResponse;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;

public final class JolokiaListResponse
extends JolokiaResponse<JolokiaListRequest> {
    private ObjectName pathObjectName;
    private String pathDomain;
    private String pathKeys;
    private String selectedUpdater;
    private final boolean useCache;

    public JolokiaListResponse(JolokiaListRequest pRequest, JSONObject pJsonResponse) {
        super(pRequest, pJsonResponse);
        JSONObject value = (JSONObject)this.getValue();
        this.useCache = value.size() == 2 && pJsonResponse.containsKey((Object)"cache") && pJsonResponse.containsKey((Object)"domains");
        this.rebuildResponse();
    }

    private void determineNesting() {
        JolokiaListRequest req = (JolokiaListRequest)this.getRequest();
        LinkedList<String> pathElements = new LinkedList<String>(req.getRequestParts());
        if (pathElements.isEmpty()) {
            this.pathObjectName = null;
            this.selectedUpdater = null;
        } else {
            String domain = (String)pathElements.pop();
            if (domain == null) {
                domain = "*";
            } else {
                this.pathDomain = domain;
            }
            String name = "*";
            if (!pathElements.isEmpty()) {
                name = (String)pathElements.pop();
                if (name == null) {
                    name = "*";
                } else {
                    this.pathKeys = name;
                }
            }
            try {
                this.pathObjectName = "*".equals(domain) && "*".equals(name) ? null : new ObjectName(domain + ":" + name);
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException("The response uses illegal ObjectPattern path: " + String.join((CharSequence)"/", req.getRequestParts()));
            }
            if (!pathElements.isEmpty()) {
                this.selectedUpdater = (String)pathElements.pop();
            }
        }
    }

    private void rebuildResponse() {
        this.determineNesting();
        JSONObject newValue = new JSONObject();
        if (this.useCache) {
            JSONObject oldValue = this.getValue(JSONObject.class);
            JSONObject cache = (JSONObject)oldValue.get((Object)"cache");
            JSONObject domains = (JSONObject)oldValue.get((Object)"domains");
            newValue.putAll((Map)domains);
            for (Map.Entry e : domains.entrySet()) {
                Object object = e.getValue();
                if (!(object instanceof JSONObject)) continue;
                JSONObject mbeans = (JSONObject)object;
                for (Map.Entry e2 : mbeans.entrySet()) {
                    String cacheKey;
                    Object cachedInfo;
                    Object v = e2.getValue();
                    if (!(v instanceof String) || (cachedInfo = cache.get((Object)(cacheKey = (String)v))) == null) continue;
                    ((JSONObject)newValue.get(e.getKey())).put((Object)((String)e2.getKey()), cachedInfo);
                }
            }
            oldValue.remove((Object)"cache");
            oldValue.remove((Object)"domains");
            this.asJSONObject().put((Object)"value", (Object)newValue);
        } else if (this.pathObjectName != null && !this.pathObjectName.isPattern() && this.selectedUpdater != null) {
            JSONObject domain = (JSONObject)newValue.computeIfAbsent((Object)this.pathDomain, k -> new JSONObject());
            JSONObject mbean = (JSONObject)domain.computeIfAbsent((Object)this.pathKeys, k -> new JSONObject());
            mbean.put((Object)this.selectedUpdater, this.getValue());
            this.asJSONObject().put((Object)"value", (Object)newValue);
        } else if (this.pathObjectName != null && !this.pathObjectName.isPattern() && this.selectedUpdater == null) {
            JSONObject domain = (JSONObject)newValue.computeIfAbsent((Object)this.pathDomain, k -> new JSONObject());
            JSONObject mbean = (JSONObject)domain.computeIfAbsent((Object)this.pathKeys, k -> this.getValue());
            this.asJSONObject().put((Object)"value", (Object)newValue);
        } else if (this.pathObjectName != null && !this.pathObjectName.isDomainPattern() && this.selectedUpdater == null) {
            JSONObject domain = (JSONObject)newValue.computeIfAbsent((Object)this.pathDomain, k -> this.getValue());
            this.asJSONObject().put((Object)"value", (Object)domain);
        }
    }

    public List<ObjectInstance> getObjectInstances(ObjectName name) throws MalformedObjectNameException {
        LinkedList<ObjectInstance> result = new LinkedList<ObjectInstance>();
        JSONObject domains = (JSONObject)this.getValue();
        for (Map.Entry e1 : domains.entrySet()) {
            String domain = (String)e1.getKey();
            Object object = e1.getValue();
            if (!(object instanceof JSONObject)) continue;
            JSONObject mbeans = (JSONObject)object;
            for (Map.Entry e2 : mbeans.entrySet()) {
                JSONObject data;
                String mbean = (String)e2.getKey();
                Object object2 = e2.getValue();
                if (!(object2 instanceof JSONObject) || !((object2 = (data = (JSONObject)object2).get((Object)"class")) instanceof String)) continue;
                String cls = (String)object2;
                result.add(new ObjectInstance(new ObjectName(domain + ":" + mbean), cls));
            }
        }
        return result;
    }

    public String getClassName(ObjectName name) throws InstanceNotFoundException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name can't be null"));
        }
        if (name.isPattern()) {
            return null;
        }
        JSONObject domains = (JSONObject)this.getValue();
        Object domain = domains.get((Object)name.getDomain());
        if (domain instanceof JSONObject) {
            JSONObject mbeans = (JSONObject)domain;
            Object mbean = mbeans.get((Object)this.pathKeys);
            if (mbean instanceof JSONObject) {
                String s;
                JSONObject info = (JSONObject)mbean;
                Object object = info.get((Object)"class");
                return object instanceof String ? (s = (String)object) : "<unknown>";
            }
            if (mbean == null && mbeans.size() == 1 && (mbean = mbeans.values().iterator().next()) instanceof JSONObject) {
                String s;
                JSONObject info = (JSONObject)mbean;
                Object object = info.get((Object)"class");
                return object instanceof String ? (s = (String)object) : "<unknown>";
            }
        }
        throw new InstanceNotFoundException("No " + String.valueOf(name) + " instance found");
    }

    public MBeanInfo getMbeanInfo(ObjectName name) throws InstanceNotFoundException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name can't be null"));
        }
        if (name.isPattern()) {
            return null;
        }
        JSONObject domains = (JSONObject)this.getValue();
        Object domain = domains.get((Object)name.getDomain());
        if (domain instanceof JSONObject) {
            JSONObject mbeans = (JSONObject)domain;
            Object mbean = mbeans.get((Object)this.pathKeys);
            if (mbean instanceof JSONObject) {
                JSONObject info = (JSONObject)mbean;
                return this.mBeanInfoFrom(name, info);
            }
            if (mbean == null && mbeans.size() == 1 && (mbean = mbeans.values().iterator().next()) instanceof JSONObject) {
                JSONObject info = (JSONObject)mbean;
                return this.mBeanInfoFrom(name, info);
            }
        }
        throw new InstanceNotFoundException("No " + String.valueOf(name) + " instance found");
    }

    private MBeanInfo mBeanInfoFrom(ObjectName name, JSONObject info) {
        Object classV = info.get((Object)"class");
        Object descriptionV = info.get((Object)"desc");
        Object attributesV = info.get((Object)"attr");
        Object constructorsV = info.get((Object)"ctor");
        Object operationsV = info.get((Object)"op");
        Object notificationsV = info.get((Object)"notif");
        if (classV != null && !(classV instanceof String)) {
            throw new IllegalStateException("Classname from MBeanInfo of " + String.valueOf(name) + " is invalid: " + String.valueOf(classV));
        }
        String className = (String)classV;
        if (descriptionV != null && !(descriptionV instanceof String)) {
            throw new IllegalStateException("Description from MBeanInfo of " + String.valueOf(name) + " is invalid: " + String.valueOf(descriptionV));
        }
        String description = (String)descriptionV;
        if (attributesV != null && !(attributesV instanceof JSONObject)) {
            throw new IllegalStateException("Attributes from MBeanInfo of " + String.valueOf(name) + " are invalid: " + String.valueOf(attributesV));
        }
        MBeanAttributeInfo[] attributes = this.attributesFrom((JSONObject)attributesV);
        if (operationsV != null && !(operationsV instanceof JSONObject)) {
            throw new IllegalStateException("Operations from MBeanInfo of " + String.valueOf(name) + " are invalid: " + String.valueOf(operationsV));
        }
        MBeanOperationInfo[] operations = this.operationsFrom((JSONObject)operationsV);
        if (constructorsV != null && !(constructorsV instanceof JSONObject)) {
            throw new IllegalStateException("Constructors from MBeanInfo of " + String.valueOf(name) + " are invalid: " + String.valueOf(operationsV));
        }
        MBeanConstructorInfo[] constructors = this.constructorsFrom((JSONObject)constructorsV);
        if (notificationsV != null && !(notificationsV instanceof JSONObject)) {
            throw new IllegalStateException("Notifications from MBeanInfo of " + String.valueOf(name) + " are invalid: " + String.valueOf(notificationsV));
        }
        MBeanNotificationInfo[] notifications = this.notificationsFrom((JSONObject)notificationsV);
        return new MBeanInfo(className, description, attributes, constructors, operations, notifications);
    }

    private MBeanAttributeInfo[] attributesFrom(JSONObject attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return new MBeanAttributeInfo[0];
        }
        TreeMap sorted = new TreeMap(attributes);
        MBeanAttributeInfo[] result = new MBeanAttributeInfo[sorted.size()];
        int index = 0;
        for (Map.Entry attribute : sorted.entrySet()) {
            if (!(attribute.getValue() instanceof JSONObject)) {
                throw new IllegalArgumentException("Representation of \"" + (String)attribute.getKey() + "\" is invalid: " + String.valueOf(attribute.getValue()));
            }
            result[index++] = this.attributeFrom((String)attribute.getKey(), (JSONObject)attribute.getValue());
        }
        return result;
    }

    private MBeanAttributeInfo attributeFrom(String name, JSONObject json) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        String descV;
        String typeV;
        Object object = json.get((Object)"type");
        String type = object instanceof String ? (typeV = (String)object) : "<unknown>";
        Object object2 = json.get((Object)"desc");
        String desc = object2 instanceof String ? (descV = (String)object2) : "";
        Object object3 = json.get((Object)"r");
        if (object3 instanceof Boolean) {
            Boolean rV = (Boolean)object3;
            bl4 = rV;
        } else {
            bl4 = false;
        }
        boolean r = bl4;
        Object object4 = json.get((Object)"w");
        if (object4 instanceof Boolean) {
            Boolean wV = (Boolean)object4;
            bl3 = wV;
        } else {
            bl3 = false;
        }
        boolean w = bl3;
        Object object5 = json.get((Object)"rw");
        if (object5 instanceof Boolean) {
            Boolean rwV = (Boolean)object5;
            bl2 = rwV;
        } else {
            bl2 = false;
        }
        boolean rw = bl2;
        Object object6 = json.get((Object)"is");
        if (object6 instanceof Boolean) {
            Boolean isV = (Boolean)object6;
            bl = isV;
        } else {
            bl = false;
        }
        boolean is = bl;
        return new MBeanAttributeInfo(name, type, desc, r, w, is);
    }

    private MBeanOperationInfo[] operationsFrom(JSONObject operations) {
        if (operations == null || operations.isEmpty()) {
            return new MBeanOperationInfo[0];
        }
        ArrayList<MBeanOperationInfo> result = new ArrayList<MBeanOperationInfo>(operations.size());
        for (Map.Entry operation : operations.entrySet()) {
            Object object = operation.getValue();
            if (object instanceof JSONArray) {
                JSONArray overloaded = (JSONArray)object;
                for (Object operationItem : overloaded) {
                    if (operationItem instanceof JSONObject) {
                        JSONObject item = (JSONObject)operationItem;
                        result.add(this.operationFrom((String)operation.getKey(), item));
                        continue;
                    }
                    throw new IllegalArgumentException("Representation of overloaded operation \"" + (String)operation.getKey() + "\" is invalid: " + String.valueOf(operationItem));
                }
                continue;
            }
            object = operation.getValue();
            if (object instanceof JSONObject) {
                JSONObject op = (JSONObject)object;
                result.add(this.operationFrom((String)operation.getKey(), op));
                continue;
            }
            throw new IllegalArgumentException("Representation of operation \"" + (String)operation.getKey() + "\" is invalid: " + String.valueOf(operation.getValue()));
        }
        return result.toArray(new MBeanOperationInfo[0]);
    }

    private MBeanOperationInfo operationFrom(String name, JSONObject json) {
        String typeV;
        String descV;
        Object object = json.get((Object)"desc");
        String desc = object instanceof String ? (descV = (String)object) : "";
        Object object2 = json.get((Object)"ret");
        String type = object2 instanceof String ? (typeV = (String)object2) : "<unknown>";
        Object parametersV = json.get((Object)"args");
        if (!(parametersV instanceof JSONArray)) {
            throw new IllegalStateException("Parameters from operation " + name + " are invalid: " + String.valueOf(parametersV));
        }
        JSONArray pJson = (JSONArray)parametersV;
        MBeanParameterInfo[] parameters = this.parametersFrom(name, pJson);
        return new MBeanOperationInfo(name, desc, parameters, type, 3);
    }

    private MBeanParameterInfo[] parametersFrom(String operation, JSONArray args) {
        MBeanParameterInfo[] result = new MBeanParameterInfo[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            Object object = args.get(i);
            if (!(object instanceof JSONObject)) {
                throw new IllegalStateException("Parameter " + i + " from operation " + operation + " is invalid: " + String.valueOf(args.get(i)));
            }
            JSONObject arg = (JSONObject)object;
            result[i] = this.parameterFrom(i, arg);
        }
        return result;
    }

    private MBeanParameterInfo parameterFrom(int pn, JSONObject parameter) {
        Object object;
        String typeV;
        Object object2;
        Object object3 = parameter.get((Object)"name");
        if (object3 instanceof String) {
            String nameV = (String)object3;
            object2 = nameV;
        } else {
            object2 = "p" + pn;
        }
        String name = object2;
        Object object4 = parameter.get((Object)"type");
        String type = object4 instanceof String ? (typeV = (String)object4) : "<unknown>";
        Object object5 = parameter.get((Object)"desc");
        if (object5 instanceof String) {
            String descV = (String)object5;
            object = descV;
        } else {
            object = "p" + pn;
        }
        String desc = object;
        return new MBeanParameterInfo(name, type, desc);
    }

    private MBeanConstructorInfo[] constructorsFrom(JSONObject constructors) {
        if (constructors == null || constructors.isEmpty()) {
            return new MBeanConstructorInfo[0];
        }
        ArrayList<MBeanConstructorInfo> result = new ArrayList<MBeanConstructorInfo>(constructors.size());
        for (Map.Entry constructor : constructors.entrySet()) {
            Object object = constructor.getValue();
            if (object instanceof JSONArray) {
                JSONArray overloaded = (JSONArray)object;
                for (Object constructorItem : overloaded) {
                    if (constructorItem instanceof JSONObject) {
                        JSONObject item = (JSONObject)constructorItem;
                        result.add(this.constructorFrom((String)constructor.getKey(), item));
                        continue;
                    }
                    throw new IllegalArgumentException("Representation of overloaded constructor \"" + (String)constructor.getKey() + "\" is invalid: " + String.valueOf(constructorItem));
                }
                continue;
            }
            object = constructor.getValue();
            if (object instanceof JSONObject) {
                JSONObject op = (JSONObject)object;
                result.add(this.constructorFrom((String)constructor.getKey(), op));
                continue;
            }
            throw new IllegalArgumentException("Representation of constructor \"" + (String)constructor.getKey() + "\" is invalid: " + String.valueOf(constructor.getValue()));
        }
        return result.toArray(new MBeanConstructorInfo[0]);
    }

    private MBeanConstructorInfo constructorFrom(String name, JSONObject json) {
        String descV;
        Object object = json.get((Object)"desc");
        String desc = object instanceof String ? (descV = (String)object) : "";
        Object parametersV = json.get((Object)"args");
        if (!(parametersV instanceof JSONArray)) {
            throw new IllegalStateException("Parameters from constructor " + name + " are invalid: " + String.valueOf(parametersV));
        }
        JSONArray pJson = (JSONArray)parametersV;
        MBeanParameterInfo[] parameters = this.parametersFrom(name, pJson);
        return new MBeanConstructorInfo(name, desc, parameters);
    }

    private MBeanNotificationInfo[] notificationsFrom(JSONObject notifications) {
        if (notifications == null || notifications.isEmpty()) {
            return new MBeanNotificationInfo[0];
        }
        ArrayList<MBeanNotificationInfo> result = new ArrayList<MBeanNotificationInfo>(notifications.size());
        for (Map.Entry notification : notifications.entrySet()) {
            if (!(notification.getValue() instanceof JSONObject)) {
                throw new IllegalArgumentException("Representation of notification \"" + (String)notification.getKey() + "\" is invalid: " + String.valueOf(notification.getValue()));
            }
            result.add(this.notificationFrom((String)notification.getKey(), (JSONObject)notification.getValue()));
        }
        return (MBeanNotificationInfo[])result.toArray(MBeanNotificationInfo[]::new);
    }

    private MBeanNotificationInfo notificationFrom(String name, JSONObject json) {
        String[] types;
        String descV;
        Object object = json.get((Object)"desc");
        String desc = object instanceof String ? (descV = (String)object) : "";
        Object typesV = json.get((Object)"types");
        if (typesV instanceof JSONArray) {
            JSONArray typesArray = (JSONArray)typesV;
            types = new String[typesArray.size()];
            int idx = 0;
            for (Object t : typesArray) {
                types[idx++] = t instanceof String ? (String)t : "<unknown>";
            }
        } else {
            throw new IllegalArgumentException("Representation of types from notification \"" + name + "\" is invalid: " + String.valueOf(typesV));
        }
        return new MBeanNotificationInfo(types, name, desc);
    }
}

