/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.jdkclient;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jolokia.client.EscapeUtil;
import org.jolokia.client.HttpUtil;
import org.jolokia.client.JolokiaClientBuilder;
import org.jolokia.client.JolokiaQueryParameter;
import org.jolokia.client.JolokiaTargetConfig;
import org.jolokia.client.exception.JolokiaConnectException;
import org.jolokia.client.exception.JolokiaException;
import org.jolokia.client.exception.JolokiaRemoteException;
import org.jolokia.client.exception.JolokiaTimeoutException;
import org.jolokia.client.request.HttpMethod;
import org.jolokia.client.request.JolokiaRequest;
import org.jolokia.client.response.JolokiaResponse;
import org.jolokia.client.spi.HttpClientSpi;
import org.jolokia.client.spi.HttpHeader;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;
import org.jolokia.json.JSONStructure;
import org.jolokia.json.parser.ParseException;

public class JdkHttpClient
implements HttpClientSpi<HttpClient> {
    private final HttpClient client;
    private final JolokiaClientBuilder.Configuration config;
    private final URI jolokiaAgentUrl;

    public JdkHttpClient(HttpClient client, JolokiaClientBuilder.Configuration configuration) {
        this.client = client;
        this.config = configuration;
        this.jolokiaAgentUrl = this.config.url();
    }

    @Override
    public HttpClient getClient(Class<HttpClient> clientClass) {
        if (clientClass.isAssignableFrom(this.client.getClass())) {
            return clientClass.cast(this.client);
        }
        return null;
    }

    @Override
    public <REQ extends JolokiaRequest, RES extends JolokiaResponse<REQ>> JSONStructure execute(REQ pRequest, HttpMethod method, Map<JolokiaQueryParameter, String> parameters, JolokiaTargetConfig targetConfig) throws IOException, JolokiaException {
        HttpRequest httpRequest = this.prepareRequest(pRequest, method, parameters, targetConfig);
        return this.execute(httpRequest, pRequest, pRequest.getType().getValue());
    }

    @Override
    public <REQ extends JolokiaRequest, RES extends JolokiaResponse<REQ>> JSONStructure execute(List<REQ> pRequests, Map<JolokiaQueryParameter, String> parameters, JolokiaTargetConfig targetConfig) throws IOException, JolokiaException {
        HttpRequest httpRequest = this.prepareRequests(pRequests, parameters, targetConfig);
        return this.execute(httpRequest, null, "bulk");
    }

    @Override
    public void close() {
    }

    private <REQ extends JolokiaRequest> HttpRequest prepareRequest(REQ pRequest, HttpMethod method, Map<JolokiaQueryParameter, String> parameters, JolokiaTargetConfig pTargetConfig) {
        JolokiaTargetConfig targetConfig = HttpUtil.determineTargetConfig(pRequest, pTargetConfig);
        HttpMethod selectedMethod = HttpUtil.determineHttpMethod(pRequest, method, targetConfig);
        String queryParams = HttpUtil.toQueryString(parameters);
        Charset charset = this.config.contentCharset() == null ? StandardCharsets.UTF_8 : this.config.contentCharset();
        HttpRequest.Builder builder = null;
        if (selectedMethod.equals((Object)HttpMethod.GET)) {
            if (targetConfig != null) {
                throw new IllegalArgumentException("Proxy requests should be sent using POST method");
            }
            List<String> parts = pRequest.getRequestParts();
            if (parts != null) {
                String base = HttpUtil.prepareBaseUrl(this.jolokiaAgentUrl);
                StringBuilder requestPath = new StringBuilder(base);
                requestPath.append(pRequest.getType().getValue());
                for (String p : parts) {
                    requestPath.append("/");
                    requestPath.append(EscapeUtil.escape(p));
                }
                URI uri = HttpUtil.prepareFullUrl(this.jolokiaAgentUrl, requestPath.toString(), queryParams);
                builder = HttpRequest.newBuilder().uri(uri).GET();
            }
        }
        if (builder == null) {
            JSONObject requestContent = HttpUtil.getJsonRequestContent(pRequest, targetConfig);
            HttpRequest.BodyPublisher publisher = HttpRequest.BodyPublishers.ofString(requestContent.toJSONString(), charset);
            builder = HttpRequest.newBuilder().uri(HttpUtil.prepareFullUrl(this.jolokiaAgentUrl, this.jolokiaAgentUrl.getPath(), queryParams)).header("Content-Type", "application/json").POST(publisher);
            builder.expectContinue(this.config.expectContinue());
        }
        return this.configureRequest(builder);
    }

    private <REQ extends JolokiaRequest> HttpRequest prepareRequests(List<REQ> pRequests, Map<JolokiaQueryParameter, String> parameters, JolokiaTargetConfig pTargetConfig) {
        String queryParams = HttpUtil.toQueryString(parameters);
        Charset charset = this.config.contentCharset() == null ? StandardCharsets.UTF_8 : this.config.contentCharset();
        JSONArray bulkRequest = new JSONArray(pRequests.size());
        for (JolokiaRequest request : pRequests) {
            JSONObject requestContent = HttpUtil.getJsonRequestContent(request, HttpUtil.determineTargetConfig(request, pTargetConfig));
            bulkRequest.add((Object)requestContent);
        }
        HttpRequest.BodyPublisher publisher = HttpRequest.BodyPublishers.ofString(bulkRequest.toJSONString(), charset);
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(HttpUtil.prepareFullUrl(this.jolokiaAgentUrl, this.jolokiaAgentUrl.getPath(), queryParams)).header("Content-Type", "application/json").POST(publisher);
        builder.expectContinue(this.config.expectContinue());
        return this.configureRequest(builder);
    }

    private HttpRequest configureRequest(HttpRequest.Builder builder) {
        Collection<HttpHeader> customHeaders;
        if (this.config.connectionConfig().socketTimeout() > 0) {
            builder.timeout(Duration.ofMillis(this.config.connectionConfig().socketTimeout()));
        }
        if (this.config.user() != null && !this.config.user().isEmpty()) {
            String credentials = this.config.user() + ":" + (this.config.password() == null ? "" : this.config.password());
            String encoded = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
            builder.header("Authorization", "Basic " + encoded);
        }
        if ((customHeaders = this.config.defaultHttpHeaders()) != null) {
            for (HttpHeader h : customHeaders) {
                builder.setHeader(h.name(), h.value());
            }
        }
        return builder.header("Content-Type", "application/json").build();
    }

    private JSONStructure execute(HttpRequest httpRequest, JolokiaRequest jolokiaRequest, String requestType) throws IOException, JolokiaException {
        JSONStructure jSONStructure;
        block16: {
            HttpResponse.BodyHandler<InputStream> responseHandler = HttpResponse.BodyHandlers.ofInputStream();
            HttpResponse<InputStream> response = this.client.send(httpRequest, responseHandler);
            int errorCode = response.statusCode();
            InputStream body = response.body();
            try {
                if (errorCode != 200) {
                    throw new JolokiaRemoteException(jolokiaRequest, "HTTP error " + errorCode + " sending " + requestType + " Jolokia request", null, errorCode, null, null);
                }
                Optional<String> encoding = response.headers().firstValue("Content-Encoding");
                if (encoding.isEmpty()) {
                    encoding = Optional.of((this.config.contentCharset() == null ? StandardCharsets.ISO_8859_1 : this.config.contentCharset()).name());
                }
                jSONStructure = HttpUtil.parseJsonResponse(body, Charset.forName(encoding.get()));
                if (body == null) break block16;
            }
            catch (Throwable encoding) {
                try {
                    try {
                        if (body != null) {
                            try {
                                body.close();
                            }
                            catch (Throwable throwable) {
                                encoding.addSuppressed(throwable);
                            }
                        }
                        throw encoding;
                    }
                    catch (ParseException e) {
                        String errorType = ((Object)((Object)e)).getClass().getName();
                        String message = "Error parsing " + requestType + " response: " + e.getMessage();
                        throw new JolokiaRemoteException(jolokiaRequest, message, errorType, errorCode, null, null);
                    }
                }
                catch (ConnectException e) {
                    String msg = "Cannot connect to " + String.valueOf(this.jolokiaAgentUrl) + ": " + e.getMessage();
                    throw new JolokiaConnectException(msg, e);
                }
                catch (HttpConnectTimeoutException e) {
                    String msg = "Connection timeout when sending " + requestType + " request to " + String.valueOf(this.jolokiaAgentUrl) + ": " + e.getMessage();
                    throw new JolokiaTimeoutException(msg, e);
                }
                catch (HttpTimeoutException e) {
                    String msg = "Timeout when processing " + requestType + " request to " + String.valueOf(this.jolokiaAgentUrl) + ": " + e.getMessage();
                    throw new JolokiaTimeoutException(msg, e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new JolokiaException("Interrupted while sending " + requestType + " Jolokia request", e);
                }
            }
            body.close();
        }
        return jSONStructure;
    }
}

