/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import java.io.File;
import java.io.IOException;
import jodd.io.FileUtil;
import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;

public class FileConverter
implements TypeConverter<File> {
    @Override
    public File convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof File) {
            return (File)value;
        }
        Class<?> type = value.getClass();
        if (type == byte[].class) {
            try {
                File tempFile = FileUtil.createTempFile();
                FileUtil.writeBytes(tempFile, (byte[])value);
                return tempFile;
            }
            catch (IOException ioex) {
                throw new TypeConversionException(ioex);
            }
        }
        if (type == String.class) {
            try {
                File tempFile = FileUtil.createTempFile();
                FileUtil.writeString(tempFile, value.toString());
                return tempFile;
            }
            catch (IOException ioex) {
                throw new TypeConversionException(ioex);
            }
        }
        throw new TypeConversionException(value);
    }
}

