/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.servlet.ServletUtil;
import jodd.servlet.filter.GzipResponseWrapper;
import jodd.typeconverter.Convert;
import jodd.typeconverter.TypeConversionException;
import jodd.util.StringUtil;
import jodd.util.Wildcard;

public class GzipFilter
implements Filter {
    protected int threshold;
    protected String[] matches;
    protected String[] excludes;
    protected boolean wildcards;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (this.threshold == 0 || !ServletUtil.isGzipSupported(req) || !this.isGzipEligible(req)) {
            chain.doFilter(request, response);
            return;
        }
        GzipResponseWrapper wrappedResponse = new GzipResponseWrapper(res);
        wrappedResponse.setCompressionThreshold(this.threshold);
        try {
            chain.doFilter(request, (ServletResponse)wrappedResponse);
        }
        finally {
            wrappedResponse.finishResponse();
        }
    }

    public void init(FilterConfig config) throws ServletException {
        String uriExclude;
        try {
            this.wildcards = Convert.toBooleanValue((Object)config.getInitParameter("wildcards"), (boolean)false);
        }
        catch (TypeConversionException ignore) {
            this.wildcards = false;
        }
        try {
            this.threshold = Convert.toIntValue((Object)config.getInitParameter("threshold"), (int)0);
        }
        catch (TypeConversionException ignore) {
            this.threshold = 0;
        }
        String uriMatch = config.getInitParameter("match");
        if (uriMatch != null && !uriMatch.equals("*")) {
            this.matches = StringUtil.splitc((String)uriMatch, (char)',');
            for (int i = 0; i < this.matches.length; ++i) {
                this.matches[i] = this.matches[i].trim();
            }
        }
        if ((uriExclude = config.getInitParameter("exclude")) != null) {
            this.excludes = StringUtil.splitc((String)uriExclude, (char)',');
            for (int i = 0; i < this.excludes.length; ++i) {
                this.excludes[i] = this.excludes[i].trim();
            }
        }
    }

    public void destroy() {
        this.matches = null;
        this.excludes = null;
    }

    private boolean isGzipEligible(HttpServletRequest req) {
        boolean result;
        block7: {
            String uri;
            block8: {
                uri = req.getRequestURI();
                if (uri == null) {
                    return false;
                }
                result = false;
                if (this.matches == null) {
                    result = true;
                } else if (this.wildcards) {
                    result = Wildcard.matchPathOne((String)uri, (String[])this.matches) != -1;
                } else {
                    for (String match : this.matches) {
                        if (!uri.contains(match)) continue;
                        result = true;
                        break;
                    }
                }
                if (!result || this.excludes == null) break block7;
                if (!this.wildcards) break block8;
                if (Wildcard.matchPathOne((String)uri, (String[])this.excludes) == -1) break block7;
                result = false;
                break block7;
            }
            for (String exclude : this.excludes) {
                if (!uri.contains(exclude)) continue;
                result = false;
                break;
            }
        }
        return result;
    }
}

