/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;
import jodd.util.JulianDate;
import jodd.util.StringUtil;
import jodd.util.TimeUtil;

public class SqlTimestampConverter
implements TypeConverter<Timestamp> {
    @Override
    public Timestamp convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return new Timestamp(calendar.getTimeInMillis());
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return new Timestamp(date.getTime());
        }
        if (value instanceof JulianDate) {
            return new Timestamp(((JulianDate)value).toMilliseconds());
        }
        if (value instanceof LocalDateTime) {
            return new Timestamp(TimeUtil.toMilliseconds((LocalDateTime)((LocalDateTime)value)));
        }
        if (value instanceof Number) {
            return new Timestamp(((Number)value).longValue());
        }
        String stringValue = value.toString().trim();
        if (!StringUtil.containsOnlyDigits((CharSequence)stringValue)) {
            try {
                return Timestamp.valueOf(stringValue);
            }
            catch (IllegalArgumentException iaex) {
                throw new TypeConversionException(value, (Throwable)iaex);
            }
        }
        try {
            long milliseconds = Long.parseLong(stringValue);
            return new Timestamp(milliseconds);
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

