/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.gltf;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jme3.asset.AssetLoadException;
import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.plugins.gltf.ExtensionLoader;
import com.jme3.scene.plugins.gltf.GltfLoader;
import com.jme3.scene.plugins.gltf.GltfUtils;
import com.jme3.texture.Texture2D;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TextureTransformExtensionLoader
implements ExtensionLoader {
    private static final Logger logger = Logger.getLogger(TextureTransformExtensionLoader.class.getName());

    private void uvTransform(Mesh mesh, Matrix3f transform, VertexBuffer.Type verType) {
        if (!transform.isIdentity()) {
            VertexBuffer tc = mesh.getBuffer(verType);
            if (tc == null) {
                throw new IllegalStateException("The mesh has no texture coordinates");
            }
            if (tc.getFormat() != VertexBuffer.Format.Float) {
                throw new UnsupportedOperationException("Only float texture coord format is supported");
            }
            if (tc.getNumComponents() != 2) {
                throw new UnsupportedOperationException("Only 2D texture coords are supported");
            }
            FloatBuffer fb = (FloatBuffer)tc.getData();
            fb.clear();
            for (int i = 0; i < fb.limit() / 2; ++i) {
                float x = fb.get();
                float y = fb.get();
                fb.position(fb.position() - 2);
                Vector3f v = transform.mult(new Vector3f(x, y, 1.0f));
                fb.put(v.getX()).put(v.getY());
            }
            fb.clear();
            tc.updateData((Buffer)fb);
        }
    }

    @Override
    public Object handleExtension(GltfLoader loader, String parentName, JsonElement parent, JsonElement extension, Object input) throws IOException {
        Mesh mesh;
        if (!(input instanceof Texture2D)) {
            logger.log(Level.WARNING, "KHR_texture_transform extension added on an unsupported element, the loaded scene result will be unexpected.");
        }
        if ((mesh = loader.fetchFromCache("mesh", 0, Mesh.class)) != null) {
            JsonArray jsonArray;
            Matrix3f translation = new Matrix3f();
            Matrix3f rotation = new Matrix3f();
            Matrix3f scale = new Matrix3f();
            Integer texCoord = GltfUtils.getAsInteger(parent.getAsJsonObject(), "texCoord");
            texCoord = texCoord != null ? texCoord : 0;
            JsonObject jsonObject = extension.getAsJsonObject();
            if (jsonObject.has("offset")) {
                jsonArray = jsonObject.getAsJsonArray("offset");
                translation.set(0, 2, jsonArray.get(0).getAsFloat());
                translation.set(1, 2, jsonArray.get(1).getAsFloat());
            }
            if (jsonObject.has("rotation")) {
                float rad = jsonObject.get("rotation").getAsFloat();
                rotation.set(0, 0, (float)Math.cos(rad));
                rotation.set(0, 1, (float)Math.sin(rad));
                rotation.set(1, 0, (float)(-Math.sin(rad)));
                rotation.set(1, 1, (float)Math.cos(rad));
            }
            if (jsonObject.has("scale")) {
                jsonArray = jsonObject.getAsJsonArray("scale");
                scale.set(0, 0, jsonArray.get(0).getAsFloat());
                scale.set(1, 1, jsonArray.get(1).getAsFloat());
            }
            if (jsonObject.has("texCoord")) {
                texCoord = jsonObject.get("texCoord").getAsInt();
            }
            Matrix3f transform = translation.mult(rotation).mult(scale);
            Mesh meshLast = loader.fetchFromCache("textureTransformData", 0, Mesh.class);
            HashMap<Integer, Matrix3f> transformMap = loader.fetchFromCache("textureTransformData", 1, HashMap.class);
            if (mesh != meshLast || transformMap != null && transformMap.get(texCoord) == null) {
                if (mesh != meshLast) {
                    loader.addToCache("textureTransformData", 0, mesh, 2);
                    if (transformMap == null) {
                        transformMap = new HashMap<Integer, Matrix3f>();
                        loader.addToCache("textureTransformData", 1, transformMap, 2);
                    } else {
                        transformMap.clear();
                    }
                }
                transformMap.put(texCoord, transform);
                this.uvTransform(mesh, transform, GltfUtils.getVertexBufferType("TEXCOORD_" + texCoord));
                logger.log(Level.FINE, "KHR_texture_transform extension successfully applied.");
            } else {
                Matrix3f transformLast = (Matrix3f)transformMap.get(texCoord);
                if (!transform.equals((Object)transformLast)) {
                    logger.log(Level.WARNING, "KHR_texture_transform extension: use of different texture transforms for the same mesh's UVs is not supported, the loaded scene result will be unexpected.");
                }
            }
            return input;
        }
        throw new AssetLoadException("KHR_texture_transform extension applied to a null mesh.");
    }
}

