/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.export.xml;

import com.jme3.export.JmeExporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.export.xml.DOMOutputCapsule;
import com.jme3.export.xml.DOMSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

public class XMLExporter
implements JmeExporter {
    public static final String ELEMENT_MAPENTRY = "MapEntry";
    public static final String ELEMENT_KEY = "Key";
    public static final String ELEMENT_VALUE = "Value";
    public static final String ELEMENT_FLOATBUFFER = "FloatBuffer";
    public static final String ATTRIBUTE_SIZE = "size";
    private DOMOutputCapsule domOut;

    public void save(Savable object, OutputStream f) throws IOException {
        try {
            this.domOut = new DOMOutputCapsule(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument(), this);
            this.domOut.write(object, object.getClass().getName(), null);
            DOMSerializer serializer = new DOMSerializer();
            serializer.serialize(this.domOut.getDoc(), f);
            f.flush();
        }
        catch (ParserConfigurationException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Savable object, File f) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(f);){
            this.save(object, fos);
        }
    }

    public OutputCapsule getCapsule(Savable object) {
        return this.domOut;
    }

    public static XMLExporter getInstance() {
        return new XMLExporter();
    }
}

