/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import javax.annotation.Nonnull;

public final class StackTrace {
    @Nonnull
    private final Throwable throwable;
    @Nonnull
    private final StackTraceElement[] elements;

    public StackTrace() {
        this(new Throwable());
    }

    public StackTrace(@Nonnull Throwable throwable) {
        this.throwable = throwable;
        this.elements = throwable.getStackTrace();
    }

    public int getDepth() {
        return this.elements.length;
    }

    @Nonnull
    public StackTraceElement getElement(int index) {
        return this.elements[index];
    }

    public static void filterStackTrace(@Nonnull Throwable t) {
        new StackTrace(t).filter();
    }

    public void filter() {
        StackTraceElement[] filteredST = new StackTraceElement[this.elements.length];
        int i = 0;
        for (StackTraceElement ste : this.elements) {
            if (ste.getFileName() == null) continue;
            String where = ste.getClassName();
            if (StackTrace.isSunMethod(ste) || StackTrace.isTestFrameworkMethod(where) || StackTrace.isJMockitMethod(where)) continue;
            filteredST[i] = ste;
            ++i;
        }
        StackTraceElement[] newStackTrace = new StackTraceElement[i];
        System.arraycopy(filteredST, 0, newStackTrace, 0, i);
        this.throwable.setStackTrace(newStackTrace);
        Throwable cause = this.throwable.getCause();
        if (cause != null) {
            new StackTrace(cause).filter();
        }
    }

    private static boolean isSunMethod(@Nonnull StackTraceElement ste) {
        return ste.getClassName().startsWith("sun.") && !ste.isNativeMethod();
    }

    private static boolean isTestFrameworkMethod(@Nonnull String where) {
        return where.startsWith("org.junit.") || where.startsWith("org.testng.");
    }

    private static boolean isJMockitMethod(@Nonnull String where) {
        if (!where.startsWith("mockit.")) {
            return false;
        }
        int p = where.indexOf(36);
        if (p < 0) {
            int q = where.lastIndexOf("Test");
            return q < 0 || q + 4 < where.length();
        }
        int q = where.lastIndexOf("Test", p - 4);
        if (q < 0) {
            return true;
        }
        return (q += 4) < where.length() && where.charAt(q) != '$';
    }
}

