/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.MockUp;
import mockit.internal.mockups.MockStates;
import mockit.internal.state.MockClasses;
import mockit.internal.util.ClassLoad;
import mockit.internal.util.FieldReflection;

public final class MockClasses {
    private static final Field INVOKED_INSTANCE_FIELD = FieldReflection.getDeclaredField(MockUp.class, "invokedInstance", true);
    @Nonnull
    private final Map<String, MockUp<?>> startupMocks = new IdentityHashMap(8);
    @Nonnull
    private final Map<Class<?>, MockUpInstances> mockupClassesToMockupInstances = new IdentityHashMap();
    @Nonnull
    private final Map<Object, MockUp<?>> mockedToMockupInstances = new IdentityHashMap();
    @Nonnull
    public final MockStates mockStates = new MockStates();

    MockClasses() {
    }

    public void addMock(@Nonnull String mockClassDesc, @Nonnull MockUp<?> mockUp) {
        this.startupMocks.put(mockClassDesc, mockUp);
    }

    public void addMock(@Nonnull MockUp<?> mockUp) {
        Class<?> mockUpClass = mockUp.getClass();
        MockUpInstances newData = new MockUpInstances(mockUp);
        MockUpInstances previousData = this.mockupClassesToMockupInstances.put(mockUpClass, newData);
        assert (previousData == null);
    }

    public void addMock(@Nonnull MockUp<?> mockUp, @Nonnull Object mockedInstance) {
        MockUp<?> previousMockup = this.mockedToMockupInstances.put(mockedInstance, mockUp);
        assert (previousMockup == null);
        MockUpInstances mockUpInstances = this.mockupClassesToMockupInstances.get(mockUp.getClass());
        ++mockUpInstances.numberOfMockupsForSingleInstance;
    }

    @Nullable
    MockUp<?> getMock(@Nonnull String mockUpClassDesc, @Nullable Object mockedInstance) {
        MockUp<?> mockUpForSingleInstance;
        if (mockedInstance != null && (mockUpForSingleInstance = this.mockedToMockupInstances.get(mockedInstance)) != null) {
            return mockUpForSingleInstance;
        }
        MockUp<?> startupMock = this.startupMocks.get(mockUpClassDesc);
        if (startupMock != null) {
            return startupMock;
        }
        Class mockUpClass = ClassLoad.loadByInternalName(mockUpClassDesc);
        MockUpInstances mockUpInstances = this.mockupClassesToMockupInstances.get(mockUpClass);
        Class<Void> invokedInstance = mockedInstance;
        if (mockedInstance == null) {
            invokedInstance = Void.class;
        } else if (mockUpInstances.hasMockUpsForSingleInstances()) {
            return null;
        }
        try {
            INVOKED_INSTANCE_FIELD.set(mockUpInstances.initialMockUp, invokedInstance);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return mockUpInstances.initialMockUp;
    }

    @Nullable
    public MockUpInstances findPreviouslyAppliedMockUps(@Nonnull MockUp<?> newMockUp) {
        Class<?> mockUpClass = newMockUp.getClass();
        MockUpInstances mockUpInstances = this.mockupClassesToMockupInstances.get(mockUpClass);
        if (mockUpInstances != null && mockUpInstances.hasMockUpsForSingleInstances()) {
            this.mockStates.copyMockStates(mockUpInstances.initialMockUp, newMockUp);
        }
        return mockUpInstances;
    }

    @Nonnull
    public MockUpInstances removeMock(@Nonnull MockUp<?> mockUp, @Nullable Object mockedInstance) {
        int decrementedNumberOfMockupsForSingleInstance;
        Class<?> mockUpClass = mockUp.getClass();
        if (mockedInstance == null) {
            MockUpInstances mockUpInstances = this.mockupClassesToMockupInstances.remove(mockUpClass);
            assert (!mockUpInstances.hasMockUpsForSingleInstances());
            return mockUpInstances;
        }
        MockUp<?> previousMockUpForMockedInstance = this.mockedToMockupInstances.remove(mockedInstance);
        assert (previousMockUpForMockedInstance == mockUp);
        MockUpInstances mockUpInstances = this.mockupClassesToMockupInstances.get(mockUpClass);
        if ((decrementedNumberOfMockupsForSingleInstance = --mockUpInstances.numberOfMockupsForSingleInstance) == 0) {
            this.mockupClassesToMockupInstances.remove(mockUpClass);
        }
        return mockUpInstances;
    }

    static /* synthetic */ Map access$000(MockClasses x0) {
        return x0.mockedToMockupInstances;
    }

    static /* synthetic */ Map access$100(MockClasses x0) {
        return x0.mockupClassesToMockupInstances;
    }

    static {
        INVOKED_INSTANCE_FIELD.setAccessible(true);
    }
}

