/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.external.asm.Type;
import mockit.internal.state.MockedTypeCascade;
import mockit.internal.util.Utilities;

public final class CascadingTypes {
    @Nonnull
    private final Map<String, MockedTypeCascade> cascadingTypes = new ConcurrentHashMap<String, MockedTypeCascade>(4);

    CascadingTypes() {
    }

    public void add(boolean fromMockField, @Nonnull java.lang.reflect.Type mockedType, @Nullable Object cascadedInstance) {
        Class mockedClass = Utilities.getClassType((java.lang.reflect.Type)mockedType);
        String mockedTypeDesc = Type.getInternalName(mockedClass);
        this.add(mockedTypeDesc, fromMockField, mockedType, cascadedInstance);
    }

    void add(@Nonnull String mockedTypeDesc, boolean fromMockField, @Nonnull java.lang.reflect.Type mockedType, @Nullable Object cascadedInstance) {
        if (!this.cascadingTypes.containsKey(mockedTypeDesc)) {
            this.cascadingTypes.put(mockedTypeDesc, new MockedTypeCascade(fromMockField, mockedType, cascadedInstance));
        }
    }

    @Nullable
    public MockedTypeCascade getCascade(@Nonnull String mockedTypeDesc, @Nullable Object mockInstance) {
        if (this.cascadingTypes.isEmpty()) {
            return null;
        }
        MockedTypeCascade cascade = this.getCascade(mockedTypeDesc);
        if (cascade != null || mockInstance == null) {
            return cascade;
        }
        return this.getCascade(mockedTypeDesc, mockInstance.getClass());
    }

    @Nullable
    private MockedTypeCascade getCascade(@Nonnull String mockedTypeDesc) {
        MockedTypeCascade cascade = this.cascadingTypes.get(mockedTypeDesc);
        if (cascade != null) {
            return cascade;
        }
        for (Map.Entry<String, MockedTypeCascade> cascadeEntry : this.cascadingTypes.entrySet()) {
            String cascadingTypeDesc = cascadeEntry.getKey();
            int p = cascadingTypeDesc.indexOf(60);
            if (p <= 0 || !cascadingTypeDesc.regionMatches(0, mockedTypeDesc, 0, p - 1)) continue;
            return cascadeEntry.getValue();
        }
        return null;
    }

    @Nullable
    private MockedTypeCascade getCascade(@Nonnull String invokedTypeDesc, @Nonnull Class<?> mockedClass) {
        Class<?> typeToLookFor = mockedClass;
        do {
            String typeDesc;
            if (invokedTypeDesc.equals(typeDesc = Type.getInternalName(typeToLookFor))) {
                return null;
            }
            MockedTypeCascade cascade = this.cascadingTypes.get(typeDesc);
            if (cascade == null) continue;
            cascade.mockedClass = mockedClass;
            return cascade;
        } while ((typeToLookFor = typeToLookFor.getSuperclass()) != Object.class);
        return null;
    }

    void clearNonSharedCascadingTypes() {
        if (!this.cascadingTypes.isEmpty()) {
            Iterator<MockedTypeCascade> itr = this.cascadingTypes.values().iterator();
            while (itr.hasNext()) {
                MockedTypeCascade cascade = itr.next();
                if (cascade.fromMockField) {
                    cascade.discardCascadedMocks();
                    continue;
                }
                itr.remove();
            }
        }
    }

    public void clear() {
        this.cascadingTypes.clear();
    }
}

