/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.pathCoverage;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.CoveragePercentage;
import mockit.coverage.paths.MethodCoverageData;
import mockit.coverage.paths.Path;
import mockit.coverage.reporting.pathCoverage.PathCoverageFormatter;

public final class PathCoverageOutput {
    @Nonnull
    private final PrintWriter output;
    @Nonnull
    private final PathCoverageFormatter pathFormatter;
    @Nonnull
    private final Iterator<MethodCoverageData> nextMethod;
    @Nullable
    private MethodCoverageData currentMethod;

    public PathCoverageOutput(@Nonnull PrintWriter output, @Nonnull Collection<MethodCoverageData> methods) {
        this.output = output;
        this.pathFormatter = new PathCoverageFormatter(output);
        this.nextMethod = methods.iterator();
        this.moveToNextMethod();
    }

    private void moveToNextMethod() {
        this.currentMethod = this.nextMethod.hasNext() ? this.nextMethod.next() : null;
    }

    public void writePathCoverageInfoIfLineStartsANewMethodOrConstructor(int lineNumber) {
        if (this.currentMethod != null && lineNumber == this.currentMethod.getFirstLineInBody()) {
            this.writePathCoverageInformationForMethod(this.currentMethod);
            this.moveToNextMethod();
        }
    }

    private void writePathCoverageInformationForMethod(@Nonnull MethodCoverageData methodData) {
        List<Path> paths = methodData.getPaths();
        if (paths.size() > 1) {
            this.writeHeaderForAllPaths(methodData);
            this.pathFormatter.writeInformationForEachPath(paths);
            this.writeFooterForAllPaths();
        }
    }

    private void writeHeaderForAllPaths(@Nonnull MethodCoverageData methodData) {
        int coveredPaths = methodData.getCoveredPaths();
        int totalPaths = methodData.getTotalPaths();
        this.output.println("    <tr>");
        this.output.write("      <td></td><td class='count'>");
        this.output.print(methodData.getExecutionCount());
        this.output.println("</td>");
        this.output.println("      <td class='paths'>");
        this.output.write("        <span style='cursor:default; background-color:#");
        this.output.write(CoveragePercentage.percentageColor(coveredPaths, totalPaths));
        this.output.write("' onclick='hidePath()'>Path coverage: ");
        this.output.print(coveredPaths);
        this.output.print('/');
        this.output.print(totalPaths);
        this.output.println("</span>");
    }

    private void writeFooterForAllPaths() {
        this.output.println("      </td>");
        this.output.println("    </tr>");
    }
}

