/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

final class SourceFiles {
    @Nonnull
    private final List<File> srcDirs = new ArrayList<File>();

    SourceFiles() {
    }

    @Nonnull
    List<File> buildListOfSourceDirectories(@Nonnull String[] sourceDirs) {
        if (sourceDirs.length > 0) {
            this.buildListWithSpecifiedDirectories(sourceDirs);
        } else {
            this.buildListWithAllSrcSubDirectories();
        }
        return this.srcDirs;
    }

    private void buildListWithSpecifiedDirectories(@Nonnull String[] dirs) {
        for (String dir : dirs) {
            File srcDir = new File(dir);
            if (!srcDir.isDirectory()) continue;
            this.srcDirs.add(srcDir);
        }
        if (this.srcDirs.isEmpty()) {
            throw new IllegalStateException("None of the specified source directories exist");
        }
    }

    private void buildListWithAllSrcSubDirectories() {
        String curDirName = new File(System.getProperty("user.dir")).getName();
        this.addSrcSubDirs(new File("../" + curDirName));
    }

    private void addSrcSubDirs(@Nonnull File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File subDir : files) {
            String subDirName;
            if (!subDir.isDirectory() || "test generated-sources".contains(subDirName = subDir.getName())) continue;
            if ("src".equals(subDirName)) {
                this.srcDirs.add(subDir);
                continue;
            }
            this.addSrcSubDirs(subDir);
        }
    }
}

