/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.modification;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.modification.ClassSelection;
import mockit.coverage.modification.CoverageModifier;
import mockit.coverage.modification.VisitInterruptedException;
import mockit.coverage.standalone.Startup;
import mockit.external.asm.ClassReader;

public final class ClassModification {
    private static final Class<?>[] NO_CLASSES = new Class[0];
    @Nonnull
    private final Map<String, ProtectionDomain> protectionDomainPerModifiedClass = new HashMap<String, ProtectionDomain>();
    @Nonnull
    final List<ProtectionDomain> protectionDomainsWithUniqueLocations = new ArrayList<ProtectionDomain>();
    @Nonnull
    private final ClassSelection classSelection = new ClassSelection();
    private boolean reprocessing;

    public ClassModification() {
        this.redefineClassesAlreadyLoadedForCoverage();
    }

    private void redefineClassesAlreadyLoadedForCoverage() {
        Class[] loadedClasses;
        Instrumentation inst = Startup.instrumentation();
        Class<?>[] previousLoadedClasses = NO_CLASSES;
        while ((loadedClasses = inst.getAllLoadedClasses()).length > previousLoadedClasses.length) {
            this.redefineClassesForCoverage(previousLoadedClasses, loadedClasses);
            previousLoadedClasses = loadedClasses;
        }
    }

    private void redefineClassesForCoverage(@Nonnull Class<?>[] previousClasses, @Nonnull Class<?>[] newClasses) {
        int m = previousClasses.length;
        int n = newClasses.length;
        for (int i = 0; i < n; ++i) {
            Class<?> loadedClass = newClasses[i];
            if (i < m && loadedClass == previousClasses[i] || loadedClass.getClassLoader() == null || loadedClass.isAnnotation() || loadedClass.isSynthetic() || !this.isToBeConsideredForCoverage(loadedClass.getName(), loadedClass.getProtectionDomain())) continue;
            this.redefineClassForCoverage(loadedClass);
        }
    }

    private void redefineClassForCoverage(@Nonnull Class<?> loadedClass) {
        byte[] modifiedClassfile = this.readAndModifyClassForCoverage(loadedClass);
        if (modifiedClassfile != null) {
            ClassModification.redefineClassForCoverage(loadedClass, modifiedClassfile);
            this.registerModifiedClass(loadedClass.getName(), loadedClass.getProtectionDomain());
        }
    }

    private void registerModifiedClass(@Nonnull String className, @Nonnull ProtectionDomain pd) {
        if (!this.protectionDomainPerModifiedClass.containsKey(className)) {
            this.protectionDomainPerModifiedClass.put(className, pd);
        }
        if (pd.getClassLoader() != null && pd.getCodeSource() != null && pd.getCodeSource().getLocation() != null) {
            this.addProtectionDomainIfHasUniqueNewPath(pd);
        }
    }

    private void addProtectionDomainIfHasUniqueNewPath(@Nonnull ProtectionDomain newPD) {
        String newPath = newPD.getCodeSource().getLocation().getPath();
        for (int i = this.protectionDomainsWithUniqueLocations.size() - 1; i >= 0; --i) {
            ProtectionDomain previousPD = this.protectionDomainsWithUniqueLocations.get(i);
            String previousPath = previousPD.getCodeSource().getLocation().getPath();
            if (previousPath.startsWith(newPath)) {
                return;
            }
            if (!newPath.startsWith(previousPath)) continue;
            this.protectionDomainsWithUniqueLocations.set(i, newPD);
            return;
        }
        this.protectionDomainsWithUniqueLocations.add(newPD);
    }

    @Nullable
    private byte[] readAndModifyClassForCoverage(@Nonnull Class<?> aClass) {
        try {
            return this.modifyClassForCoverage(aClass);
        }
        catch (VisitInterruptedException visitInterruptedException) {
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).printStackTrace();
        }
        return null;
    }

    @Nullable
    private byte[] modifyClassForCoverage(@Nonnull Class<?> aClass) {
        String className = aClass.getName();
        byte[] modifiedBytecode = CoverageModifier.recoverModifiedByteCodeIfAvailable(className);
        if (modifiedBytecode != null) {
            return modifiedBytecode;
        }
        ClassReader cr = CoverageModifier.createClassReader(aClass);
        return cr == null ? null : this.modifyClassForCoverage(cr);
    }

    @Nonnull
    private byte[] modifyClassForCoverage(@Nonnull ClassReader cr) {
        CoverageModifier modifier = new CoverageModifier(cr, this.reprocessing);
        cr.accept(modifier, 4);
        return modifier.toByteArray();
    }

    private static void redefineClassForCoverage(@Nonnull Class<?> loadedClass, @Nonnull byte[] modifiedClassfile) {
        ClassDefinition[] classDefs = new ClassDefinition[]{new ClassDefinition(loadedClass, modifiedClassfile)};
        try {
            Startup.instrumentation().redefineClasses(classDefs);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (UnmodifiableClassException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean shouldConsiderClassesNotLoaded() {
        return !this.classSelection.loadedOnly;
    }

    boolean isToBeConsideredForCoverage(@Nonnull String className, @Nonnull ProtectionDomain protectionDomain) {
        boolean reloaded;
        ProtectionDomain originalDomain = this.protectionDomainPerModifiedClass.get(className);
        if (originalDomain == null) {
            this.reprocessing = false;
            return this.classSelection.isSelected(className, protectionDomain);
        }
        this.reprocessing = reloaded = protectionDomain != originalDomain;
        return reloaded;
    }

    boolean isToBeConsideredForCoverageAsNotLoaded(@Nonnull String className, @Nonnull ProtectionDomain protectionDomain) {
        return !this.protectionDomainPerModifiedClass.containsKey(className) && this.classSelection.isSelected(className, protectionDomain);
    }

    @Nullable
    public byte[] modifyClass(@Nonnull String className, @Nonnull ProtectionDomain protectionDomain, @Nonnull byte[] originalClassfile) {
        boolean modifyClassForCoverage = this.isToBeConsideredForCoverage(className, protectionDomain);
        if (modifyClassForCoverage) {
            try {
                byte[] modifiedClassfile = this.modifyClassForCoverage(className, originalClassfile);
                this.registerModifiedClass(className, protectionDomain);
                return modifiedClassfile;
            }
            catch (VisitInterruptedException modifiedClassfile) {
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            catch (AssertionError e) {
                ((Throwable)((Object)e)).printStackTrace();
            }
            catch (ClassCircularityError e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Nonnull
    private byte[] modifyClassForCoverage(@Nonnull String className, @Nonnull byte[] classBytecode) {
        byte[] modifiedBytecode = CoverageModifier.recoverModifiedByteCodeIfAvailable(className);
        if (modifiedBytecode != null) {
            return modifiedBytecode;
        }
        ClassReader cr = new ClassReader(classBytecode);
        return this.modifyClassForCoverage(cr);
    }
}

