/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StackTrace {
    private static final Method getStackTraceDepth = StackTrace.getThrowableMethod("getStackTraceDepth", new Class[0]);
    private static final Method getStackTraceElement = StackTrace.getThrowableMethod("getStackTraceElement", Integer.TYPE);
    @NotNull
    private final Throwable throwable;
    @Nullable
    private final StackTraceElement[] elements;

    @Nullable
    private static Method getThrowableMethod(@NotNull String name, Class<?> ... parameterTypes) {
        Method method;
        try {
            method = Throwable.class.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
        method.setAccessible(true);
        return method;
    }

    public StackTrace() {
        this(new Throwable());
    }

    public StackTrace(@NotNull Throwable throwable) {
        this.throwable = throwable;
        this.elements = getStackTraceDepth == null ? throwable.getStackTrace() : null;
    }

    public int getDepth() {
        if (this.elements != null) {
            return this.elements.length;
        }
        int depth = 0;
        try {
            depth = (Integer)getStackTraceDepth.invoke((Object)this.throwable, new Object[0]);
        }
        catch (IllegalAccessException ignore) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return depth;
    }

    @NotNull
    public StackTraceElement getElement(int index) {
        if (this.elements != null) {
            return this.elements[index];
        }
        try {
            return (StackTraceElement)getStackTraceElement.invoke((Object)this.throwable, index);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void filterStackTrace(@NotNull Throwable t) {
        new StackTrace(t).filter();
    }

    public void filter() {
        int n = this.getDepth();
        StackTraceElement[] filteredST = new StackTraceElement[n];
        int j = 0;
        for (int i = 0; i < n; ++i) {
            StackTraceElement ste = this.getElement(i);
            if (ste.getFileName() == null) continue;
            String where = ste.getClassName();
            if (StackTrace.isSunMethod(ste) || StackTrace.isTestFrameworkMethod(where) || StackTrace.isJMockitMethod(where)) continue;
            filteredST[j] = ste;
            ++j;
        }
        StackTraceElement[] newStackTrace = new StackTraceElement[j];
        System.arraycopy(filteredST, 0, newStackTrace, 0, j);
        this.throwable.setStackTrace(newStackTrace);
        Throwable cause = this.throwable.getCause();
        if (cause != null) {
            new StackTrace(cause).filter();
        }
    }

    private static boolean isSunMethod(@NotNull StackTraceElement ste) {
        return ste.getClassName().startsWith("sun.") && !ste.isNativeMethod();
    }

    private static boolean isTestFrameworkMethod(@NotNull String where) {
        return where.startsWith("org.junit.") || where.startsWith("org.testng.");
    }

    private static boolean isJMockitMethod(@NotNull String where) {
        if (!where.startsWith("mockit.")) {
            return false;
        }
        int p = where.indexOf(36);
        if (p < 0) {
            int q = where.lastIndexOf("Test");
            return q < 0 || q + 4 < where.length();
        }
        int q = where.lastIndexOf("Test", p - 4);
        if (q < 0) {
            return true;
        }
        return (q += 4) < where.length() && where.charAt(q) != '$';
    }
}

