/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mockit.internal.ClassIdentification;
import mockit.internal.RedefinitionEngine;
import mockit.internal.capturing.CaptureTransformer;
import mockit.internal.expectations.mocking.CaptureOfNewInstances;
import mockit.internal.expectations.mocking.InstanceFactory;
import mockit.internal.startup.Startup;
import mockit.internal.state.TestRun;
import mockit.internal.util.ClassLoad;
import mockit.internal.util.GeneratedClasses;
import mockit.internal.util.Utilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MockFixture {
    @NotNull
    private final Map<ClassIdentification, byte[]> transformedClasses = new HashMap<ClassIdentification, byte[]>(2);
    @NotNull
    private final Map<Class<?>, byte[]> redefinedClasses = new IdentityHashMap(8);
    @NotNull
    private final Set<String> redefinedClassesWithNativeMethods = new HashSet<String>();
    @NotNull
    private final Map<Class<?>, String> realClassesToMockClasses = new IdentityHashMap(8);
    @NotNull
    private final List<Class<?>> mockedClasses = new ArrayList();
    @NotNull
    private final Map<Type, InstanceFactory> mockedTypesAndInstances = new IdentityHashMap<Type, InstanceFactory>();
    @NotNull
    private final List<CaptureTransformer<?>> captureTransformers = new ArrayList();

    public void addTransformedClass(@NotNull ClassIdentification classId, @NotNull byte[] pretransformClassfile) {
        this.transformedClasses.put(classId, pretransformClassfile);
    }

    public void addRedefinedClass(@Nullable String mockClassInternalName, @NotNull Class<?> redefinedClass, @NotNull byte[] modifiedClassfile) {
        String previousNames;
        if (mockClassInternalName != null && (previousNames = this.realClassesToMockClasses.put(redefinedClass, mockClassInternalName)) != null) {
            this.realClassesToMockClasses.put(redefinedClass, previousNames + ' ' + mockClassInternalName);
        }
        this.addRedefinedClass(redefinedClass, modifiedClassfile);
    }

    public void addRedefinedClass(@NotNull Class<?> redefinedClass, @NotNull byte[] modifiedClassfile) {
        this.redefinedClasses.put(redefinedClass, modifiedClassfile);
    }

    public void registerMockedClass(@NotNull Class<?> mockedType) {
        if (!Utilities.containsReference(this.mockedClasses, mockedType)) {
            if (Proxy.isProxyClass(mockedType)) {
                mockedType = mockedType.getInterfaces()[0];
            }
            this.mockedClasses.add(mockedType);
        }
    }

    public boolean isStillMocked(@Nullable Object instance, @NotNull String classDesc) {
        if (instance == null) {
            Class targetClass = ClassLoad.loadByInternalName(classDesc);
            return this.isAssignableFromMockedClass(targetClass);
        }
        Class<?> targetClass = instance.getClass();
        return this.mockedTypesAndInstances.containsKey(targetClass) || this.isInstanceOfMockedClass(instance);
    }

    private boolean isAssignableFromMockedClass(@NotNull Class<?> targetClass) {
        int n = this.mockedClasses.size();
        for (int i = 0; i < n; ++i) {
            Class<?> mockedClass = this.mockedClasses.get(i);
            if (targetClass != mockedClass && !targetClass.isAssignableFrom(mockedClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isMockedClass(@NotNull Class<?> targetClass) {
        int n = this.mockedClasses.size();
        for (int i = 0; i < n; ++i) {
            if (this.mockedClasses.get(i) != targetClass) continue;
            return true;
        }
        return false;
    }

    public boolean isInstanceOfMockedClass(@NotNull Object mockedInstance) {
        Class<?> mockedClass = mockedInstance.getClass();
        int n = this.mockedClasses.size();
        for (int i = 0; i < n; ++i) {
            Class<?> mockedType = this.mockedClasses.get(i);
            if (mockedType != mockedClass && !mockedType.isAssignableFrom(mockedClass)) continue;
            return true;
        }
        return false;
    }

    public void registerInstanceFactoryForMockedType(@NotNull Class<?> mockedType, @NotNull InstanceFactory mockedInstanceFactory) {
        this.registerMockedClass(mockedType);
        this.mockedTypesAndInstances.put(mockedType, mockedInstanceFactory);
    }

    @Nullable
    public InstanceFactory findInstanceFactory(@NotNull Type mockedType) {
        Class mockedClass = Utilities.getClassType((Type)mockedType);
        InstanceFactory instanceFactory = this.mockedTypesAndInstances.get(mockedType);
        if (instanceFactory != null) {
            return instanceFactory;
        }
        boolean abstractType = mockedClass.isInterface() || Modifier.isAbstract(mockedClass.getModifiers());
        for (Map.Entry<Type, InstanceFactory> entry : this.mockedTypesAndInstances.entrySet()) {
            Type registeredMockedType = entry.getKey();
            Class registeredMockedClass = Utilities.getClassType((Type)registeredMockedType);
            if (abstractType) {
                registeredMockedClass = GeneratedClasses.getMockedClassOrInterfaceType((Class)registeredMockedClass);
            }
            if (!mockedClass.isAssignableFrom(registeredMockedClass)) continue;
            instanceFactory = entry.getValue();
            break;
        }
        return instanceFactory;
    }

    public void restoreAndRemoveRedefinedClasses(@Nullable Set<Class<?>> desiredClasses) {
        Set<Class<?>> classesToRestore = desiredClasses == null ? this.redefinedClasses.keySet() : desiredClasses;
        RedefinitionEngine redefinitionEngine = new RedefinitionEngine();
        for (Class<?> redefinedClass : classesToRestore) {
            redefinitionEngine.restoreOriginalDefinition(redefinedClass);
            this.restoreDefinition(redefinedClass);
            this.discardStateForCorrespondingMockClassIfAny(redefinedClass);
        }
        if (desiredClasses == null) {
            this.redefinedClasses.clear();
        } else {
            this.redefinedClasses.keySet().removeAll(desiredClasses);
        }
    }

    private void restoreDefinition(@NotNull Class<?> redefinedClass) {
        if (this.redefinedClassesWithNativeMethods.contains(redefinedClass.getName())) {
            MockFixture.reregisterNativeMethodsForRestoredClass(redefinedClass);
        }
        this.removeMockedClass(redefinedClass);
    }

    private void removeMockedClass(@NotNull Class<?> mockedClass) {
        this.mockedTypesAndInstances.remove(mockedClass);
        this.mockedClasses.remove(mockedClass);
    }

    private void discardStateForCorrespondingMockClassIfAny(@NotNull Class<?> redefinedClass) {
        String mockClassesInternalNames = this.realClassesToMockClasses.remove(redefinedClass);
        TestRun.getMockStates().removeClassState(redefinedClass, mockClassesInternalNames);
    }

    void restoreTransformedClasses(@NotNull Set<ClassIdentification> previousTransformedClasses) {
        if (!this.transformedClasses.isEmpty()) {
            Set<ClassIdentification> classesToRestore;
            if (previousTransformedClasses.isEmpty()) {
                classesToRestore = this.transformedClasses.keySet();
            } else {
                classesToRestore = this.getTransformedClasses();
                classesToRestore.removeAll(previousTransformedClasses);
            }
            if (!classesToRestore.isEmpty()) {
                this.restoreAndRemoveTransformedClasses(classesToRestore);
            }
        }
    }

    private void restoreAndRemoveTransformedClasses(@NotNull Set<ClassIdentification> classesToRestore) {
        RedefinitionEngine redefinitionEngine = new RedefinitionEngine();
        for (ClassIdentification transformedClassId : classesToRestore) {
            byte[] definitionToRestore = this.transformedClasses.get(transformedClassId);
            redefinitionEngine.restoreToDefinition(transformedClassId.getLoadedClass(), definitionToRestore);
        }
        this.transformedClasses.keySet().removeAll(classesToRestore);
    }

    void restoreRedefinedClasses(@NotNull Map<?, byte[]> previousDefinitions) {
        if (this.redefinedClasses.isEmpty()) {
            return;
        }
        RedefinitionEngine redefinitionEngine = new RedefinitionEngine();
        Iterator<Map.Entry<Class<?>, byte[]>> itr = this.redefinedClasses.entrySet().iterator();
        while (itr.hasNext()) {
            byte[] previousDefinition;
            Map.Entry<Class<?>, byte[]> entry = itr.next();
            Class<?> redefinedClass = entry.getKey();
            byte[] currentDefinition = entry.getValue();
            if (currentDefinition == (previousDefinition = previousDefinitions.get(redefinedClass))) continue;
            redefinitionEngine.restoreDefinition(redefinedClass, previousDefinition);
            if (previousDefinition == null) {
                this.restoreDefinition(redefinedClass);
                this.discardStateForCorrespondingMockClassIfAny(redefinedClass);
                itr.remove();
                continue;
            }
            entry.setValue(previousDefinition);
        }
    }

    void removeMockedClasses(@NotNull List<Class<?>> previousMockedClasses) {
        int currentMockedClassCount = this.mockedClasses.size();
        if (currentMockedClassCount > 0) {
            int previousMockedClassCount = previousMockedClasses.size();
            if (previousMockedClassCount == 0) {
                this.mockedClasses.clear();
                this.mockedTypesAndInstances.clear();
            } else if (previousMockedClassCount < currentMockedClassCount) {
                this.mockedClasses.retainAll(previousMockedClasses);
                this.mockedTypesAndInstances.keySet().retainAll(previousMockedClasses);
            }
        }
    }

    public void addRedefinedClassWithNativeMethods(@NotNull String redefinedClassInternalName) {
        this.redefinedClassesWithNativeMethods.add(redefinedClassInternalName.replace('/', '.'));
    }

    private static void reregisterNativeMethodsForRestoredClass(@NotNull Class<?> realClass) {
        Method registerNatives = null;
        try {
            registerNatives = realClass.getDeclaredMethod("registerNatives", new Class[0]);
        }
        catch (NoSuchMethodException ignore) {
            try {
                registerNatives = realClass.getDeclaredMethod("initIDs", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (registerNatives != null) {
            try {
                registerNatives.setAccessible(true);
                registerNatives.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException ignore) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    @NotNull
    Set<ClassIdentification> getTransformedClasses() {
        return this.transformedClasses.isEmpty() ? Collections.emptySet() : new HashSet<ClassIdentification>(this.transformedClasses.keySet());
    }

    @NotNull
    Map<Class<?>, byte[]> getRedefinedClasses() {
        return this.redefinedClasses.isEmpty() ? Collections.emptyMap() : new HashMap(this.redefinedClasses);
    }

    @Nullable
    public byte[] getRedefinedClassfile(@NotNull Class<?> redefinedClass) {
        return this.redefinedClasses.get(redefinedClass);
    }

    public boolean containsRedefinedClass(@NotNull Class<?> redefinedClass) {
        return this.redefinedClasses.containsKey(redefinedClass);
    }

    @NotNull
    public List<Class<?>> getMockedClasses() {
        return this.mockedClasses.isEmpty() ? Collections.emptyList() : new ArrayList(this.mockedClasses);
    }

    public void addCaptureTransformer(@NotNull CaptureTransformer<?> transformer) {
        this.captureTransformers.add(transformer);
    }

    public int getCaptureTransformerCount() {
        return this.captureTransformers.size();
    }

    public void removeCaptureTransformers(int previousTransformerCount) {
        int currentTransformerCount = this.captureTransformers.size();
        for (int i = currentTransformerCount - 1; i >= previousTransformerCount; --i) {
            CaptureTransformer<?> transformer = this.captureTransformers.get(i);
            transformer.deactivate();
            Startup.instrumentation().removeTransformer((ClassFileTransformer)transformer);
            this.captureTransformers.remove(i);
        }
    }

    @Nullable
    public CaptureOfNewInstances findCaptureOfImplementations(@NotNull Class<?> baseType) {
        for (CaptureTransformer<?> captureTransformer : this.captureTransformers) {
            CaptureOfNewInstances capture = (CaptureOfNewInstances)captureTransformer.getCaptureOfImplementationsIfApplicable(baseType);
            if (capture == null) continue;
            return capture;
        }
        return null;
    }
}

