/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.standalone;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import mockit.coverage.CodeCoverage;
import mockit.coverage.standalone.CoverageControl;
import org.jetbrains.annotations.NotNull;

public final class Startup {
    private static Instrumentation instrumentation;
    private static boolean inATestRun;
    private static boolean jmockitAvailable;

    private Startup() {
    }

    public static void premain(String agentArgs, @NotNull Instrumentation inst) throws IOException {
        String startupMessage;
        instrumentation = inst;
        Startup.discoverOptionalDependenciesThatAreAvailableInClassPath();
        if (inATestRun) {
            startupMessage = "JMockit Coverage tool loaded";
        } else {
            startupMessage = "JMockit Coverage tool loaded; connect with a JMX client to control operation";
            CoverageControl.create();
        }
        CodeCoverage coverageTransformer = CodeCoverage.create(inATestRun);
        inst.addTransformer(coverageTransformer);
        System.out.println();
        System.out.println(startupMessage);
        System.out.println();
        if (jmockitAvailable) {
            mockit.internal.startup.Startup.initialize(inst);
        }
    }

    private static void discoverOptionalDependenciesThatAreAvailableInClassPath() {
        inATestRun = Startup.isAvailableInClassPath("org.junit.Assert") || Startup.isAvailableInClassPath("org.testng.Assert");
        jmockitAvailable = Startup.isAvailableInClassPath("mockit.Invocations");
    }

    private static boolean isAvailableInClassPath(@NotNull String className) {
        ClassLoader currentLoader = Startup.class.getClassLoader();
        try {
            Class.forName(className, false, currentLoader);
            return true;
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }

    @NotNull
    public static Instrumentation instrumentation() {
        if (instrumentation == null) {
            instrumentation = mockit.internal.startup.Startup.instrumentation();
        }
        return instrumentation;
    }

    public static boolean isTestRun() {
        return inATestRun;
    }

    public static boolean isJMockitAvailable() {
        return jmockitAvailable;
    }

    public static boolean isInitialized() {
        return instrumentation != null;
    }

    static {
        inATestRun = true;
        jmockitAvailable = true;
    }
}

