/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.standalone;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.PersistentMBean;
import javax.management.StandardMBean;
import mockit.coverage.CodeCoverage;
import mockit.coverage.Configuration;
import mockit.coverage.standalone.CoverageControlMBean;
import mockit.coverage.standalone.Description;
import org.jetbrains.annotations.NotNull;

public final class CoverageControl
extends StandardMBean
implements CoverageControlMBean,
PersistentMBean {
    static void create() {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            CoverageControl mxBean = new CoverageControl();
            mbeanServer.registerMBean(mxBean, new ObjectName("JMockit Coverage:type=CoverageControl"));
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }

    public CoverageControl() throws NotCompliantMBeanException, MBeanException {
        super(CoverageControlMBean.class);
        this.load();
    }

    @Override
    @NotNull
    protected String getDescription(MBeanInfo info) {
        return CoverageControlMBean.class.getAnnotation(Description.class).value();
    }

    @Override
    @NotNull
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        return "resetState";
    }

    @Override
    protected String getDescription(@NotNull MBeanAttributeInfo info) {
        return this.getDescription("get" + info.getName());
    }

    @NotNull
    private String getDescription(@NotNull String methodName) {
        return this.getMethod(methodName).getAnnotation(Description.class).value();
    }

    @NotNull
    private Method getMethod(@NotNull String methodName) {
        for (Method method : CoverageControlMBean.class.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        throw new IllegalStateException("Required method not found in class CoverageControlMBean: " + methodName);
    }

    @Override
    protected String getDescription(@NotNull MBeanOperationInfo info) {
        return this.getDescription(info.getName());
    }

    @Override
    protected String getDescription(@NotNull MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        Method method = this.getMethod(op.getName());
        Description desc = (Description)method.getParameterAnnotations()[sequence][0];
        return desc.value();
    }

    @Override
    protected int getImpact(MBeanOperationInfo info) {
        return 1;
    }

    @Override
    @NotNull
    public String getOutput() {
        return this.getProperty("output", "html").replace("-nocp", "");
    }

    @Override
    public void setOutput(@NotNull String output) {
        String validValues = "html serial serial-append html,serial html,serial-append serial,html serial-append,html";
        this.modifyConfigurationProperty("output", "html".equals(output = this.validateNewPropertyValue("Output", validValues, output)) ? "html-nocp" : output);
    }

    @NotNull
    private String validateNewPropertyValue(@NotNull String propertyName, @NotNull String validValues, @NotNull String newValue) {
        String valueWithNoSpaces = newValue.replace(" ", "");
        if (validValues.contains(valueWithNoSpaces)) {
            return valueWithNoSpaces;
        }
        throw new IllegalArgumentException("Invalid value for \"" + propertyName + "\" property: " + newValue);
    }

    @Override
    @NotNull
    public String getWorkingDir() {
        return new File(".").getAbsoluteFile().getParent();
    }

    @Override
    @NotNull
    public String getOutputDir() {
        return this.getProperty("outputDir");
    }

    @Override
    public void setOutputDir(@NotNull String outputDir) {
        this.modifyConfigurationProperty("outputDir", outputDir);
    }

    @Override
    @NotNull
    public String getSrcDirs() {
        return this.getProperty("srcDirs");
    }

    @Override
    public void setSrcDirs(@NotNull String srcDirs) {
        this.modifyConfigurationProperty("srcDirs", srcDirs);
    }

    @Override
    @NotNull
    public String getClasses() {
        return this.getProperty("classes");
    }

    @Override
    public void setClasses(@NotNull String classes) {
        this.modifyConfigurationProperty("classes", classes);
    }

    @Override
    @NotNull
    public String getExcludes() {
        return this.getProperty("excludes");
    }

    @Override
    public void setExcludes(@NotNull String excludes) {
        this.modifyConfigurationProperty("excludes", excludes);
    }

    @Override
    @NotNull
    public String getMetrics() {
        return this.getProperty("metrics", "all");
    }

    @Override
    public void setMetrics(@NotNull String metrics) {
        if (metrics.isEmpty()) {
            throw new IllegalArgumentException("Please select a valid value for the \"Metrics\" property");
        }
        metrics = this.validateNewPropertyValue("Metrics", "all line path line,path", metrics);
        this.modifyConfigurationProperty("metrics", metrics);
    }

    @NotNull
    private String getProperty(@NotNull String property) {
        return this.getProperty(property, "");
    }

    @NotNull
    private String getProperty(@NotNull String property, @NotNull String defaultValue) {
        return Configuration.getProperty(this.propertyNameSuffix(property), defaultValue);
    }

    @NotNull
    private String propertyNameSuffix(@NotNull String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    private void modifyConfigurationProperty(@NotNull String name, @NotNull String value) {
        this.setConfigurationProperty(name, value);
        CodeCoverage.resetConfiguration();
        this.store();
    }

    private void setConfigurationProperty(@NotNull String name, @NotNull String value) {
        Configuration.setProperty(this.propertyNameSuffix(name), value);
    }

    @Override
    public void generateOutput(boolean resetState) {
        CodeCoverage.generateOutput(resetState);
    }

    @Override
    public void load() throws MBeanException {
        Preferences preferences = Preferences.userNodeForPackage(CoverageControl.class);
        try {
            for (String property : preferences.keys()) {
                String commandLineValue = this.getProperty(property);
                if (!commandLineValue.isEmpty()) continue;
                String value = preferences.get(property, "");
                this.setConfigurationProperty(property, value);
            }
        }
        catch (BackingStoreException e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public void store() {
        Preferences preferences = Preferences.userNodeForPackage(CoverageControl.class);
        for (MBeanAttributeInfo info : this.getMBeanInfo().getAttributes()) {
            String property = info.getName();
            String value = this.getProperty(property);
            preferences.put(property, value);
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }
}

