/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.sourceFiles;

import java.io.PrintWriter;
import mockit.coverage.reporting.parsing.LineElement;
import mockit.coverage.reporting.parsing.LineParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NeutralOutput {
    @NotNull
    private final PrintWriter output;
    private boolean previousLineInImports;
    private boolean previousLineInComments;
    @Nullable
    private String lineIndentation;
    private boolean blankLinesPending;

    NeutralOutput(@NotNull PrintWriter output) {
        this.output = output;
    }

    boolean writeLineWithoutCoverageInfo(@NotNull LineParser lineParser) {
        if (this.previousLineInComments || !this.previousLineInImports ? this.writeLineInComments(lineParser) || this.writeLineInImports(lineParser) : this.writeLineInImports(lineParser) || this.writeLineInComments(lineParser)) {
            return true;
        }
        if (lineParser.isBlankLine()) {
            this.blankLinesPending = true;
            return true;
        }
        this.writeBlankLineIfPending();
        return false;
    }

    private boolean writeLineInComments(@NotNull LineParser lineParser) {
        LineElement initialElement = lineParser.getInitialElement();
        if (lineParser.isInComments() || this.previousLineInComments && initialElement.isComment() && initialElement.getNext() == null) {
            String lineText = initialElement.toString();
            if (this.previousLineInComments) {
                this.output.println();
            } else {
                this.writeOpeningForCollapsibleBlockOfLines();
                this.output.write("      <td class='comment' onclick='showHideLines(this)'><div>");
                this.extractLineIndentation(lineText);
                this.previousLineInComments = true;
            }
            this.output.write(lineText);
            return true;
        }
        if (this.previousLineInComments) {
            this.output.append("</div><span>").append(this.lineIndentation).println("/*...*/</span></td>");
            this.output.println("    </tr>");
            this.previousLineInComments = false;
        }
        return false;
    }

    private void writeOpeningForCollapsibleBlockOfLines() {
        this.writeBlankLineIfPending();
        this.output.println("    <tr>");
        this.output.println("      <td class='line'></td><td>&nbsp;</td>");
    }

    private void writeBlankLineIfPending() {
        if (this.blankLinesPending) {
            this.output.println("    <tr><td class='line'></td><td colspan='2'>&nbsp;</td></tr>");
            this.blankLinesPending = false;
        }
    }

    private void extractLineIndentation(@NotNull String lineText) {
        int indentationSize = 0;
        int i = 0;
        while (i < lineText.length() && lineText.charAt(i) <= ' ') {
            ++i;
            ++indentationSize;
        }
        this.lineIndentation = lineText.substring(0, indentationSize);
    }

    private boolean writeLineInImports(@NotNull LineParser lineParser) {
        LineElement initialElement = lineParser.getInitialElement();
        boolean isImport = initialElement.isKeyword("import");
        if (!this.previousLineInImports && isImport || this.previousLineInImports && (isImport || lineParser.isBlankLine())) {
            String lineText = initialElement.toString();
            if (this.previousLineInImports) {
                this.output.println();
                this.blankLinesPending = !isImport;
            } else {
                this.writeOpeningForCollapsibleBlockOfLines();
                this.output.write("      <td><pre class='imports prettyprint' onclick='showHideLines(this)'><div>");
                this.previousLineInImports = true;
            }
            this.output.write(lineText);
            return true;
        }
        if (this.previousLineInImports) {
            this.output.println("</div><span>import ...</span></pre></td>");
            this.output.println("    </tr>");
            this.previousLineInImports = false;
        }
        return false;
    }
}

