/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.sourceFiles;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InputFile {
    @NotNull
    final String filePath;
    @NotNull
    private final File sourceFile;
    @NotNull
    private final BufferedReader input;

    @Nullable
    public static InputFile createIfFileExists(@NotNull List<File> sourceDirs, @NotNull String filePath) throws FileNotFoundException {
        File sourceFile = InputFile.findSourceFile(sourceDirs, filePath);
        return sourceFile == null ? null : new InputFile(filePath, sourceFile);
    }

    @Nullable
    private static File findSourceFile(@NotNull List<File> sourceDirs, @NotNull String filePath) {
        int p = filePath.indexOf(47);
        String topLevelPackage = p < 0 ? "" : filePath.substring(0, p);
        int n = sourceDirs.size();
        for (int i = 0; i < n; ++i) {
            File sourceDir = sourceDirs.get(i);
            File sourceFile = InputFile.getSourceFile(sourceDir, topLevelPackage, filePath);
            if (sourceFile == null) continue;
            InputFile.giveCurrentSourceDirHighestPriority(sourceDirs, i);
            InputFile.addRootSourceDirIfNew(sourceDirs, filePath, sourceFile);
            return sourceFile;
        }
        return null;
    }

    @Nullable
    private static File getSourceFile(@NotNull File sourceDir, final @NotNull String topLevelPackage, @NotNull String filePath) {
        File file = new File(sourceDir, filePath);
        if (file.exists()) {
            return file;
        }
        File[] subDirs = sourceDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File subDir) {
                return subDir.isDirectory() && !subDir.isHidden() && !subDir.getName().equals(topLevelPackage);
            }
        });
        if (subDirs != null && subDirs.length > 0) {
            for (File subDir : subDirs) {
                File sourceFile = InputFile.getSourceFile(subDir, topLevelPackage, filePath);
                if (sourceFile == null) continue;
                return sourceFile;
            }
        }
        return null;
    }

    private static void giveCurrentSourceDirHighestPriority(@NotNull List<File> sourceDirs, int currentSourceDirIndex) {
        if (currentSourceDirIndex > 0) {
            File firstSourceDir = sourceDirs.get(0);
            File currentSourceDir = sourceDirs.get(currentSourceDirIndex);
            if (!firstSourceDir.getPath().startsWith(currentSourceDir.getPath())) {
                sourceDirs.set(currentSourceDirIndex, firstSourceDir);
                sourceDirs.set(0, currentSourceDir);
            }
        }
    }

    private static void addRootSourceDirIfNew(@NotNull List<File> sourceDirs, @NotNull String filePath, @NotNull File sourceFile) {
        String sourceFilePath = sourceFile.getPath();
        String sourceRootDir = sourceFilePath.substring(0, sourceFilePath.length() - filePath.length());
        File newSourceDir = new File(sourceRootDir);
        if (!sourceDirs.contains(newSourceDir)) {
            sourceDirs.add(0, newSourceDir);
        }
    }

    private InputFile(@NotNull String filePath, @NotNull File sourceFile) throws FileNotFoundException {
        this.filePath = filePath;
        this.sourceFile = sourceFile;
        this.input = new BufferedReader(new FileReader(sourceFile));
    }

    @NotNull
    String getSourceFileName() {
        return this.sourceFile.getName();
    }

    @NotNull
    String getSourceFilePath() {
        String path = this.sourceFile.getPath();
        return path.startsWith("..") ? path.substring(3) : path;
    }

    @Nullable
    String nextLine() throws IOException {
        return this.input.readLine();
    }

    void close() throws IOException {
        this.input.close();
    }
}

