/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.parsing;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LineElement
implements Iterable<LineElement> {
    private static final List<String> CONDITIONAL_OPERATORS = Arrays.asList("||", "&&", ":", "else");
    private static final List<String> CONDITIONAL_INSTRUCTIONS = Arrays.asList("if", "for", "while");
    private static final Pattern OPEN_TAG = Pattern.compile("<");
    private static final NoSuchElementException LAST_ELEMENT_REACHED = new NoSuchElementException();
    @NotNull
    private final ElementType type;
    @NotNull
    private final String text;
    @Nullable
    private String openingTag;
    @Nullable
    private String closingTag;
    @Nullable
    private LineElement next;
    private boolean underConditionalStatement;
    private int parenthesesBalance;

    LineElement(@NotNull ElementType type, @NotNull String text) {
        this.type = type;
        this.text = OPEN_TAG.matcher(text).replaceAll("&lt;");
    }

    public boolean isCode() {
        return this.type == ElementType.CODE;
    }

    public boolean isComment() {
        return this.type == ElementType.COMMENT;
    }

    public boolean isKeyword(@NotNull String keyword) {
        return this.isCode() && this.text.equals(keyword);
    }

    public boolean isDotSeparator() {
        return this.type == ElementType.SEPARATOR && this.text.charAt(0) == '.';
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    @Nullable
    public LineElement getNext() {
        return this.next;
    }

    void setNext(@Nullable LineElement next) {
        this.next = next;
    }

    @Nullable
    public LineElement getNextCodeElement() {
        if (this.next != null) {
            for (LineElement element : this.next) {
                if (!element.isCode()) continue;
                return element;
            }
        }
        return null;
    }

    public void wrapText(@NotNull String desiredOpeningTag, @NotNull String desiredClosingTag) {
        this.openingTag = desiredOpeningTag;
        this.closingTag = desiredClosingTag;
    }

    @Nullable
    public LineElement appendUntilNextCodeElement(@NotNull StringBuilder line) {
        LineElement element = this;
        while (!element.isCode()) {
            element.appendText(line);
            element = element.next;
            if (element == null) break;
            this.copyConditionalTrackingState(element);
        }
        return element;
    }

    private void copyConditionalTrackingState(@NotNull LineElement destination) {
        destination.underConditionalStatement = this.underConditionalStatement;
        destination.parenthesesBalance = this.parenthesesBalance;
    }

    private void appendText(@NotNull StringBuilder line) {
        if (this.openingTag == null) {
            line.append(this.text);
        } else {
            line.append(this.openingTag).append(this.text).append(this.closingTag);
        }
    }

    @Nullable
    public LineElement findNextBranchingPoint() {
        if (!this.underConditionalStatement) {
            this.underConditionalStatement = this.isConditionalStatement();
        }
        if (this.isBranchingElement()) {
            if (this.next != null) {
                this.copyConditionalTrackingState(this.next);
            }
            return this;
        }
        if (this.underConditionalStatement) {
            int balance = this.getParenthesisBalance();
            this.parenthesesBalance += balance;
            if (balance != 0 && this.parenthesesBalance == 0) {
                return this.next;
            }
        }
        if (this.next == null) {
            return null;
        }
        this.copyConditionalTrackingState(this.next);
        return this.next.findNextBranchingPoint();
    }

    private boolean isConditionalStatement() {
        return CONDITIONAL_INSTRUCTIONS.contains(this.text);
    }

    public boolean isBranchingElement() {
        return CONDITIONAL_OPERATORS.contains(this.text);
    }

    private int getParenthesisBalance() {
        int balance = 0;
        int p = this.text.indexOf(40);
        while (p >= 0) {
            ++balance;
            p = this.text.indexOf(40, p + 1);
        }
        int q = this.text.indexOf(41);
        while (q >= 0) {
            --balance;
            q = this.text.indexOf(41, q + 1);
        }
        return balance;
    }

    @Nullable
    public LineElement findWord(@NotNull String word) {
        for (LineElement element : this) {
            if (!element.isCode() || !word.equals(element.text)) continue;
            return element;
        }
        return null;
    }

    public int getBraceBalanceUntilEndOfLine() {
        int balance = 0;
        for (LineElement element : this) {
            balance += element.getBraceBalance();
        }
        return balance;
    }

    private int getBraceBalance() {
        if (this.isCode() && this.text.length() == 1) {
            char c = this.text.charAt(0);
            if (c == '{') {
                return 1;
            }
            if (c == '}') {
                return -1;
            }
        }
        return 0;
    }

    public void appendAllBefore(@NotNull StringBuilder line, @Nullable LineElement elementToStopBefore) {
        LineElement elementToPrint = this;
        do {
            elementToPrint.appendText(line);
        } while ((elementToPrint = elementToPrint.next) != null && elementToPrint != elementToStopBefore);
    }

    @Override
    @NotNull
    public Iterator<LineElement> iterator() {
        return new Iterator<LineElement>(){
            @Nullable
            private LineElement current;
            {
                this.current = LineElement.this;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            @NotNull
            public LineElement next() {
                if (this.current == null) {
                    throw LAST_ELEMENT_REACHED;
                }
                LineElement nextElement = this.current;
                this.current = this.current.next;
                return nextElement;
            }

            @Override
            public void remove() {
            }
        };
    }

    public String toString() {
        StringBuilder line = new StringBuilder(200);
        for (LineElement element : this) {
            element.appendText(line);
        }
        return line.toString();
    }

    static enum ElementType {
        CODE,
        COMMENT,
        SEPARATOR;

    }
}

