/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.lineCoverage;

import java.util.List;
import mockit.coverage.CallPoint;
import mockit.coverage.lines.BranchCoverageData;
import mockit.coverage.lines.LineCoverageData;
import mockit.coverage.lines.LineSegmentData;
import mockit.coverage.reporting.ListOfCallPoints;
import mockit.coverage.reporting.parsing.LineElement;
import mockit.coverage.reporting.parsing.LineParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LineSegmentsFormatter {
    @Nullable
    private final ListOfCallPoints listOfCallPoints;
    @NotNull
    private final StringBuilder line;
    private int lineNumber;
    @Nullable
    private LineElement element;
    private int segmentIndex;

    LineSegmentsFormatter(boolean withCallPoints, @NotNull StringBuilder line) {
        this.listOfCallPoints = withCallPoints ? new ListOfCallPoints() : null;
        this.line = line;
    }

    void formatSegments(@NotNull LineParser lineParser, @NotNull LineCoverageData lineData) {
        this.lineNumber = lineParser.getNumber();
        List<BranchCoverageData> branchData = lineData.getBranches();
        int numSegments = lineData.getNumberOfSegments();
        this.element = lineParser.getInitialElement().appendUntilNextCodeElement(this.line);
        this.segmentIndex = 0;
        this.appendUntilFirstElementAfterNextBranchingPoint(lineData);
        while (this.element != null && this.segmentIndex < numSegments) {
            LineCoverageData segmentData = this.segmentIndex == 0 ? lineData : (LineSegmentData)branchData.get(this.segmentIndex - 1);
            this.element = this.element.appendUntilNextCodeElement(this.line);
            this.appendUntilFirstElementAfterNextBranchingPoint(segmentData);
        }
        this.line.append("</pre>");
        if (this.listOfCallPoints != null && lineData.containsCallPoints()) {
            this.line.append(this.listOfCallPoints.getContents());
        }
    }

    private void appendUntilFirstElementAfterNextBranchingPoint(@NotNull LineSegmentData segmentData) {
        if (this.element != null) {
            LineElement firstElement = this.element;
            this.element = this.element.findNextBranchingPoint();
            this.appendToFormattedLine(firstElement, segmentData);
            if (this.element != null && this.element.isBranchingElement()) {
                this.line.append(this.element.getText());
                this.element = this.element.getNext();
            }
        }
    }

    private void appendToFormattedLine(@NotNull LineElement firstElement, @NotNull LineSegmentData segmentData) {
        if (firstElement == this.element) {
            return;
        }
        this.appendStartTag(segmentData);
        firstElement.appendAllBefore(this.line, this.element);
        this.appendEndTag(segmentData);
        ++this.segmentIndex;
    }

    private void appendStartTag(@NotNull LineSegmentData segmentData) {
        this.line.append("<span id='l").append(this.lineNumber).append('s').append(this.segmentIndex).append("' ");
        this.appendTooltipWithExecutionCounts(segmentData);
        if (segmentData.isCovered()) {
            if (segmentData.containsCallPoints()) {
                this.line.append("class='covered cp' onclick='showHide(this,").append(this.segmentIndex).append(")'>");
            } else {
                this.line.append("class='covered'>");
            }
        } else {
            this.line.append("class='uncovered'>");
        }
    }

    private void appendTooltipWithExecutionCounts(@NotNull LineSegmentData segmentData) {
        this.line.append("title='Executions: ").append(segmentData.getExecutionCount()).append("' ");
    }

    private void appendEndTag(@NotNull LineSegmentData segmentData) {
        int i = this.line.length() - 1;
        while (Character.isWhitespace(this.line.charAt(i))) {
            --i;
        }
        this.line.insert(i + 1, "</span>");
        if (this.listOfCallPoints != null) {
            List<CallPoint> callPoints = segmentData.getCallPoints();
            this.listOfCallPoints.insertListOfCallPoints(callPoints);
        }
    }
}

