/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.lineCoverage;

import java.util.List;
import mockit.coverage.CallPoint;
import mockit.coverage.lines.LineCoverageData;
import mockit.coverage.lines.PerFileLineCoverage;
import mockit.coverage.reporting.ListOfCallPoints;
import mockit.coverage.reporting.lineCoverage.LineSegmentsFormatter;
import mockit.coverage.reporting.parsing.LineParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LineCoverageFormatter {
    @NotNull
    private final StringBuilder formattedLine = new StringBuilder(200);
    @NotNull
    private final LineSegmentsFormatter segmentsFormatter;
    @Nullable
    private final ListOfCallPoints listOfCallPoints;

    LineCoverageFormatter(boolean withCallPoints) {
        this.segmentsFormatter = new LineSegmentsFormatter(withCallPoints, this.formattedLine);
        this.listOfCallPoints = withCallPoints ? new ListOfCallPoints() : null;
    }

    String format(@NotNull LineParser lineParser, @NotNull PerFileLineCoverage lineCoverageData) {
        this.formattedLine.setLength(0);
        this.formattedLine.append("<pre class='prettyprint");
        int line = lineParser.getNumber();
        LineCoverageData lineData = lineCoverageData.getLineData(line);
        if (lineData.containsBranches()) {
            this.formatLineWithMultipleSegments(lineParser, lineData);
        } else {
            this.formatLineWithSingleSegment(lineParser, lineData);
        }
        return this.formattedLine.toString();
    }

    private void formatLineWithMultipleSegments(@NotNull LineParser lineParser, @NotNull LineCoverageData lineData) {
        this.formattedLine.append(" jmp'>");
        this.segmentsFormatter.formatSegments(lineParser, lineData);
    }

    private void formatLineWithSingleSegment(@NotNull LineParser lineParser, @NotNull LineCoverageData lineData) {
        this.formattedLine.append(lineData.isCovered() ? " covered" : " uncovered");
        List<CallPoint> callPoints = lineData.getCallPoints();
        if (this.listOfCallPoints != null && callPoints != null) {
            this.formattedLine.append(" cp' onclick='showHide(this)");
        }
        this.formattedLine.append("' id='l").append(lineParser.getNumber()).append("s0'>");
        String content = lineParser.getInitialElement().toString();
        this.formattedLine.append(content).append("</pre>");
        if (this.listOfCallPoints != null) {
            this.listOfCallPoints.insertListOfCallPoints(callPoints);
            this.formattedLine.append(this.listOfCallPoints.getContents());
        }
    }
}

