/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.paths;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mockit.coverage.paths.Node;
import mockit.coverage.paths.Path;
import org.jetbrains.annotations.NotNull;

final class PathBuilder {
    PathBuilder() {
    }

    @NotNull
    List<Path> buildPaths(@NotNull List<Node> nodes) {
        if (nodes.size() == 1) {
            return Collections.emptyList();
        }
        Node.Entry entryNode = (Node.Entry)nodes.get(0);
        Path path = new Path(entryNode);
        Node.ConditionalSuccessor nextNode = entryNode.nextNode;
        if (nextNode == null) {
            nextNode = (Node.ConditionalSuccessor)((Object)nodes.get(1));
        }
        nextNode.addToPath(path);
        return this.getAllPathsFromExitNodes(nodes);
    }

    @NotNull
    private List<Path> getAllPathsFromExitNodes(@NotNull List<Node> nodes) {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (Node node : nodes) {
            if (!(node instanceof Node.Exit)) continue;
            paths.addAll(((Node.Exit)node).paths);
        }
        return paths;
    }
}

