/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.paths;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import mockit.coverage.paths.Node;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Path
implements Serializable {
    private static final long serialVersionUID = 8895491272907955543L;
    @NotNull
    final List<Node> nodes = new ArrayList<Node>(4);
    @NotNull
    private final AtomicInteger executionCount = new AtomicInteger();
    private final boolean shadowed;
    @Nullable
    private Path shadowPath;

    Path(@NotNull Node.Entry entryNode) {
        this.shadowed = false;
        this.addNode(entryNode);
    }

    Path(@NotNull Path sharedSubPath, boolean shadowed) {
        this.shadowed = shadowed;
        sharedSubPath.shadowPath = shadowed ? this : null;
        this.nodes.addAll(sharedSubPath.nodes);
    }

    void addNode(@NotNull Node node) {
        this.nodes.add(node);
    }

    boolean countExecutionIfAllNodesWereReached(@NotNull List<Node> nodesReached) {
        boolean allNodesReached = this.nodes.equals(nodesReached);
        if (allNodesReached) {
            this.executionCount.getAndIncrement();
        }
        return allNodesReached;
    }

    public boolean isShadowed() {
        return this.shadowed;
    }

    @NotNull
    public List<Node> getNodes() {
        return this.nodes;
    }

    public int getExecutionCount() {
        int count = this.executionCount.get();
        if (this.shadowPath != null) {
            count += this.shadowPath.executionCount.get();
        }
        return count;
    }

    void addCountFromPreviousTestRun(@NotNull Path previousPath) {
        int currentExecutionCount = this.executionCount.get();
        int previousExecutionCount = previousPath.executionCount.get();
        this.executionCount.set(currentExecutionCount + previousExecutionCount);
    }

    void reset() {
        this.executionCount.set(0);
    }
}

