/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.dataItems;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mockit.coverage.dataItems.FieldData;
import mockit.internal.state.TestRun;
import org.jetbrains.annotations.NotNull;

public final class InstanceFieldData
extends FieldData {
    private static final long serialVersionUID = 6991762113575259754L;
    @NotNull
    private final transient Map<Integer, List<Integer>> testIdsToAssignments = new HashMap<Integer, List<Integer>>();

    void registerAssignment(@NotNull Object instance) {
        Integer instanceId;
        List<Integer> dataForRunningTest = this.getDataForRunningTest();
        if (!dataForRunningTest.contains(instanceId = Integer.valueOf(System.identityHashCode(instance)))) {
            dataForRunningTest.add(instanceId);
        }
        ++this.writeCount;
    }

    void registerRead(@NotNull Object instance) {
        List<Integer> dataForRunningTest = this.getDataForRunningTest();
        Integer instanceId = System.identityHashCode(instance);
        dataForRunningTest.remove(instanceId);
        ++this.readCount;
    }

    @NotNull
    private List<Integer> getDataForRunningTest() {
        int testId = TestRun.getTestId();
        List<Integer> fieldData = this.testIdsToAssignments.get(testId);
        if (fieldData == null) {
            fieldData = new LinkedList<Integer>();
            this.testIdsToAssignments.put(testId, fieldData);
        }
        return fieldData;
    }

    @Override
    void markAsCoveredIfNoUnreadValuesAreLeft() {
        for (List<Integer> unreadInstances : this.testIdsToAssignments.values()) {
            if (!unreadInstances.isEmpty()) continue;
            this.covered = true;
            break;
        }
    }

    @NotNull
    public List<Integer> getOwnerInstancesWithUnreadAssignments() {
        if (this.isCovered()) {
            return Collections.emptyList();
        }
        Collection<List<Integer>> assignments = this.testIdsToAssignments.values();
        return assignments.iterator().next();
    }
}

