/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import mockit.coverage.CallPoint;
import mockit.coverage.data.CoverageData;
import mockit.coverage.data.FileCoverageData;
import mockit.coverage.lines.PerFileLineCoverage;
import org.jetbrains.annotations.NotNull;

public final class TestRun {
    private static boolean terminated;

    private TestRun() {
    }

    public static void lineExecuted(int fileIndex, int line) {
        if (terminated) {
            return;
        }
        CoverageData coverageData = CoverageData.instance();
        PerFileLineCoverage fileData = coverageData.getFileData((int)fileIndex).lineCoverageInfo;
        CallPoint callPoint = null;
        if (coverageData.isWithCallPoints() && fileData.acceptsAdditionalCallPoints(line)) {
            callPoint = CallPoint.create(new Throwable());
        }
        fileData.registerExecution(line, callPoint);
    }

    public static void branchExecuted(int fileIndex, int line, int branchIndex) {
        if (terminated) {
            return;
        }
        CoverageData coverageData = CoverageData.instance();
        PerFileLineCoverage fileData = coverageData.getFileData((int)fileIndex).lineCoverageInfo;
        CallPoint callPoint = null;
        if (coverageData.isWithCallPoints() && fileData.acceptsAdditionalCallPoints(line, branchIndex)) {
            callPoint = CallPoint.create(new Throwable());
        }
        fileData.registerExecution(line, branchIndex, callPoint);
    }

    public static void nodeReached(@NotNull String file, int firstLineInMethodBody, int node) {
        if (terminated) {
            return;
        }
        CoverageData coverageData = CoverageData.instance();
        FileCoverageData fileData = coverageData.getFileData(file);
        fileData.pathCoverageInfo.registerExecution(firstLineInMethodBody, node);
    }

    public static void fieldAssigned(@NotNull String file, @NotNull String classAndFieldNames) {
        if (terminated) {
            return;
        }
        CoverageData coverageData = CoverageData.instance();
        FileCoverageData fileData = coverageData.getFileData(file);
        fileData.dataCoverageInfo.registerAssignmentToStaticField(classAndFieldNames);
    }

    public static void fieldRead(@NotNull String file, @NotNull String classAndFieldNames) {
        if (terminated) {
            return;
        }
        CoverageData coverageData = CoverageData.instance();
        FileCoverageData fileData = coverageData.getFileData(file);
        fileData.dataCoverageInfo.registerReadOfStaticField(classAndFieldNames);
    }

    public static void fieldAssigned(@NotNull Object instance, @NotNull String file, @NotNull String classAndFieldNames) {
        if (terminated) {
            return;
        }
        CoverageData coverageData = CoverageData.instance();
        FileCoverageData fileData = coverageData.getFileData(file);
        fileData.dataCoverageInfo.registerAssignmentToInstanceField(instance, classAndFieldNames);
    }

    public static void fieldRead(@NotNull Object instance, @NotNull String file, @NotNull String classAndFieldNames) {
        if (terminated) {
            return;
        }
        CoverageData coverageData = CoverageData.instance();
        FileCoverageData fileData = coverageData.getFileData(file);
        fileData.dataCoverageInfo.registerReadOfInstanceField(instance, classAndFieldNames);
    }

    static void terminate() {
        terminated = true;
    }
}

