/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import mockit.coverage.Configuration;
import mockit.coverage.CoverageCheck;
import mockit.coverage.OutputFileGenerator;
import mockit.coverage.TestRun;
import mockit.coverage.data.CoverageData;
import mockit.coverage.modification.ClassModification;
import mockit.coverage.standalone.Startup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CodeCoverage
implements ClassFileTransformer {
    private static CodeCoverage instance;
    @NotNull
    private final ClassModification classModification;
    @NotNull
    private final OutputFileGenerator outputGenerator;
    private boolean inactive;

    public static void main(String[] args) {
        OutputFileGenerator generator = CodeCoverage.createOutputFileGenerator(null);
        generator.generateAggregateReportFromInputFiles(args);
    }

    @NotNull
    private static OutputFileGenerator createOutputFileGenerator(@Nullable ClassModification classModification) {
        OutputFileGenerator generator = new OutputFileGenerator(classModification);
        CoverageData.instance().setWithCallPoints(generator.isWithCallPoints());
        return generator;
    }

    public CodeCoverage() {
        this(true, true);
    }

    private CodeCoverage(boolean checkIfAlreadyInitialized, final boolean generateOutputOnShutdown) {
        if (checkIfAlreadyInitialized && Startup.isInitialized()) {
            throw new IllegalStateException("JMockit: coverage tool already initialized");
        }
        if (generateOutputOnShutdown && ("none".equals(Configuration.getProperty("output")) || "none".equals(Configuration.getProperty("classes")) || "none".equals(Configuration.getProperty("metrics")))) {
            throw new IllegalStateException("JMockit: coverage tool disabled");
        }
        this.classModification = new ClassModification();
        this.outputGenerator = CodeCoverage.createOutputFileGenerator(this.classModification);
        instance = this;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                TestRun.terminate();
                if (generateOutputOnShutdown) {
                    if (CodeCoverage.this.outputGenerator.isOutputToBeGenerated()) {
                        CodeCoverage.this.outputGenerator.generate(CodeCoverage.this);
                    }
                    new CoverageCheck().verifyThresholds();
                }
                Startup.instrumentation().removeTransformer(CodeCoverage.this);
            }
        });
    }

    @NotNull
    public static CodeCoverage create(boolean generateOutputOnShutdown) {
        instance = new CodeCoverage(false, generateOutputOnShutdown);
        return instance;
    }

    public static void resetConfiguration() {
        Startup.instrumentation().removeTransformer(instance);
        CoverageData.instance().clear();
        Startup.instrumentation().addTransformer(CodeCoverage.create(false));
    }

    public static void generateOutput(boolean resetState) {
        CodeCoverage.instance.outputGenerator.generate(null);
        if (resetState) {
            CoverageData.instance().reset();
        }
    }

    @Override
    @Nullable
    public byte[] transform(@Nullable ClassLoader loader, @NotNull String internalClassName, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, @NotNull byte[] originalClassfile) {
        if (loader == null || classBeingRedefined != null || protectionDomain == null || this.inactive) {
            return null;
        }
        String className = internalClassName.replace('/', '.');
        return this.classModification.modifyClass(className, protectionDomain, originalClassfile);
    }

    void deactivate() {
        this.inactive = true;
    }
}

