/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.filespecs.aql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.filespecs.aql.PatternParsingUtils;
import org.jfrog.filespecs.aql.RepoPathFile;

class AqlBuildingUtils {
    AqlBuildingUtils() {
    }

    static String buildQuerySuffix(String[] sortBy, String sortOrder, String offset, String limit) {
        StringBuilder query = new StringBuilder();
        if (sortBy != ArrayUtils.EMPTY_STRING_ARRAY) {
            sortOrder = (String)StringUtils.defaultIfEmpty((CharSequence)sortOrder, (CharSequence)"asc");
            query.append(".sort({\"$").append(sortOrder).append("\":");
            query.append("[").append(AqlBuildingUtils.prepareSortFieldsForQuery(sortBy)).append("]})");
        }
        if (StringUtils.isNotBlank((CharSequence)offset)) {
            query.append(".offset(").append(offset).append(")");
        }
        if (StringUtils.isNotBlank((CharSequence)limit)) {
            query.append(".limit(").append(limit).append(")");
        }
        return query.toString();
    }

    private static String prepareSortFieldsForQuery(String[] sortByFields) {
        StringBuilder fields = new StringBuilder();
        int size = sortByFields.length;
        for (int i = 0; i < size; ++i) {
            fields.append("\"").append(sortByFields[i]).append("\"");
            if (i >= size - 1) continue;
            fields.append(",");
        }
        return fields.toString();
    }

    static String buildIncludeQueryPart(String[] sortByFields, String suffix) {
        List<String> fieldsToInclude = AqlBuildingUtils.getQueryReturnFields(sortByFields);
        if (StringUtils.isBlank((CharSequence)suffix)) {
            fieldsToInclude.add("property");
        }
        return ".include(" + StringUtils.join(AqlBuildingUtils.prepareFieldsForQuery(fieldsToInclude), (char)',') + ")";
    }

    private static List<String> getQueryReturnFields(String[] sortByFields) {
        ArrayList<String> includeFields = new ArrayList<String>(Arrays.asList("name", "repo", "path", "actual_md5", "actual_sha1", "size", "type", "modified", "created"));
        for (String field : sortByFields) {
            if (includeFields.indexOf(field) != -1) continue;
            includeFields.add(field);
        }
        return includeFields;
    }

    private static List<String> prepareFieldsForQuery(List<String> fields) {
        fields.forEach(field -> fields.set(fields.indexOf(field), '\"' + field + '\"'));
        return fields;
    }

    static String buildAqlSearchQuery(String searchPattern, String[] exclusions, String[] excludePatterns, boolean recursive, String props) {
        searchPattern = AqlBuildingUtils.prepareSearchPattern(searchPattern);
        List<RepoPathFile> repoPathFileTriples = PatternParsingUtils.createRepoPathFileTriples(searchPattern, recursive);
        boolean includeRoot = StringUtils.countMatches((CharSequence)searchPattern, (CharSequence)"/") < 2;
        int triplesSize = repoPathFileTriples.size();
        String excludeQuery = AqlBuildingUtils.buildExcludeQuery(exclusions, excludePatterns, triplesSize == 0 || recursive, recursive);
        String nePath = AqlBuildingUtils.buildNePathQuery(triplesSize == 0 || includeRoot);
        String json = String.format("{%s\"$or\":[", AqlBuildingUtils.buildPropsQuery(props) + nePath + excludeQuery);
        StringBuilder aqlQuery = new StringBuilder(json);
        aqlQuery.append(AqlBuildingUtils.handleRepoPathFileTriples(repoPathFileTriples, triplesSize)).append("]}");
        return aqlQuery.toString();
    }

    private static String prepareSearchPattern(String pattern) {
        if (pattern.endsWith("/")) {
            pattern = pattern + "*";
        }
        return pattern.replaceAll("[()]", "");
    }

    private static String buildExcludeQuery(String[] exclusions, String[] excludePatterns, boolean useLocalPath, boolean recursive) {
        if (ArrayUtils.isEmpty((Object[])exclusions) && ArrayUtils.isEmpty((Object[])excludePatterns)) {
            return "";
        }
        ArrayList<RepoPathFile> excludeTriples = new ArrayList<RepoPathFile>();
        if (!ArrayUtils.isEmpty((Object[])exclusions)) {
            for (String exclusion : exclusions) {
                excludeTriples.addAll(PatternParsingUtils.createRepoPathFileTriples(AqlBuildingUtils.prepareSearchPattern(exclusion), recursive));
            }
        } else {
            for (String excludePattern : excludePatterns) {
                excludeTriples.addAll(PatternParsingUtils.createPathFilePairs("", AqlBuildingUtils.prepareSearchPattern(excludePattern), recursive));
            }
        }
        String excludeQuery = "";
        for (RepoPathFile excludeTriple : excludeTriples) {
            String excludePath = excludeTriple.getPath();
            if (!useLocalPath && excludePath.equals(".")) {
                excludePath = "*";
            }
            String excludeRepoStr = "";
            if (StringUtils.isNotEmpty((CharSequence)excludeTriple.getRepo())) {
                excludeRepoStr = String.format("\"repo\":{\"$nmatch\":\"%s\"},", excludeTriple.getRepo());
            }
            excludeQuery = excludeQuery + String.format("\"$or\":[{%s\"path\":{\"$nmatch\":\"%s\"},\"name\":{\"$nmatch\":\"%s\"}}],", excludeRepoStr, excludePath, excludeTriple.getFile());
        }
        return excludeQuery;
    }

    private static String buildNePathQuery(boolean includeRoot) {
        return includeRoot ? "" : "\"path\":{\"$ne\":\".\"},";
    }

    private static String buildPropsQuery(String props) {
        if (props == null || props.equals("")) {
            return "";
        }
        String[] propList = props.split(";");
        StringBuilder query = new StringBuilder();
        for (String prop : propList) {
            String[] keyVal = prop.split("=");
            if (keyVal.length != 2) {
                System.out.print("Invalid props pattern: " + prop);
            }
            String key = keyVal[0];
            String value = keyVal[1];
            query.append("\"@").append(key).append("\": {\"$match\" : \"").append(value).append("\"},");
        }
        return query.toString();
    }

    private static String handleRepoPathFileTriples(List<RepoPathFile> repoPathFiles, int repoPathFileSize) {
        String query = "";
        for (int i = 0; i < repoPathFileSize; ++i) {
            query = query + AqlBuildingUtils.buildInnerQuery(repoPathFiles.get(i));
            if (i + 1 >= repoPathFileSize) continue;
            query = query + ",";
        }
        return query;
    }

    private static String buildInnerQuery(RepoPathFile triple) {
        return String.format("{\"$and\":[{\"repo\":%s,\"path\":%s,\"name\":%s}]}", AqlBuildingUtils.getAqlValue(triple.getRepo()), AqlBuildingUtils.getAqlValue(triple.getPath()), AqlBuildingUtils.getAqlValue(triple.getFile()));
    }

    private static String getAqlValue(String value) {
        String aqlValuePattern = value.contains("*") ? "{\"$match\":\"%s\"}" : "\"%s\"";
        return String.format(aqlValuePattern, value);
    }
}

