/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.filespecs;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.filespecs.FileSpec;
import org.jfrog.filespecs.entities.FilesGroup;

public class FileSpecsParsingUtils {
    public static void pathToUnixFormat(FileSpec fileSpec) {
        for (FilesGroup filesGroup : fileSpec.getFiles()) {
            String separator;
            String string = separator = StringUtils.equalsIgnoreCase((String)filesGroup.getRegexp(), (String)Boolean.TRUE.toString()) ? "\\\\\\\\" : "\\\\";
            if (filesGroup.getTarget() != null) {
                filesGroup.setTarget(filesGroup.getTarget().replaceAll("\\\\", "/"));
            }
            if (filesGroup.getPattern() != null) {
                filesGroup.setPattern(filesGroup.getPattern().replaceAll(separator, "/"));
            }
            if (ArrayUtils.isEmpty((Object[])filesGroup.getExclusions())) continue;
            filesGroup.setExclusions(FileSpecsParsingUtils.fixExclusionsPathToUnixFormat(filesGroup.getExclusions(), separator));
        }
    }

    private static String[] fixExclusionsPathToUnixFormat(String[] exclusions, String separator) {
        for (int i = 0; i < exclusions.length; ++i) {
            String exclusion = exclusions[i];
            exclusions[i] = exclusion.replaceAll(separator, "/");
        }
        return exclusions;
    }
}

