/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.plugin.internal.device;

import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceProductOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.plugin.core.AbstractPlugin;
import org.jetlinks.plugin.core.PluginContext;
import org.jetlinks.plugin.core.PluginType;
import org.jetlinks.plugin.internal.InternalPluginType;
import org.jetlinks.plugin.internal.device.Device;
import org.jetlinks.plugin.internal.device.PluginDeviceGatewayService;
import org.jetlinks.plugin.internal.device.PluginDeviceManager;
import org.jetlinks.plugin.internal.device.command.GetDeviceConfigMetadataCommand;
import org.jetlinks.plugin.internal.device.command.GetProductConfigMetadataCommand;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class DeviceGatewayPlugin
extends AbstractPlugin {
    private final PluginDeviceGatewayService gatewayService;
    private final PluginDeviceManager deviceManager;
    protected final DeviceRegistry registry;

    public DeviceGatewayPlugin(String id, PluginContext context) {
        super(id, context);
        this.gatewayService = (PluginDeviceGatewayService)context.services().getServiceNow(PluginDeviceGatewayService.class);
        this.registry = (DeviceRegistry)context.services().getServiceNow(DeviceRegistry.class);
        this.deviceManager = (PluginDeviceManager)context.services().getServiceNow(PluginDeviceManager.class);
        this.registerHandler(GetDeviceConfigMetadataCommand.createHandler(cmd -> this.getDeviceConfigMetadata(cmd.getDeviceId())));
        this.registerHandler(GetProductConfigMetadataCommand.createHandler(cmd -> this.getProductConfigMetadata(cmd.getProductId())));
    }

    public Publisher<? extends DeviceMessage> execute(DeviceMessage message) {
        return Flux.empty();
    }

    public Publisher<? extends DeviceMessage> execute(String productId, DeviceOperator device, DeviceMessage message) {
        return this.execute(message);
    }

    public Mono<ConfigMetadata> getProductConfigMetadata(String productId) {
        return Mono.empty();
    }

    public Mono<ConfigMetadata> getDeviceConfigMetadata(String deviceId) {
        return Mono.empty();
    }

    protected final Mono<Void> handleMessage(DeviceMessage message) {
        return this.gatewayService.handleMessage(this, message);
    }

    public Mono<Byte> getDeviceState(DeviceOperator device) {
        return Mono.empty();
    }

    @Deprecated
    public Flux<Device> scanDevices(String productId) {
        return Flux.empty();
    }

    protected final Flux<DeviceOperator> getPlatformDevices() {
        return this.deviceManager.getDevices(this);
    }

    protected final Flux<DeviceOperator> getPlatformDevices(String productId) {
        return this.deviceManager.getDevices(this, productId);
    }

    public Mono<Void> doOnDeviceRegister(DeviceOperator device) {
        return Mono.empty();
    }

    public Mono<Void> doOnDeviceUnregister(DeviceOperator device) {
        return Mono.empty();
    }

    public Mono<Void> doOnProductRegister(DeviceProductOperator product) {
        return Mono.empty();
    }

    public final PluginType getType() {
        return InternalPluginType.deviceGateway;
    }
}

