/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.builder.VarBinding;
import jetbrains.datalore.plot.builder.assemble.PosProvider;
import jetbrains.datalore.plot.builder.sampling.Sampling;
import jetbrains.datalore.plot.config.Option;
import jetbrains.datalore.plot.config.OptionsAccessor;
import jetbrains.datalore.plot.config.PosConfig;
import jetbrains.datalore.plot.config.SamplingConfig;
import jetbrains.datalore.plot.config.aes.AesOptionConversion;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t2\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\r2\u0006\u0010\u000e\u001a\u00020\u000fJ0\u0010\u0010\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\rJ\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0015J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00042\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0019\u00a8\u0006\u001b"}, d2={"Ljetbrains/datalore/plot/config/LayerConfigUtil;", "", "()V", "createBindings", "", "Ljetbrains/datalore/plot/builder/VarBinding;", "data", "Ljetbrains/datalore/plot/base/DataFrame;", "mapping", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "consumedAesSet", "", "clientSide", "", "initConstants", "layerConfig", "Ljetbrains/datalore/plot/config/OptionsAccessor;", "exclude", "initPositionAdjustments", "Ljetbrains/datalore/plot/builder/assemble/PosProvider;", "opts", "defaultPos", "initSampling", "Ljetbrains/datalore/plot/builder/sampling/Sampling;", "defaultSampling", "plot-config-portable"})
public final class LayerConfigUtil {
    @NotNull
    public static final LayerConfigUtil INSTANCE = new LayerConfigUtil();

    private LayerConfigUtil() {
    }

    @NotNull
    public final PosProvider initPositionAdjustments(@NotNull OptionsAccessor opts, @NotNull PosProvider defaultPos) {
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        Intrinsics.checkNotNullParameter((Object)defaultPos, (String)"defaultPos");
        if (opts.has("position")) {
            Object object = opts.get("position");
            Intrinsics.checkNotNull((Object)object);
            PosConfig posConfig = PosConfig.Companion.create(object);
            return posConfig.getPos();
        }
        return defaultPos;
    }

    @NotNull
    public final Map<Aes<?>, Object> initConstants(@NotNull OptionsAccessor layerConfig, @NotNull Set<? extends Aes<?>> exclude) {
        Intrinsics.checkNotNullParameter((Object)layerConfig, (String)"layerConfig");
        Intrinsics.checkNotNullParameter(exclude, (String)"exclude");
        HashMap result = new HashMap();
        for (String option : Option.Mapping.INSTANCE.getREAL_AES_OPTION_NAMES()) {
            Object object;
            Aes<?> aes = Option.Mapping.INSTANCE.toAes(option);
            if (exclude.contains(aes) || (object = layerConfig.get(option)) == null) continue;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object $this$initConstants_u24lambda_u2d0 = object2;
            boolean bl3 = false;
            Object object3 = AesOptionConversion.INSTANCE.apply(aes, $this$initConstants_u24lambda_u2d0);
            if (object3 == null) {
                throw new IllegalArgumentException("Can't convert to '" + option + "' value: " + $this$initConstants_u24lambda_u2d0);
            }
            Object constantValue = object3;
            object3 = result;
            boolean bl4 = false;
            object3.put(aes, constantValue);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VarBinding> createBindings(@NotNull DataFrame data, @Nullable Map<Aes<?>, DataFrame.Variable> mapping, @NotNull Set<? extends Aes<?>> consumedAesSet, boolean clientSide) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(consumedAesSet, (String)"consumedAesSet");
        ArrayList<VarBinding> result = new ArrayList<VarBinding>();
        if (mapping != null) {
            HashSet aesSet = new HashSet(consumedAesSet);
            aesSet.retainAll((Collection)mapping.keySet());
            for (Aes aes : aesSet) {
                VarBinding varBinding;
                DataFrame.Variable variable;
                Intrinsics.checkNotNull((Object)mapping.get(aes));
                if (data.has(variable)) {
                    Intrinsics.checkNotNullExpressionValue((Object)aes, (String)"aes");
                    varBinding = new VarBinding(variable, aes);
                } else if (variable.isStat() && !clientSide) {
                    Intrinsics.checkNotNullExpressionValue((Object)aes, (String)"aes");
                    varBinding = new VarBinding(variable, aes);
                } else {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = data.variables();
                    StringBuilder stringBuilder = new StringBuilder().append("Undefined variable: '").append(variable.getName()).append("'. Variables in data frame: ");
                    boolean $i$f$map = false;
                    void var13_14 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        DataFrame.Variable variable2 = (DataFrame.Variable)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        String string = '\'' + it.getName() + '\'';
                        collection.add(string);
                    }
                    collection = (List)destination$iv$iv;
                    String string = stringBuilder.append(collection).toString();
                    throw new IllegalArgumentException(string);
                }
                VarBinding binding = varBinding;
                result.add(binding);
            }
        }
        return result;
    }

    @NotNull
    public final List<Sampling> initSampling(@NotNull OptionsAccessor opts, @NotNull Sampling defaultSampling) {
        List<Sampling> list2;
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        Intrinsics.checkNotNullParameter((Object)defaultSampling, (String)"defaultSampling");
        if (opts.has("sampling")) {
            Object object = opts.get("sampling");
            Intrinsics.checkNotNull((Object)object);
            list2 = SamplingConfig.INSTANCE.create(object);
        } else {
            list2 = CollectionsKt.listOf((Object)defaultSampling);
        }
        return list2;
    }
}

