/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.scale.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.base.values.HSV;
import jetbrains.datalore.plot.base.scale.MapperUtil;
import jetbrains.datalore.plot.builder.scale.GuideMapper;
import jetbrains.datalore.plot.builder.scale.mapper.ColorMapper;
import jetbrains.datalore.plot.builder.scale.mapper.GuideMappers;
import jetbrains.datalore.plot.builder.scale.provider.MapperProviderBase;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\b&\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0018\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f0\u000bH\u0004J*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0004\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/builder/scale/provider/HSVColorMapperProvider;", "Ljetbrains/datalore/plot/builder/scale/provider/MapperProviderBase;", "Ljetbrains/datalore/base/values/Color;", "naValue", "(Ljetbrains/datalore/base/values/Color;)V", "createContinuousMapper", "Ljetbrains/datalore/plot/builder/scale/GuideMapper;", "domain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "hsvIntervals", "", "Lkotlin/Pair;", "Ljetbrains/datalore/base/values/HSV;", "createDiscreteMapper", "domainValues", "", "fromHSV", "toHSV", "Companion", "plot-builder-portable"})
public abstract class HSVColorMapperProvider
extends MapperProviderBase<Color> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public HSVColorMapperProvider(@NotNull Color naValue) {
        Intrinsics.checkNotNullParameter((Object)naValue, (String)"naValue");
        super(naValue);
    }

    @NotNull
    protected final GuideMapper<Color> createDiscreteMapper(@NotNull Collection<?> domainValues, @NotNull HSV fromHSV, @NotNull HSV toHSV) {
        Intrinsics.checkNotNullParameter(domainValues, (String)"domainValues");
        Intrinsics.checkNotNullParameter((Object)fromHSV, (String)"fromHSV");
        Intrinsics.checkNotNullParameter((Object)toHSV, (String)"toHSV");
        Map domainValuesAsNumbers = MapperUtil.INSTANCE.mapDiscreteDomainValuesToNumbers(domainValues);
        ClosedRange mapperDomain = SeriesUtil.INSTANCE.ensureApplicableRange(SeriesUtil.INSTANCE.range((Iterable)domainValuesAsNumbers.values()));
        double newFromHue = fromHSV.getH();
        double newToHue = toHSV.getH();
        if (domainValues.size() > 1) {
            double d = toHSV.getH() % (double)360 - fromHSV.getH() % (double)360;
            boolean bl = false;
            double hueDiff = Math.abs(d);
            double step = (toHSV.getH() - fromHSV.getH()) / (double)domainValues.size();
            bl = false;
            if (hueDiff < Math.abs(step) / (double)2) {
                newFromHue = fromHSV.getH() + step / (double)2;
                newToHue = toHSV.getH() - step / (double)2;
            }
        }
        Function1<Double, Color> gradient = ColorMapper.INSTANCE.gradientHSV((ClosedRange<Double>)mapperDomain, new HSV(newFromHue, fromHSV.getS(), fromHSV.getV()), new HSV(newToHue, toHSV.getS(), toHSV.getV()), false, (Color)this.getNaValue());
        return GuideMappers.INSTANCE.asNotContinuous(gradient);
    }

    @NotNull
    protected final GuideMapper<Color> createContinuousMapper(@NotNull ClosedRange<Double> domain, @NotNull List<Pair<HSV, HSV>> hsvIntervals) {
        Function1<Double, Color> function1;
        Intrinsics.checkNotNullParameter(domain, (String)"domain");
        Intrinsics.checkNotNullParameter(hsvIntervals, (String)"hsvIntervals");
        int n = hsvIntervals.size();
        switch (n) {
            case 0: {
                throw new IllegalArgumentException("Empty HSV intervals.");
            }
            case 1: {
                function1 = ColorMapper.INSTANCE.gradientHSV(domain, (HSV)hsvIntervals.get(0).getFirst(), (HSV)hsvIntervals.get(0).getSecond(), false, (Color)this.getNaValue());
                break;
            }
            default: {
                function1 = HSVColorMapperProvider.Companion.createCompositeColorMapper((ClosedRange<Double>)domain, hsvIntervals, false, (Color)this.getNaValue());
            }
        }
        Function1<Double, Color> gradientMapper = function1;
        return GuideMappers.INSTANCE.asContinuous(gradientMapper);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jf\u0010\u0003\u001a(\u0012$\u0012\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\t0\b0\u00050\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002JN\u0010\u0010\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002J<\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00050\u0004H\u0002\u00a8\u0006\u0012"}, d2={"Ljetbrains/datalore/plot/builder/scale/provider/HSVColorMapperProvider$Companion;", "", "()V", "createColorMappersPerSubDomain", "", "Lkotlin/Pair;", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "Lkotlin/Function1;", "Ljetbrains/datalore/base/values/Color;", "domain", "hsvIntervals", "Ljetbrains/datalore/base/values/HSV;", "autoHueDirection", "", "naColor", "createCompositeColorMapper", "splitContinuousDomain", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final Function1<Double, Color> createCompositeColorMapper(ClosedRange<Double> domain, List<Pair<HSV, HSV>> hsvIntervals, boolean autoHueDirection, Color naColor) {
            List<Pair<ClosedRange<Double>, Function1<Double, Color>>> colorMappersPerSubDomain = this.createColorMappersPerSubDomain(domain, hsvIntervals, autoHueDirection, naColor);
            return (Function1)new Function1<Double, Color>(naColor, colorMappersPerSubDomain){
                final /* synthetic */ Color $naColor;
                final /* synthetic */ List<Pair<ClosedRange<Double>, Function1<Double, Color>>> $colorMappersPerSubDomain;
                {
                    this.$naColor = $naColor;
                    this.$colorMappersPerSubDomain = $colorMappersPerSubDomain;
                    super(1);
                }

                @NotNull
                public final Color invoke(@Nullable Double v) {
                    Object object;
                    if (v == null) {
                        object = this.$naColor;
                    } else {
                        Object v1;
                        Iterable iterable;
                        block3: {
                            iterable = this.$colorMappersPerSubDomain;
                            boolean bl = false;
                            Iterable iterable2 = iterable;
                            boolean bl2 = false;
                            for (T t : iterable2) {
                                Pair it = (Pair)t;
                                boolean bl3 = false;
                                if (!((ClosedRange)it.getFirst()).contains((Comparable)v)) continue;
                                v1 = t;
                                break block3;
                            }
                            v1 = null;
                        }
                        Pair pair = v1;
                        Function1 mapper2 = pair == null ? null : (Function1)pair.getSecond();
                        iterable = mapper2;
                        pair = iterable == null ? null : (Color)iterable.invoke(v);
                        object = pair == null ? this.$naColor : pair;
                    }
                    return object;
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        private final List<Pair<ClosedRange<Double>, Function1<Double, Color>>> createColorMappersPerSubDomain(ClosedRange<Double> domain, List<Pair<HSV, HSV>> hsvIntervals, boolean autoHueDirection, Color naColor) {
            void $this$mapTo$iv$iv;
            List<ClosedRange<Double>> subDomains = this.splitContinuousDomain(domain, hsvIntervals);
            Iterable $this$map$iv = CollectionsKt.zip((Iterable)subDomains, (Iterable)hsvIntervals);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ClosedRange domain2 = (ClosedRange)it.getFirst();
                Pair hsvInterval = (Pair)it.getSecond();
                Pair pair2 = new Pair((Object)domain2, ColorMapper.INSTANCE.gradientHSV((ClosedRange<Double>)domain2, (HSV)hsvInterval.getFirst(), (HSV)hsvInterval.getSecond(), autoHueDirection, naColor));
                collection.add(pair2);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<ClosedRange<Double>> splitContinuousDomain(ClosedRange<Double> domain, List<Pair<HSV, HSV>> hsvIntervals) {
            Object object;
            void $this$mapTo$iv$iv;
            double domainSize = ((Number)((Object)domain.getUpperEnd())).doubleValue() - ((Number)((Object)domain.getLowerEnd())).doubleValue();
            Iterable $this$map$iv = hsvIntervals;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                double d = ((HSV)it.getFirst()).getH() - ((HSV)it.getSecond()).getH();
                boolean bl2 = false;
                Double d2 = Math.abs(d);
                collection.add(d2);
            }
            List hueIntervalSizeList = (List)destination$iv$iv;
            double hueIntervalsTotalSize = CollectionsKt.sumOfDouble((Iterable)hueIntervalSizeList);
            double domainToHueIntevalRatio = domainSize / hueIntervalsTotalSize;
            ArrayList<ClosedRange> subDomains = new ArrayList<ClosedRange>();
            double lowerEnd = ((Number)((Object)domain.getLowerEnd())).doubleValue();
            object = hueIntervalSizeList.iterator();
            while (object.hasNext()) {
                double hueIntervalSize = ((Number)object.next()).doubleValue();
                double upperEnd = lowerEnd + hueIntervalSize * domainToHueIntevalRatio;
                subDomains.add(new ClosedRange((Comparable)Double.valueOf(lowerEnd), (Comparable)Double.valueOf(upperEnd)));
                lowerEnd = upperEnd;
            }
            return subDomains;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

