/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.assemble;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.gcommon.collect.Iterables;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.aes.AestheticsDefaults;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.scale.ScaleUtil;
import jetbrains.datalore.plot.builder.GeomLayer;
import jetbrains.datalore.plot.builder.PlotUtil;
import jetbrains.datalore.plot.builder.VarBinding;
import jetbrains.datalore.plot.builder.assemble.ColorBarAssembler;
import jetbrains.datalore.plot.builder.assemble.ColorBarOptions;
import jetbrains.datalore.plot.builder.assemble.GuideOptions;
import jetbrains.datalore.plot.builder.assemble.LegendAssembler;
import jetbrains.datalore.plot.builder.assemble.PlotFacets;
import jetbrains.datalore.plot.builder.assemble.PlotGuidesAssemblerUtil;
import jetbrains.datalore.plot.builder.assemble.StitchedPlotLayers;
import jetbrains.datalore.plot.builder.assemble.TypedScaleMap;
import jetbrains.datalore.plot.builder.layout.FacetGridPlotLayout;
import jetbrains.datalore.plot.builder.layout.LegendBoxInfo;
import jetbrains.datalore.plot.builder.layout.PlotLayout;
import jetbrains.datalore.plot.builder.layout.SingleTilePlotLayout;
import jetbrains.datalore.plot.builder.layout.TileLayout;
import jetbrains.datalore.plot.builder.theme.FacetsTheme;
import jetbrains.datalore.plot.builder.theme.LegendTheme;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001(B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\bJZ\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b2\u001c\u0010\u000e\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u000f2\u0016\u0010\u0011\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0004\u0012\u00020\u00120\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J@\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b2\u0016\u0010\u0011\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0004\u0012\u00020\u00120\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJB\u0010\u001e\u001a\u00020\u001f2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u00102\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u001c\u0010\"\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050#H\u0002J0\u0010$\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0002J.\u0010$\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00060'2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0002\u00a8\u0006)"}, d2={"Ljetbrains/datalore/plot/builder/assemble/PlotAssemblerUtil;", "", "()V", "computePlotDryRunXYRanges", "Lkotlin/Pair;", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "layersByTile", "", "Ljetbrains/datalore/plot/builder/GeomLayer;", "createLegends", "Ljetbrains/datalore/plot/builder/layout/LegendBoxInfo;", "stitchedLayersList", "Ljetbrains/datalore/plot/builder/assemble/StitchedPlotLayers;", "transformedDomainByAes", "", "Ljetbrains/datalore/plot/base/Aes;", "guideOptionsMap", "Ljetbrains/datalore/plot/builder/assemble/GuideOptions;", "theme", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "layersByPanel", "createPlotLayout", "Ljetbrains/datalore/plot/builder/layout/PlotLayout;", "tileLayout", "Ljetbrains/datalore/plot/builder/layout/TileLayout;", "facets", "Ljetbrains/datalore/plot/builder/assemble/PlotFacets;", "facetsTheme", "Ljetbrains/datalore/plot/builder/theme/FacetsTheme;", "updateAesRangeMap", "", "aes", "range", "rangeByAes", "", "updateRange", "wasRange", "values", "", "RangeUtil", "plot-builder-portable"})
public final class PlotAssemblerUtil {
    @NotNull
    public static final PlotAssemblerUtil INSTANCE = new PlotAssemblerUtil();

    private PlotAssemblerUtil() {
    }

    private final void updateAesRangeMap(Aes<?> aes, ClosedRange<Double> range, Map<Aes<?>, ClosedRange<Double>> rangeByAes) {
        ClosedRange range2 = range;
        if (range2 != null) {
            ClosedRange<Double> wasRange = rangeByAes.get(aes);
            if (wasRange != null) {
                range2 = wasRange.span(range2);
            }
            Map<Aes<?>, ClosedRange<Double>> map2 = rangeByAes;
            boolean bl = false;
            map2.put(aes, (ClosedRange<Double>)range2);
        }
    }

    private final ClosedRange<Double> updateRange(ClosedRange<Double> range, ClosedRange<Double> wasRange) {
        ClosedRange range2 = range;
        if (range2 != null) {
            if (wasRange != null) {
                range2 = wasRange.span(range2);
            }
            return range2;
        }
        return wasRange;
    }

    private final ClosedRange<Double> updateRange(Iterable<Double> values, ClosedRange<Double> wasRange) {
        if (!Iterables.INSTANCE.isEmpty(values)) {
            ClosedRange newRange = ClosedRange.Companion.encloseAll(values);
            if (wasRange != null) {
                newRange = wasRange.span(newRange);
            }
            return newRange;
        }
        return wasRange;
    }

    @NotNull
    public final List<LegendBoxInfo> createLegends(@NotNull List<? extends List<? extends GeomLayer>> layersByPanel, @NotNull Map<Aes<?>, ? extends GuideOptions> guideOptionsMap, @NotNull LegendTheme theme) {
        Intrinsics.checkNotNullParameter(layersByPanel, (String)"layersByPanel");
        Intrinsics.checkNotNullParameter(guideOptionsMap, (String)"guideOptionsMap");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        int planeCount = 0;
        Collection collection = layersByPanel;
        int n = 0;
        if (!collection.isEmpty()) {
            planeCount = layersByPanel.get(0).size();
        }
        ArrayList<StitchedPlotLayers> stitchedLayersList = new ArrayList<StitchedPlotLayers>();
        n = 0;
        if (n < planeCount) {
            do {
                int i = n++;
                ArrayList<GeomLayer> layersOnPlane = new ArrayList<GeomLayer>();
                for (List<? extends GeomLayer> iterator : layersByPanel) {
                    layersOnPlane.add(iterator.get(i));
                }
                stitchedLayersList.add(new StitchedPlotLayers((List<? extends GeomLayer>)layersOnPlane));
            } while (n < planeCount);
        }
        HashMap transformedDomainByAes = new HashMap();
        for (StitchedPlotLayers stitchedPlotLayers : stitchedLayersList) {
            Intrinsics.checkNotNullExpressionValue((Object)stitchedPlotLayers, (String)"stitchedPlotLayers");
            Map<Aes<?>, ClosedRange<Double>> layerTransformedDomainByAes = PlotGuidesAssemblerUtil.INSTANCE.guideTransformedDomainByAes(stitchedPlotLayers, guideOptionsMap);
            Object object = layerTransformedDomainByAes;
            boolean bl = false;
            Iterator<Map.Entry<Aes<?>, ClosedRange<Double>>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = object = iterator.next();
                boolean bl2 = false;
                Aes aes = (Aes)object2.getKey();
                Object object3 = object;
                boolean bl3 = false;
                ClosedRange transformedDomain = (ClosedRange)object3.getValue();
                this.updateAesRangeMap(aes, (ClosedRange<Double>)transformedDomain, transformedDomainByAes);
            }
        }
        return this.createLegends((List<StitchedPlotLayers>)stitchedLayersList, transformedDomainByAes, guideOptionsMap, theme);
    }

    /*
     * WARNING - void declaration
     */
    private final List<LegendBoxInfo> createLegends(List<StitchedPlotLayers> stitchedLayersList, Map<Aes<?>, ? extends ClosedRange<Double>> transformedDomainByAes, Map<Aes<?>, ? extends GuideOptions> guideOptionsMap, LegendTheme theme) {
        LegendBoxInfo boxInfo;
        LinkedHashMap legendAssemblerByTitle = new LinkedHashMap();
        LinkedHashMap colorBarAssemblerByTitle = new LinkedHashMap();
        for (StitchedPlotLayers stitchedLayers : stitchedLayersList) {
            Object binding;
            HashMap layerConstantByAes = new HashMap();
            for (Aes<?> aes : stitchedLayers.renderedAes()) {
                Object obj;
                if (!stitchedLayers.hasConstant(aes)) continue;
                Iterator<Aes<?>> iterator = layerConstantByAes;
                Intrinsics.checkNotNull(stitchedLayers.getConstant(aes));
                boolean bl = false;
                iterator.put(aes, obj);
            }
            LinkedHashMap layerBindingsByScaleName = new LinkedHashMap();
            List<Aes<?>> aesList = PlotGuidesAssemblerUtil.INSTANCE.mappedRenderedAesToCreateGuides(stitchedLayers, guideOptionsMap);
            for (Aes aes : aesList) {
                Object object;
                Object object2;
                boolean colorBar = false;
                binding = stitchedLayers.getBinding(aes);
                Scale<?> scale = stitchedLayers.getScale(aes);
                String scaleName = scale.getName();
                if (guideOptionsMap.containsKey(aes)) {
                    GuideOptions guideOptions = guideOptionsMap.get(aes);
                    if (guideOptions instanceof ColorBarOptions) {
                        PlotGuidesAssemblerUtil.INSTANCE.checkFitsColorBar(((VarBinding)binding).getAes(), scale);
                        colorBar = true;
                        Scale<?> colorScale2 = scale;
                        object2 = colorBarAssemblerByTitle;
                        ColorBarAssembler colorBarAssembler = PlotGuidesAssemblerUtil.INSTANCE.createColorBarAssembler(scaleName, ((VarBinding)binding).getAes(), transformedDomainByAes, colorScale2, (ColorBarOptions)guideOptions, theme);
                        boolean bl = false;
                        object2.put(scaleName, colorBarAssembler);
                    }
                } else if (PlotGuidesAssemblerUtil.INSTANCE.fitsColorBar(((VarBinding)binding).getAes(), scale)) {
                    colorBar = true;
                    Scale<?> colorScale = scale;
                    Map colorScale2 = colorBarAssemblerByTitle;
                    object2 = PlotGuidesAssemblerUtil.INSTANCE.createColorBarAssembler(scaleName, ((VarBinding)binding).getAes(), transformedDomainByAes, colorScale, null, theme);
                    boolean bl = false;
                    colorScale2.put(scaleName, object2);
                }
                if (colorBar) continue;
                Map $this$getOrPut$iv = layerBindingsByScaleName;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(scaleName);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(scaleName, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(binding);
            }
            for (String string : layerBindingsByScaleName.keySet()) {
                Object object;
                void $this$getOrPut$iv;
                binding = legendAssemblerByTitle;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scaleName");
                String key$iv = string;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    LegendAssembler answer$iv = new LegendAssembler(string, guideOptionsMap, theme);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                LegendAssembler legendAssembler = (LegendAssembler)object;
                Object v = layerBindingsByScaleName.get(string);
                Intrinsics.checkNotNull(v);
                key$iv = v;
                Intrinsics.checkNotNullExpressionValue((Object)key$iv, (String)"layerBindingsByScaleName[scaleName]!!");
                List varBindings = (List)((Object)key$iv);
                LegendKeyElementFactory legendKeyFactory = stitchedLayers.getLegendKeyElementFactory();
                AestheticsDefaults aestheticsDefaults = stitchedLayers.getAestheticsDefaults();
                legendAssembler.addLayer(legendKeyFactory, varBindings, layerConstantByAes, aestheticsDefaults, stitchedLayers.getScaleMap(), transformedDomainByAes);
            }
        }
        ArrayList<LegendBoxInfo> legendBoxInfos = new ArrayList<LegendBoxInfo>();
        for (String legendTitle : colorBarAssemblerByTitle.keySet()) {
            Object v = colorBarAssemblerByTitle.get(legendTitle);
            Intrinsics.checkNotNull(v);
            boxInfo = ((ColorBarAssembler)v).createColorBar();
            if (boxInfo.isEmpty()) continue;
            legendBoxInfos.add(boxInfo);
        }
        for (String legendTitle : legendAssemblerByTitle.keySet()) {
            Object v = legendAssemblerByTitle.get(legendTitle);
            Intrinsics.checkNotNull(v);
            boxInfo = ((LegendAssembler)v).createLegend();
            if (boxInfo.isEmpty()) continue;
            legendBoxInfos.add(boxInfo);
        }
        return legendBoxInfos;
    }

    @NotNull
    public final PlotLayout createPlotLayout(@NotNull TileLayout tileLayout, @NotNull PlotFacets facets, @NotNull FacetsTheme facetsTheme) {
        Intrinsics.checkNotNullParameter((Object)tileLayout, (String)"tileLayout");
        Intrinsics.checkNotNullParameter((Object)facets, (String)"facets");
        Intrinsics.checkNotNullParameter((Object)facetsTheme, (String)"facetsTheme");
        if (!facets.isDefined()) {
            return new SingleTilePlotLayout(tileLayout);
        }
        return new FacetGridPlotLayout(facets, tileLayout, facetsTheme.showStrip());
    }

    @NotNull
    public final Pair<ClosedRange<Double>, ClosedRange<Double>> computePlotDryRunXYRanges(@NotNull List<? extends List<? extends GeomLayer>> layersByTile) {
        Intrinsics.checkNotNullParameter(layersByTile, (String)"layersByTile");
        HashMap dryRunAestheticsByTileLayer = new HashMap();
        for (List<? extends GeomLayer> list : layersByTile) {
            for (GeomLayer geomLayer : list) {
                Aesthetics aesthetics = PlotUtil.INSTANCE.createLayerDryRunAesthetics(geomLayer);
                Map map2 = dryRunAestheticsByTileLayer;
                boolean bl = false;
                map2.put(geomLayer, aesthetics);
            }
        }
        List<? extends GeomLayer> layers0 = layersByTile.get(0);
        TypedScaleMap typedScaleMap = layers0.get(0).getScaleMap();
        Scale xScale = typedScaleMap.get(Aes.Companion.getX());
        Scale scale = typedScaleMap.get(Aes.Companion.getY());
        ClosedRange<Double> xInitialRange = RangeUtil.INSTANCE.initialRange(xScale);
        ClosedRange<Double> yInitialRange = RangeUtil.INSTANCE.initialRange(scale);
        ClosedRange<Double> xRangeOverall = null;
        ClosedRange<Double> yRangeOverall = null;
        for (List<? extends GeomLayer> list : layersByTile) {
            for (GeomLayer geomLayer : list) {
                Aesthetics aesthetics = (Aesthetics)MapsKt.getValue((Map)dryRunAestheticsByTileLayer, (Object)geomLayer);
                Pair<ClosedRange<Double>, ClosedRange<Double>> xyRanges = PlotUtil.INSTANCE.computeLayerDryRunXYRanges(geomLayer, aesthetics);
                ClosedRange<Double> xRangeLayer = this.updateRange(xInitialRange, (ClosedRange<Double>)((ClosedRange)xyRanges.getFirst()));
                ClosedRange<Double> yRangeLayer = this.updateRange(yInitialRange, (ClosedRange<Double>)((ClosedRange)xyRanges.getSecond()));
                xRangeOverall = this.updateRange(xRangeLayer, xRangeOverall);
                yRangeOverall = this.updateRange(yRangeLayer, yRangeOverall);
            }
        }
        xRangeOverall = RangeUtil.INSTANCE.expandRange(xRangeOverall, (Aes<Double>)Aes.Companion.getX(), xScale, layers0);
        yRangeOverall = RangeUtil.INSTANCE.expandRange(yRangeOverall, (Aes<Double>)Aes.Companion.getY(), scale, layers0);
        xRangeOverall = SeriesUtil.INSTANCE.ensureApplicableRange(xRangeOverall);
        yRangeOverall = SeriesUtil.INSTANCE.ensureApplicableRange(yRangeOverall);
        return new Pair((Object)xRangeOverall, (Object)yRangeOverall);
    }

    public static final /* synthetic */ ClosedRange access$updateRange(PlotAssemblerUtil $this, Iterable values, ClosedRange wasRange) {
        return $this.updateRange(values, (ClosedRange<Double>)wasRange);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u001c\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u00a8\u0006\u000f"}, d2={"Ljetbrains/datalore/plot/builder/assemble/PlotAssemblerUtil$RangeUtil;", "", "()V", "expandRange", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "range", "aes", "Ljetbrains/datalore/plot/base/Aes;", "scale", "Ljetbrains/datalore/plot/base/Scale;", "layers", "", "Ljetbrains/datalore/plot/builder/GeomLayer;", "initialRange", "plot-builder-portable"})
    private static final class RangeUtil {
        @NotNull
        public static final RangeUtil INSTANCE = new RangeUtil();

        private RangeUtil() {
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final ClosedRange<Double> initialRange(@NotNull Scale<Double> scale) {
            block4: {
                Intrinsics.checkNotNullParameter(scale, (String)"scale");
                initialRange = null;
                if (!scale.isContinuousDomain()) break block4;
                var3_3 = TuplesKt.toList((Pair)ScaleUtil.INSTANCE.transformedDefinedLimits(scale));
                var19_4 = PlotAssemblerUtil.INSTANCE;
                $i$f$filter = false;
                var5_6 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = ((Number)element$iv$iv).doubleValue();
                    $i$a$-filter-PlotAssemblerUtil$RangeUtil$initialRange$1 = false;
                    var13_13 = it;
                    var15_14 = false;
                    var16_15 = var13_13;
                    var18_16 = false;
                    if (Double.isInfinite(var16_15)) ** GOTO lbl-1000
                    var16_15 = var13_13;
                    var18_16 = false;
                    if (!Double.isNaN(var16_15)) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                    if (!v0) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                var20_17 = (List)destination$iv$iv;
                initialRange = PlotAssemblerUtil.access$updateRange(var19_4, var20_17, initialRange);
            }
            if (scale.hasBreaks()) {
                scaleBreaks = scale.getScaleBreaks();
                initialRange = PlotAssemblerUtil.access$updateRange(PlotAssemblerUtil.INSTANCE, scaleBreaks.getTransformedValues(), initialRange);
            }
            return initialRange;
        }

        @Nullable
        public final ClosedRange<Double> expandRange(@Nullable ClosedRange<Double> range, @NotNull Aes<Double> aes, @NotNull Scale<?> scale, @NotNull List<? extends GeomLayer> layers) {
            ClosedRange closedRange;
            boolean includeZero;
            boolean bl;
            block7: {
                Intrinsics.checkNotNullParameter(aes, (String)"aes");
                Intrinsics.checkNotNullParameter(scale, (String)"scale");
                Intrinsics.checkNotNullParameter(layers, (String)"layers");
                Iterable $this$any$iv = layers;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GeomLayer it = (GeomLayer)element$iv;
                        boolean bl2 = false;
                        if (!it.rangeIncludesZero(aes)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            boolean bl3 = includeZero = bl;
            if (bl3) {
                closedRange = INSTANCE.updateRange((ClosedRange<Double>)ClosedRange.Companion.singleton((Comparable)Double.valueOf(0.0)), (ClosedRange<Double>)range);
            } else if (!bl3) {
                closedRange = range;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            ClosedRange range2 = closedRange;
            return PlotUtil.INSTANCE.rangeWithExpand$plot_builder_portable((ClosedRange<Double>)range2, scale, includeZero);
        }
    }
}

