/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.assemble;

import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.scale.ScaleBreaks;
import jetbrains.datalore.plot.base.scale.breaks.ScaleBreaksUtil;
import jetbrains.datalore.plot.builder.assemble.ColorBarOptions;
import jetbrains.datalore.plot.builder.assemble.LegendAssemblerUtil;
import jetbrains.datalore.plot.builder.guide.ColorBarComponent;
import jetbrains.datalore.plot.builder.guide.ColorBarComponentLayout;
import jetbrains.datalore.plot.builder.guide.ColorBarComponentSpec;
import jetbrains.datalore.plot.builder.guide.LegendBox;
import jetbrains.datalore.plot.builder.guide.LegendDirection;
import jetbrains.datalore.plot.builder.layout.LegendBoxInfo;
import jetbrains.datalore.plot.builder.theme.LegendTheme;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0017\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0002\b\u0014R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/datalore/plot/builder/assemble/ColorBarAssembler;", "", "legendTitle", "", "transformedDomain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "scale", "Ljetbrains/datalore/plot/base/Scale;", "Ljetbrains/datalore/base/values/Color;", "theme", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "(Ljava/lang/String;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/plot/base/Scale;Ljetbrains/datalore/plot/builder/theme/LegendTheme;)V", "colorBarOptions", "Ljetbrains/datalore/plot/builder/assemble/ColorBarOptions;", "createColorBar", "Ljetbrains/datalore/plot/builder/layout/LegendBoxInfo;", "setOptions", "", "options", "setOptions$plot_builder_portable", "Companion", "plot-builder-portable"})
public final class ColorBarAssembler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String legendTitle;
    @NotNull
    private final ClosedRange<Double> transformedDomain;
    @NotNull
    private final Scale<Color> scale;
    @NotNull
    private final LegendTheme theme;
    @Nullable
    private ColorBarOptions colorBarOptions;
    private static final boolean DEBUG_DRAWING = false;

    public ColorBarAssembler(@NotNull String legendTitle, @NotNull ClosedRange<Double> transformedDomain, @NotNull Scale<Color> scale, @NotNull LegendTheme theme) {
        Intrinsics.checkNotNullParameter((Object)legendTitle, (String)"legendTitle");
        Intrinsics.checkNotNullParameter(transformedDomain, (String)"transformedDomain");
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.legendTitle = legendTitle;
        this.transformedDomain = transformedDomain;
        this.scale = scale;
        this.theme = theme;
    }

    @NotNull
    public final LegendBoxInfo createColorBar() {
        ScaleBreaks scaleBreaks;
        Scale scale = this.scale;
        if (!scale.hasBreaks()) {
            scale = ScaleBreaksUtil.INSTANCE.withBreaks(scale, this.transformedDomain, 5);
        }
        if ((scaleBreaks = scale.getScaleBreaks()).isEmpty()) {
            return LegendBoxInfo.Companion.getEMPTY();
        }
        ColorBarComponentSpec spec = Companion.createColorBarSpec(this.legendTitle, this.transformedDomain, scaleBreaks, (Scale<Color>)scale, this.theme, this.colorBarOptions);
        DoubleVector doubleVector = spec.getSize();
        return new LegendBoxInfo(spec, doubleVector){
            final /* synthetic */ ColorBarComponentSpec $spec;
            {
                this.$spec = $spec;
                super($super_call_param$1);
            }

            @NotNull
            public LegendBox createLegendBox() {
                ColorBarComponent c = new ColorBarComponent(this.$spec);
                c.setDebug(false);
                return c;
            }
        };
    }

    public final void setOptions$plot_builder_portable(@Nullable ColorBarOptions options) {
        this.colorBarOptions = options;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/plot/builder/assemble/ColorBarAssembler$Companion;", "", "()V", "DEBUG_DRAWING", "", "createColorBarSpec", "Ljetbrains/datalore/plot/builder/guide/ColorBarComponentSpec;", "title", "", "transformedDomain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "breaks", "Ljetbrains/datalore/plot/base/scale/ScaleBreaks;", "scale", "Ljetbrains/datalore/plot/base/Scale;", "Ljetbrains/datalore/base/values/Color;", "theme", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "options", "Ljetbrains/datalore/plot/builder/assemble/ColorBarOptions;", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColorBarComponentSpec createColorBarSpec(@NotNull String title, @NotNull ClosedRange<Double> transformedDomain, @NotNull ScaleBreaks breaks, @NotNull Scale<Color> scale, @NotNull LegendTheme theme, @Nullable ColorBarOptions options) {
            Integer n;
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(transformedDomain, (String)"transformedDomain");
            Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter(scale, (String)"scale");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            LegendDirection legendDirection = LegendAssemblerUtil.INSTANCE.legendDirection(theme);
            boolean horizontal = legendDirection == LegendDirection.HORIZONTAL;
            ColorBarOptions colorBarOptions = options;
            Double width = colorBarOptions == null ? null : colorBarOptions.getWidth();
            ColorBarOptions colorBarOptions2 = options;
            Double height = colorBarOptions2 == null ? null : colorBarOptions2.getHeight();
            DoubleVector barSize = ColorBarComponentSpec.Companion.barAbsoluteSize$plot_builder_portable(horizontal, theme);
            if (width != null) {
                barSize = new DoubleVector(width.doubleValue(), barSize.getY());
            }
            if (height != null) {
                barSize = new DoubleVector(barSize.getX(), height.doubleValue());
            }
            boolean reverse = !horizontal;
            ColorBarComponentLayout layout = horizontal ? ColorBarComponentLayout.Companion.horizontal(title, transformedDomain, breaks, barSize, reverse) : ColorBarComponentLayout.Companion.vertical(title, transformedDomain, breaks, barSize, reverse);
            ColorBarOptions colorBarOptions3 = options;
            return new ColorBarComponentSpec(title, transformedDomain, breaks, scale, colorBarOptions3 == null ? 20 : ((n = colorBarOptions3.getBinCount()) == null ? 20 : n), theme, layout, reverse);
        }

        public static /* synthetic */ ColorBarComponentSpec createColorBarSpec$default(Companion companion, String string, ClosedRange closedRange, ScaleBreaks scaleBreaks, Scale scale, LegendTheme legendTheme, ColorBarOptions colorBarOptions, int n, Object object) {
            if ((n & 0x20) != 0) {
                colorBarOptions = null;
            }
            return companion.createColorBarSpec(string, (ClosedRange<Double>)closedRange, scaleBreaks, (Scale<Color>)scale, legendTheme, colorBarOptions);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

